/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.handler.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.handler.internal.URLStreamHandlerExtender;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Log LOGGER = LogFactory.getLog(Activator.class);
    private BundleContext m_bundleContext;
    private ServiceTracker m_serviceTracker;
    private URLStreamHandlerExtender m_extender;

    public void start(BundleContext bundleContext) throws Exception {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        this.m_bundleContext = bundleContext;
        this.m_extender = this.createExtender();
        this.m_extender.start();
        this.trackURLStreamHandlerService();
        LOGGER.debug("URL stream handler service extender started");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        if (this.m_serviceTracker != null) {
            this.m_serviceTracker.close();
            this.m_serviceTracker = null;
        }
        this.m_extender = null;
        this.m_bundleContext = null;
        LOGGER.debug("URL stream handler service extender stopped");
    }

    private void trackURLStreamHandlerService() {
        this.m_serviceTracker = new ServiceTracker(this.m_bundleContext, URLStreamHandlerService.class.getName(), null){

            public Object addingService(ServiceReference serviceReference) {
                NullArgumentException.validateNotNull(serviceReference, "Service reference");
                LOGGER.debug("URL stream handler service available [" + serviceReference + "]");
                URLStreamHandlerService streamHandler = (URLStreamHandlerService)super.addingService(serviceReference);
                if (streamHandler != null) {
                    Activator.this.m_extender.register((String[])serviceReference.getProperty("url.handler.protocol"), streamHandler);
                }
                return streamHandler;
            }

            public void removedService(ServiceReference serviceReference, Object object) {
                LOGGER.debug("URL stream handler service removed [" + serviceReference + "]");
                if (!(object instanceof URLStreamHandlerService)) {
                    throw new IllegalArgumentException("Invalid tracked object [" + object.getClass() + "]. Expected an " + URLStreamHandlerService.class.getName());
                }
                Activator.this.m_extender.unregister((String[])serviceReference.getProperty("url.handler.protocol"));
                super.removedService(serviceReference, object);
            }
        };
        this.m_serviceTracker.open();
    }

    private URLStreamHandlerExtender createExtender() {
        return new URLStreamHandlerExtender();
    }
}

