/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.def;

import java.util.ArrayList;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.container.def.options.AutoWrapOption;
import org.ops4j.pax.exam.container.def.options.BundleScannerProvisionOption;
import org.ops4j.pax.exam.container.def.options.CleanCachesOption;
import org.ops4j.pax.exam.container.def.options.CompositeScannerProvisionOption;
import org.ops4j.pax.exam.container.def.options.DirScannerProvisionOption;
import org.ops4j.pax.exam.container.def.options.ExcludeDefaultRepositoriesOption;
import org.ops4j.pax.exam.container.def.options.FeaturesScannerProvisionOption;
import org.ops4j.pax.exam.container.def.options.FileScannerProvisionOption;
import org.ops4j.pax.exam.container.def.options.LocalRepositoryOption;
import org.ops4j.pax.exam.container.def.options.PomScannerProvisionOption;
import org.ops4j.pax.exam.container.def.options.ProfileOption;
import org.ops4j.pax.exam.container.def.options.RBCLookupTimeoutOption;
import org.ops4j.pax.exam.container.def.options.RawPaxRunnerOptionOption;
import org.ops4j.pax.exam.container.def.options.RawScannerProvisionOption;
import org.ops4j.pax.exam.container.def.options.RepositoryOption;
import org.ops4j.pax.exam.container.def.options.RepositoryOptionImpl;
import org.ops4j.pax.exam.container.def.options.VMOption;
import org.ops4j.pax.exam.container.def.options.WorkingDirectoryOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.UrlReference;

public class PaxRunnerOptions {
    private PaxRunnerOptions() {
    }

    public static Option profiles(ProfileOption ... profiles) {
        return new DefaultCompositeOption((Option[])profiles);
    }

    public static ProfileOption profile(String name) {
        return new ProfileOption(name);
    }

    public static ProfileOption profile(String name, String version) {
        return new ProfileOption(name, version);
    }

    public static ProfileOption webProfile() {
        return new ProfileOption("web");
    }

    public static ProfileOption logProfile() {
        return new ProfileOption("log");
    }

    public static ProfileOption configProfile() {
        return new ProfileOption("config");
    }

    public static ProfileOption dsProfile() {
        return new ProfileOption("ds");
    }

    public static ProfileOption compendiumProfile() {
        return new ProfileOption("compendium");
    }

    public static CleanCachesOption cleanCaches() {
        return new CleanCachesOption();
    }

    public static RBCLookupTimeoutOption waitForRBCFor(Integer timeoutInMillis) {
        return new RBCLookupTimeoutOption(timeoutInMillis.intValue());
    }

    public static Option vmOptions(String ... vmOptions) {
        NullArgumentException.validateNotEmptyContent((String[])vmOptions, (boolean)true, (String)"VM options");
        ArrayList<VMOption> options = new ArrayList<VMOption>();
        for (String vmOption : vmOptions) {
            options.add(PaxRunnerOptions.vmOption(vmOption));
        }
        return PaxRunnerOptions.vmOptions(options.toArray(new VMOption[options.size()]));
    }

    public static Option vmOptions(VMOption ... vmOptions) {
        return new DefaultCompositeOption((Option[])vmOptions);
    }

    public static VMOption vmOption(String vmOption) {
        return new VMOption(vmOption);
    }

    public static RawPaxRunnerOptionOption rawPaxRunnerOption(String key, String value) {
        return new RawPaxRunnerOptionOption(key, value);
    }

    public static RawPaxRunnerOptionOption rawPaxRunnerOption(String option) {
        return new RawPaxRunnerOptionOption(option);
    }

    public static Option repositories(String ... repositoryUrls) {
        NullArgumentException.validateNotEmptyContent((String[])repositoryUrls, (boolean)true, (String)"Repository URLs");
        ArrayList<RepositoryOption> options = new ArrayList<RepositoryOption>();
        for (String repositoryUrl : repositoryUrls) {
            options.add(PaxRunnerOptions.repository(repositoryUrl));
        }
        return PaxRunnerOptions.repositories(options.toArray(new RepositoryOption[options.size()]));
    }

    public static Option repositories(RepositoryOption ... repositoryOptions) {
        return new DefaultCompositeOption((Option[])repositoryOptions);
    }

    public static LocalRepositoryOption localRepository(String path) {
        return new LocalRepositoryOption(path);
    }

    public static RepositoryOption repository(String repositoryUrl) {
        return new RepositoryOptionImpl(repositoryUrl);
    }

    public static ExcludeDefaultRepositoriesOption excludeDefaultRepositories() {
        return new ExcludeDefaultRepositoriesOption();
    }

    public static RawScannerProvisionOption scan(String provisionSpec) {
        return new RawScannerProvisionOption(provisionSpec);
    }

    public static DirScannerProvisionOption scanDir(String directory) {
        return new DirScannerProvisionOption(directory);
    }

    public static PomScannerProvisionOption scanPom(String url) {
        return new PomScannerProvisionOption(url);
    }

    public static PomScannerProvisionOption scanPom() {
        return new PomScannerProvisionOption();
    }

    public static FileScannerProvisionOption scanFile(String fileUrl) {
        return new FileScannerProvisionOption(fileUrl);
    }

    public static FileScannerProvisionOption scanFile(UrlReference fileUrl) {
        return new FileScannerProvisionOption(fileUrl);
    }

    public static FeaturesScannerProvisionOption scanFeatures(String repositoryUrl, String ... features) {
        return new FeaturesScannerProvisionOption(repositoryUrl, features);
    }

    public static FeaturesScannerProvisionOption scanFeatures(UrlReference repositoryUrl, String ... features) {
        return new FeaturesScannerProvisionOption(repositoryUrl, features);
    }

    public static CompositeScannerProvisionOption scanComposite(String fileUrl) {
        return new CompositeScannerProvisionOption(fileUrl);
    }

    public static CompositeScannerProvisionOption scanComposite(UrlReference fileUrl) {
        return new CompositeScannerProvisionOption(fileUrl);
    }

    public static AutoWrapOption autoWrap() {
        return new AutoWrapOption();
    }

    public static BundleScannerProvisionOption scanBundle(String bundleUrl) {
        return new BundleScannerProvisionOption(bundleUrl);
    }

    public static BundleScannerProvisionOption scanBundle(UrlReference bundleUrl) {
        return new BundleScannerProvisionOption(bundleUrl);
    }

    public static WorkingDirectoryOption workingDirectory(String directory) {
        return new WorkingDirectoryOption(directory);
    }
}

