/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.DataStreamInfo;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class GetDataStreamResponse
implements JsonpSerializable {
    private final List<DataStreamInfo> dataStreams;
    public static final JsonpDeserializer<GetDataStreamResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDataStreamResponse::setupGetDataStreamResponseDeserializer);

    private GetDataStreamResponse(Builder builder) {
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
    }

    public static GetDataStreamResponse of(Function<Builder, ObjectBuilder<GetDataStreamResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<DataStreamInfo> dataStreams() {
        return this.dataStreams;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.dataStreams)) {
            generator.writeKey("data_streams");
            generator.writeStartArray();
            for (DataStreamInfo item : this.dataStreams) {
                item.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetDataStreamResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(DataStreamInfo._DESERIALIZER), "data_streams");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetDataStreamResponse> {
        private List<DataStreamInfo> dataStreams;

        public final Builder dataStreams(List<DataStreamInfo> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        @Override
        public GetDataStreamResponse build() {
            this._checkSingleUse();
            return new GetDataStreamResponse(this);
        }
    }
}

