/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.signature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Orbit
implements Iterable<Integer>,
Cloneable {
    private List<Integer> atomIndices;
    private String label;
    private int height;

    public Orbit(String label, int height) {
        this.label = label;
        this.atomIndices = new ArrayList<Integer>();
        this.height = height;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.atomIndices.iterator();
    }

    public Object clone() {
        Orbit orbit = new Orbit(this.label, this.height);
        for (Integer i : this.atomIndices) {
            orbit.atomIndices.add((int)i);
        }
        return orbit;
    }

    public void sort() {
        Collections.sort(this.atomIndices);
    }

    public int getHeight() {
        return this.height;
    }

    public List<Integer> getAtomIndices() {
        return this.atomIndices;
    }

    public void addAtom(int atomIndex) {
        this.atomIndices.add(atomIndex);
    }

    public boolean hasLabel(String otherLabel) {
        return this.label.equals(otherLabel);
    }

    public boolean isEmpty() {
        return this.atomIndices.isEmpty();
    }

    public int getFirstAtom() {
        return this.atomIndices.get(0);
    }

    public void remove(int atomIndex) {
        this.atomIndices.remove(this.atomIndices.indexOf(atomIndex));
    }

    public String getLabel() {
        return this.label;
    }

    public boolean contains(int atomIndex) {
        return this.atomIndices.contains(atomIndex);
    }

    public String toString() {
        return this.label + " " + Arrays.deepToString(this.atomIndices.toArray());
    }
}

