/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.rebond.RebondTool;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPDBAtom;
import org.openscience.cdk.interfaces.IPDBStructure;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PDBFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.protein.data.PDBAtom;
import org.openscience.cdk.protein.data.PDBMonomer;
import org.openscience.cdk.protein.data.PDBPolymer;
import org.openscience.cdk.protein.data.PDBStrand;
import org.openscience.cdk.protein.data.PDBStructure;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

public class PDBReader
extends DefaultChemObjectReader {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(PDBReader.class);
    private BufferedReader _oInput;
    private BooleanIOSetting useRebondTool;
    private BooleanIOSetting readConnect;
    private BooleanIOSetting useHetDictionary;
    private Map<Integer, IAtom> atomNumberMap;
    private List<IBond> bondsFromConnectRecords;
    private Map<String, String> hetDictionary;
    private AtomTypeFactory cdkAtomTypeFactory;
    private static final String hetDictionaryPath = "type_map.txt";

    public PDBReader(InputStream oIn) {
        this(new InputStreamReader(oIn));
    }

    public PDBReader(Reader oIn) {
        this._oInput = new BufferedReader(oIn);
        this.initIOSettings();
        this.hetDictionary = null;
        this.cdkAtomTypeFactory = null;
    }

    public PDBReader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return PDBFormat.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this._oInput = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T oObj) throws CDKException {
        if (oObj instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)oObj);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemFile oFile) {
        IChemSequence oSeq = (IChemSequence)oFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel oModel = (IChemModel)oFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet oSet = (IAtomContainerSet)oFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        PDBPolymer oBP = new PDBPolymer();
        IAtomContainer molecularStructure = (IAtomContainer)oFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        String cRead = "";
        char chain = 'A';
        int lineLength = 0;
        boolean isProteinStructure = false;
        this.atomNumberMap = new Hashtable<Integer, IAtom>();
        if (this.readConnect.isSet()) {
            this.bondsFromConnectRecords = new ArrayList<IBond>();
        }
        try {
            do {
                PDBStrand oStrand;
                PDBAtom oAtom;
                String cCol;
                cRead = this._oInput.readLine();
                logger.debug((Object)"Read line: ", new Object[]{cRead});
                if (cRead == null) continue;
                lineLength = cRead.length();
                if (lineLength < 6) {
                    cRead = cRead + "      ";
                }
                if ("SEQRES".equalsIgnoreCase(cCol = cRead.substring(0, 6))) {
                    isProteinStructure = true;
                    continue;
                }
                if ("ATOM  ".equalsIgnoreCase(cCol)) {
                    oAtom = this.readAtom(cRead, lineLength);
                    if (isProteinStructure) {
                        IMonomer oMonomer;
                        String strandName;
                        StringBuffer cResidue = new StringBuffer(8);
                        String oObj = oAtom.getResName();
                        if (oObj != null) {
                            cResidue = cResidue.append(oObj.trim());
                        }
                        if ((oObj = oAtom.getChainID()) != null) {
                            cResidue = cResidue.append(String.valueOf(chain));
                        }
                        if ((oObj = oAtom.getResSeq()) != null) {
                            cResidue = cResidue.append(oObj.trim());
                        }
                        if ((strandName = oAtom.getChainID()) == null || strandName.length() == 0) {
                            strandName = String.valueOf(chain);
                        }
                        if ((oStrand = oBP.getStrand(strandName)) == null) {
                            oStrand = new PDBStrand();
                            oStrand.setStrandName(strandName);
                            oStrand.setID(String.valueOf(chain));
                        }
                        if ((oMonomer = oBP.getMonomer(cResidue.toString(), String.valueOf(chain))) == null) {
                            PDBMonomer monomer = new PDBMonomer();
                            monomer.setMonomerName(cResidue.toString());
                            monomer.setMonomerType(oAtom.getResName());
                            monomer.setChainID(oAtom.getChainID());
                            monomer.setICode(oAtom.getICode());
                            monomer.setResSeq(oAtom.getResSeq());
                            oMonomer = monomer;
                        }
                        oBP.addAtom((IPDBAtom)oAtom, oMonomer, (IStrand)oStrand);
                    } else {
                        molecularStructure.addAtom((IAtom)oAtom);
                    }
                    if (this.readConnect.isSet() && this.atomNumberMap.put(oAtom.getSerial(), (IAtom)oAtom) != null) {
                        logger.warn((Object)"Duplicate serial ID found for atom: ", new Object[]{oAtom});
                    }
                    logger.debug((Object)"Added ATOM: ", new Object[]{oAtom});
                    continue;
                }
                if ("HETATM".equalsIgnoreCase(cCol)) {
                    oAtom = this.readAtom(cRead, lineLength);
                    oAtom.setHetAtom(Boolean.valueOf(true));
                    if (isProteinStructure) {
                        oBP.addAtom((IPDBAtom)oAtom);
                    } else {
                        molecularStructure.addAtom((IAtom)oAtom);
                    }
                    if (this.atomNumberMap.put(oAtom.getSerial(), (IAtom)oAtom) != null) {
                        logger.warn((Object)"Duplicate serial ID found for atom: ", new Object[]{oAtom});
                    }
                    logger.debug((Object)"Added HETATM: ", new Object[]{oAtom});
                    continue;
                }
                if ("TER   ".equalsIgnoreCase(cCol)) {
                    chain = (char)(chain + 1);
                    oStrand = new PDBStrand();
                    oStrand.setStrandName(String.valueOf(chain));
                    logger.debug((Object)"Added new STRAND");
                    continue;
                }
                if ("END   ".equalsIgnoreCase(cCol)) {
                    this.atomNumberMap.clear();
                    if (isProteinStructure) {
                        oSet.addAtomContainer((IAtomContainer)oBP);
                        if (!this.useRebondTool.isSet()) continue;
                        try {
                            if (this.createBondsWithRebondTool((IAtomContainer)oBP)) continue;
                            logger.info((Object)"Bonds could not be created using the RebondTool when PDB file was read.");
                            oBP.removeAllBonds();
                        }
                        catch (Exception exception) {
                            logger.info((Object)"Bonds could not be created when PDB file was read.");
                            logger.debug((Object)exception);
                        }
                        continue;
                    }
                    if (this.useRebondTool.isSet()) {
                        this.createBondsWithRebondTool(molecularStructure);
                    }
                    oSet.addAtomContainer(molecularStructure);
                    continue;
                }
                if (cCol.equals("MODEL ")) {
                    if (isProteinStructure) {
                        if (oBP.getAtomCount() <= 0) continue;
                        oSet.addAtomContainer((IAtomContainer)oBP);
                        oModel.setMoleculeSet(oSet);
                        oSeq.addChemModel(oModel);
                        oBP = new PDBPolymer();
                        oModel = (IChemModel)oFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                        oSet = (IAtomContainerSet)oFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                        this.atomNumberMap.clear();
                        continue;
                    }
                    if (molecularStructure.getAtomCount() <= 0) continue;
                    oSet.addAtomContainer(molecularStructure);
                    oModel.setMoleculeSet(oSet);
                    oSeq.addChemModel(oModel);
                    molecularStructure = (IAtomContainer)oFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                    oModel = (IChemModel)oFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    oSet = (IAtomContainerSet)oFile.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    continue;
                }
                if ("REMARK".equalsIgnoreCase(cCol)) {
                    Object comment = oFile.getProperty((Object)"cdk:Comment");
                    if (comment == null) {
                        comment = "";
                    }
                    if (lineLength > 12) {
                        comment = comment.toString() + cRead.substring(11).trim() + "\n";
                        oFile.setProperty((Object)"cdk:Comment", comment);
                        continue;
                    }
                    logger.warn((Object)"REMARK line found without any comment!");
                    continue;
                }
                if ("COMPND".equalsIgnoreCase(cCol)) {
                    String title = cRead.substring(10).trim();
                    oFile.setProperty((Object)"cdk:Title", (Object)title);
                    continue;
                }
                if (this.readConnect.isSet() && "CONECT".equalsIgnoreCase(cCol)) {
                    PDBPolymer molecule;
                    cRead.trim();
                    if (cRead.length() < 16) {
                        logger.debug((Object)"Skipping unexpected empty CONECT line! : ", new Object[]{cRead});
                        continue;
                    }
                    int lineIndex = 6;
                    int atomFromNumber = -1;
                    int atomToNumber = -1;
                    Object object = molecule = isProteinStructure ? oBP : molecularStructure;
                    while (lineIndex + 5 <= cRead.length()) {
                        String part = cRead.substring(lineIndex, lineIndex + 5).trim();
                        if (atomFromNumber == -1) {
                            try {
                                atomFromNumber = Integer.parseInt(part);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            try {
                                atomToNumber = Integer.parseInt(part);
                            }
                            catch (NumberFormatException nfe) {
                                atomToNumber = -1;
                            }
                            if (atomFromNumber != -1 && atomToNumber != -1) {
                                this.addBond((IAtomContainer)molecule, atomFromNumber, atomToNumber);
                                logger.debug((Object)("Bonded " + atomFromNumber + " with " + atomToNumber));
                            }
                        }
                        lineIndex += 5;
                    }
                    continue;
                }
                if ("HELIX ".equalsIgnoreCase(cCol)) {
                    PDBStructure structure = new PDBStructure();
                    structure.setStructureType("helix");
                    structure.setStartChainID(Character.valueOf(cRead.charAt(19)));
                    structure.setStartSequenceNumber(Integer.valueOf(Integer.parseInt(cRead.substring(21, 25).trim())));
                    structure.setStartInsertionCode(Character.valueOf(cRead.charAt(25)));
                    structure.setEndChainID(Character.valueOf(cRead.charAt(31)));
                    structure.setEndSequenceNumber(Integer.valueOf(Integer.parseInt(cRead.substring(33, 37).trim())));
                    structure.setEndInsertionCode(Character.valueOf(cRead.charAt(37)));
                    oBP.addStructure((IPDBStructure)structure);
                    continue;
                }
                if ("SHEET ".equalsIgnoreCase(cCol)) {
                    PDBStructure structure = new PDBStructure();
                    structure.setStructureType("sheet");
                    structure.setStartChainID(Character.valueOf(cRead.charAt(21)));
                    structure.setStartSequenceNumber(Integer.valueOf(Integer.parseInt(cRead.substring(22, 26).trim())));
                    structure.setStartInsertionCode(Character.valueOf(cRead.charAt(26)));
                    structure.setEndChainID(Character.valueOf(cRead.charAt(32)));
                    structure.setEndSequenceNumber(Integer.valueOf(Integer.parseInt(cRead.substring(33, 37).trim())));
                    structure.setEndInsertionCode(Character.valueOf(cRead.charAt(37)));
                    oBP.addStructure((IPDBStructure)structure);
                    continue;
                }
                if (!"TURN  ".equalsIgnoreCase(cCol)) continue;
                PDBStructure structure = new PDBStructure();
                structure.setStructureType("turn");
                structure.setStartChainID(Character.valueOf(cRead.charAt(19)));
                structure.setStartSequenceNumber(Integer.valueOf(Integer.parseInt(cRead.substring(20, 24).trim())));
                structure.setStartInsertionCode(Character.valueOf(cRead.charAt(24)));
                structure.setEndChainID(Character.valueOf(cRead.charAt(30)));
                structure.setEndSequenceNumber(Integer.valueOf(Integer.parseInt(cRead.substring(31, 35).trim())));
                structure.setEndInsertionCode(Character.valueOf(cRead.charAt(35)));
                oBP.addStructure((IPDBStructure)structure);
            } while (this._oInput.ready() && cRead != null);
        }
        catch (IOException | IllegalArgumentException | CDKException e) {
            logger.error((Object)"Found a problem at line:");
            logger.error((Object)cRead);
            logger.error((Object)"01234567890123456789012345678901234567890123456789012345678901234567890123456789");
            logger.error((Object)"          1         2         3         4         5         6         7         ");
            logger.error((Object)("  error: " + e.getMessage()));
            logger.debug((Object)e);
            e.printStackTrace();
        }
        try {
            this._oInput.close();
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
        oModel.setMoleculeSet(oSet);
        oSeq.addChemModel(oModel);
        oFile.addChemSequence(oSeq);
        return oFile;
    }

    private void addBond(IAtomContainer molecule, int bondAtomNo, int bondedAtomNo) {
        IAtom firstAtom = this.atomNumberMap.get(bondAtomNo);
        IAtom secondAtom = this.atomNumberMap.get(bondedAtomNo);
        if (firstAtom == null) {
            logger.error((Object)"Could not find bond start atom in map with serial id: ", new Object[]{bondAtomNo});
        }
        if (secondAtom == null) {
            logger.error((Object)"Could not find bond target atom in map with serial id: ", new Object[]{bondAtomNo});
        }
        IBond bond = (IBond)firstAtom.getBuilder().newInstance(IBond.class, new Object[]{firstAtom, secondAtom, IBond.Order.SINGLE});
        for (int i = 0; i < this.bondsFromConnectRecords.size(); ++i) {
            IBond existingBond = this.bondsFromConnectRecords.get(i);
            IAtom a = existingBond.getBegin();
            IAtom b = existingBond.getEnd();
            if ((!a.equals(firstAtom) || !b.equals(secondAtom)) && (!b.equals(firstAtom) || !a.equals(secondAtom))) continue;
            return;
        }
        this.bondsFromConnectRecords.add(bond);
        molecule.addBond(bond);
    }

    private boolean createBondsWithRebondTool(IAtomContainer molecule) {
        RebondTool tool = new RebondTool(2.0, 0.5, 0.5);
        try {
            AtomTypeFactory factory = AtomTypeFactory.getInstance((String)"org/openscience/cdk/config/data/jmol_atomtypes.txt", (IChemObjectBuilder)molecule.getBuilder());
            for (IAtom atom : molecule.atoms()) {
                try {
                    IAtomType[] types = factory.getAtomTypes(atom.getSymbol());
                    if (types.length > 0) {
                        AtomTypeManipulator.configure((IAtom)atom, (IAtomType)types[0]);
                        continue;
                    }
                    logger.warn((Object)("Could not configure atom with symbol: " + atom.getSymbol()));
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not configure atom (but don't care): " + e.getMessage()));
                    logger.debug((Object)e);
                }
            }
            tool.rebond(molecule);
        }
        catch (Exception e) {
            logger.error((Object)("Could not rebond the polymer: " + e.getMessage()));
            logger.debug((Object)e);
        }
        return true;
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private String parseAtomSymbol(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        int len = str.length();
        StringBuilder sym = new StringBuilder();
        if (len > 76 && PDBReader.isUpper(str.charAt(76))) {
            sym.append(str.charAt(76));
            if (len > 77 && PDBReader.isUpper(str.charAt(77))) {
                sym.append(Character.toLowerCase(str.charAt(77)));
            } else if (len > 77 && PDBReader.isLower(str.charAt(77))) {
                sym.append(Character.toLowerCase(str.charAt(77)));
            }
        } else if (len > 76 && str.charAt(76) == ' ' && len > 77 && PDBReader.isUpper(str.charAt(77))) {
            sym.append(str.charAt(77));
        }
        if (sym.length() > 0) {
            return sym.toString();
        }
        if (len > 13 && PDBReader.isUpper(str.charAt(13))) {
            if (str.charAt(12) == ' ') {
                sym.append(str.charAt(13));
                if (PDBReader.isLower(str.charAt(14))) {
                    sym.append(str.charAt(14));
                }
            } else if (PDBReader.isUpper(str.charAt(12))) {
                if (str.charAt(0) == 'A' && str.charAt(12) == 'H') {
                    sym.append('H');
                } else {
                    sym.append(str.charAt(12));
                    sym.append(Character.toLowerCase(str.charAt(13)));
                }
            } else if (PDBReader.isDigit(str.charAt(12))) {
                sym.append(str.charAt(13));
            }
        }
        if (sym.length() > 0) {
            return sym.toString();
        }
        return null;
    }

    private PDBAtom readAtom(String cLine, int lineLength) throws CDKException {
        String oxt;
        String frag;
        if (lineLength < 59) {
            throw new RuntimeException("PDBReader error during readAtom(): line too short");
        }
        boolean isHetatm = cLine.substring(0, 6).equals("HETATM");
        String atomName = cLine.substring(12, 16).trim();
        String resName = cLine.substring(17, 20).trim();
        String symbol = this.parseAtomSymbol(cLine);
        if (symbol == null) {
            this.handleError("Cannot parse symbol from " + atomName);
        }
        PDBAtom oAtom = new PDBAtom(symbol, new Point3d(Double.parseDouble(cLine.substring(30, 38)), Double.parseDouble(cLine.substring(38, 46)), Double.parseDouble(cLine.substring(46, 54))));
        if (this.useHetDictionary.isSet() && isHetatm) {
            String cdkType = this.typeHetatm(resName, atomName);
            oAtom.setAtomTypeName(cdkType);
            if (cdkType != null) {
                try {
                    this.cdkAtomTypeFactory.configure((IAtom)oAtom);
                }
                catch (CDKException cdke) {
                    logger.warn((Object)"Could not configure", new Object[]{resName, " ", atomName});
                }
            }
        }
        oAtom.setRecord(cLine);
        oAtom.setSerial(Integer.valueOf(Integer.parseInt(cLine.substring(6, 11).trim())));
        oAtom.setName(atomName.trim());
        oAtom.setAltLoc(cLine.substring(16, 17).trim());
        oAtom.setResName(resName);
        oAtom.setChainID(cLine.substring(21, 22).trim());
        oAtom.setResSeq(cLine.substring(22, 26).trim());
        oAtom.setICode(cLine.substring(26, 27).trim());
        if (this.useHetDictionary.isSet() && isHetatm) {
            oAtom.setID(oAtom.getResName() + "." + atomName);
        } else {
            oAtom.setAtomTypeName(oAtom.getResName() + "." + atomName);
        }
        if (lineLength >= 59 && (frag = cLine.substring(54, Math.min(lineLength, 60)).trim()).length() > 0) {
            oAtom.setOccupancy(Double.valueOf(Double.parseDouble(frag)));
        }
        if (lineLength >= 65 && (frag = cLine.substring(60, Math.min(lineLength, 66)).trim()).length() > 0) {
            oAtom.setTempFactor(Double.valueOf(Double.parseDouble(frag)));
        }
        if (lineLength >= 75) {
            oAtom.setSegID(cLine.substring(72, Math.min(lineLength, 76)).trim());
        }
        if (lineLength >= 79 && (frag = lineLength >= 80 ? cLine.substring(78, 80).trim() : cLine.substring(78)).length() > 0) {
            if (frag.endsWith("-") || frag.endsWith("+")) {
                oAtom.setCharge(Double.valueOf(Double.parseDouble(new StringBuilder(frag).reverse().toString())));
            } else {
                oAtom.setCharge(Double.valueOf(Double.parseDouble(frag)));
            }
        }
        if ((oxt = cLine.substring(13, 16).trim()).equals("OXT")) {
            oAtom.setOxt(Boolean.valueOf(true));
        } else {
            oAtom.setOxt(Boolean.valueOf(false));
        }
        return oAtom;
    }

    private String typeHetatm(String resName, String atomName) {
        String key;
        if (this.hetDictionary == null) {
            this.readHetDictionary();
            this.cdkAtomTypeFactory = AtomTypeFactory.getInstance((String)"org/openscience/cdk/dict/data/cdk-atom-types.owl", (IChemObjectBuilder)DefaultChemObjectBuilder.getInstance());
        }
        if (this.hetDictionary.containsKey(key = resName + "." + atomName)) {
            return this.hetDictionary.get(key);
        }
        return null;
    }

    private void readHetDictionary() {
        try {
            String line;
            InputStream ins = ((Object)((Object)this)).getClass().getResourceAsStream(hetDictionaryPath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ins));
            this.hetDictionary = new HashMap<String, String>();
            while ((line = bufferedReader.readLine()) != null) {
                int colonIndex = line.indexOf(58);
                if (colonIndex == -1) continue;
                String typeKey = line.substring(0, colonIndex);
                String typeValue = line.substring(colonIndex + 1);
                if (typeValue.equals("null")) {
                    this.hetDictionary.put(typeKey, null);
                    continue;
                }
                this.hetDictionary.put(typeKey, typeValue);
            }
            bufferedReader.close();
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage());
        }
    }

    public void close() throws IOException {
        this._oInput.close();
    }

    private void initIOSettings() {
        this.useRebondTool = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("UseRebondTool", IOSetting.Importance.LOW, "Should the PDBReader deduce bonding patterns?", "false"));
        this.readConnect = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("ReadConnectSection", IOSetting.Importance.LOW, "Should the CONECT be read?", "true"));
        this.useHetDictionary = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("UseHetDictionary", IOSetting.Importance.LOW, "Should the PDBReader use the HETATM dictionary for atom types?", "false"));
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }
}

