/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.format.LineBreaks;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class NormalizeLineBreaksVisitor<P>
extends XmlIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final GeneralFormatStyle style;

    public NormalizeLineBreaksVisitor(GeneralFormatStyle style) {
        this(style, null);
    }

    public NormalizeLineBreaksVisitor(GeneralFormatStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    public @Nullable Xml visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Xml)tree;
        }
        if (tree instanceof Xml) {
            Xml x = (Xml)super.visit(tree, p);
            assert (x != null);
            return x.withPrefix(LineBreaks.normalizeNewLines((String)x.getPrefix(), (boolean)this.style.isUseCRLFNewLines()));
        }
        return (Xml)super.visit(tree, p);
    }

    public @Nullable Xml postVisit(Xml tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "stop", (Object)true);
        }
        return (Xml)super.postVisit((Tree)tree, p);
    }
}

