/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.csharp.CSharpFileChecker;

@Incubating(since="7.0.0")
public class CovariantEquals
extends Recipe {
    private static final MethodMatcher EQUALS_MATCHER = new MethodMatcher("* equals(..)");
    private static final MethodMatcher EQUALS_OBJECT_MATCHER = new MethodMatcher("* equals(java.lang.Object)");
    private static final AnnotationMatcher OVERRIDE_ANNOTATION = new AnnotationMatcher("@java.lang.Override");

    public String getDisplayName() {
        return "Covariant equals";
    }

    public String getDescription() {
        return "Checks that classes and records which define a covariant `equals()` method also override method `equals(Object)`. Covariant `equals()` means a method that is similar to `equals(Object)`, but with a covariant parameter type (any subtype of `Object`).";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2162");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor conditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new DeclaresMethod(EQUALS_MATCHER), Preconditions.not((TreeVisitor)new DeclaresMethod(EQUALS_OBJECT_MATCHER)), Preconditions.not(new CSharpFileChecker())});
        return Preconditions.check((TreeVisitor)conditions, (TreeVisitor)Repeat.repeatUntilStable((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().dropParentUntil(p -> p instanceof J.ClassDeclaration).getValue();
                JavaType.FullyQualified type = enclosingClass.getType();
                if (type == null || type instanceof JavaType.Unknown) {
                    return m;
                }
                String ecfqn = type.getFullyQualifiedName();
                if (m.hasModifier(J.Modifier.Type.Public) && m.getReturnTypeExpression() != null && JavaType.Primitive.Boolean == m.getReturnTypeExpression().getType() && new MethodMatcher(ecfqn + " equals(" + ecfqn + ")").matches(m, enclosingClass)) {
                    J.VariableDeclarations.NamedVariable oldParamName;
                    if (!((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), OVERRIDE_ANNOTATION)) {
                        m = (J.MethodDeclaration)JavaTemplate.builder((String)"@Override").build().apply(this.updateCursor((Tree)m), m.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                    }
                    String paramName = "obj".equals((oldParamName = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)m.getParameters().get(0)).getVariables().get(0)).getSimpleName()) ? "other" : "obj";
                    m = (J.MethodDeclaration)JavaTemplate.builder((String)"Object #{}").build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceParameters(), new Object[]{paramName});
                    String equalsBodyPrefixTemplate = "if (#{} == this) return true;\nif (#{} == null || getClass() != #{}.getClass()) return false;\n#{} #{} = (#{}) #{};\n";
                    JavaTemplate equalsBodySnippet = JavaTemplate.builder((String)equalsBodyPrefixTemplate).contextSensitive().build();
                    assert (m.getBody() != null);
                    Object[] params = new Object[]{paramName, paramName, paramName, enclosingClass.getSimpleName(), oldParamName.getSimpleName(), enclosingClass.getSimpleName(), paramName};
                    m = (J.MethodDeclaration)equalsBodySnippet.apply(new Cursor(this.getCursor().getParent(), (Object)m), ((Statement)m.getBody().getStatements().get(0)).getCoordinates().before(), params);
                }
                return m;
            }
        }));
    }
}

