/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Modernize `BufferedWriter` creation & prevent file descriptor leaks", description="The code `new BufferedWriter(new FileWriter(f))` creates a `BufferedWriter` that does not close the underlying `FileWriter` when it is closed. This can lead to file descriptor leaks as per [CWE-755](https://cwe.mitre.org/data/definitions/755.html). Use `Files.newBufferedWriter` to create a `BufferedWriter` that closes the underlying file descriptor when it is closed.")
public class BufferedWriterCreation {

    @RecipeDescriptor(name="Convert `new BufferedWriter(new FileWriter(String, boolean))` to `Files.newBufferedWriter(Path, StandardOpenOption)`", description="Convert `new BufferedWriter(new FileWriter(s, b))` to `Files.newBufferedWriter(new java.io.File(s).toPath(), b ? StandardOpenOption.APPEND : StandardOpenOption.CREATE)`.")
    static class BufferedWriterFromNewFileWriterWithStringAndBooleanArguments {
        BufferedWriterFromNewFileWriterWithStringAndBooleanArguments() {
        }

        BufferedWriter before(String s, Boolean b) throws IOException {
            return new BufferedWriter(new FileWriter(s, (boolean)b));
        }

        BufferedWriter after(String s, Boolean b) throws IOException {
            return Files.newBufferedWriter(new File(s).toPath(), b != false ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
        }
    }

    @RecipeDescriptor(name="Convert `new BufferedWriter(new FileWriter(File, boolean))` to `Files.newBufferedWriter(Path, StandardOpenOption)`", description="Convert `new BufferedWriter(new FileWriter(f, b))` to `Files.newBufferedWriter(f.toPath(), b ? StandardOpenOption.APPEND : StandardOpenOption.CREATE)`.")
    static class BufferedWriterFromNewFileWriterWithFileAndBooleanArguments {
        BufferedWriterFromNewFileWriterWithFileAndBooleanArguments() {
        }

        BufferedWriter before(File f, Boolean b) throws IOException {
            return new BufferedWriter(new FileWriter(f, (boolean)b));
        }

        BufferedWriter after(File f, Boolean b) throws IOException {
            return Files.newBufferedWriter(f.toPath(), b != false ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
        }
    }

    @RecipeDescriptor(name="Convert `new BufferedWriter(new FileWriter(String))` to `Files.newBufferedWriter(Path)`", description="Convert `new BufferedWriter(new FileWriter(s))` to `Files.newBufferedWriter(new java.io.File(s).toPath())`.")
    static class BufferedWriterFromNewFileWriterWithStringArgument {
        BufferedWriterFromNewFileWriterWithStringArgument() {
        }

        BufferedWriter before(String s) throws IOException {
            return new BufferedWriter(new FileWriter(s));
        }

        BufferedWriter after(String s) throws IOException {
            return Files.newBufferedWriter(new File(s).toPath(), new OpenOption[0]);
        }
    }

    @RecipeDescriptor(name="Convert `new BufferedWriter(new FileWriter(File))` to `Files.newBufferedWriter(Path)`", description="Convert `new BufferedWriter(new FileWriter(f))` to `Files.newBufferedWriter(f.toPath())`.")
    static class BufferedWriterFromNewFileWriterWithFileArgument {
        BufferedWriterFromNewFileWriterWithFileArgument() {
        }

        BufferedWriter before(File f) throws IOException {
            return new BufferedWriter(new FileWriter(f));
        }

        BufferedWriter after(File f) throws IOException {
            return Files.newBufferedWriter(f.toPath(), new OpenOption[0]);
        }
    }
}

