/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractRustCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RustAxumServerCodegen
extends AbstractRustCodegen
implements CodegenConfig {
    public static final String PROJECT_NAME = "openapi-server";
    private static final String apiPath = "rust-axum";
    private String packageName;
    private String packageVersion;
    private Boolean disableValidator = false;
    private Boolean allowBlockingValidator = false;
    private Boolean allowBlockingResponseSerialize = false;
    private String externCrateName;
    private static final String uuidType = "uuid::Uuid";
    private static final String bytesType = "ByteArray";
    private static final String dateType = "chrono::naive::NaiveDate";
    private static final String dateTimeType = "chrono::DateTime::<chrono::Utc>";
    private static final String stringType = "String";
    private static final String objectType = "crate::types::Object";
    private static final String mapType = "std::collections::HashMap";
    private static final String vecType = "Vec";
    private static final String octetMimeType = "application/octet-stream";
    private static final String plainTextMimeType = "text/plain";
    private static final String xmlMimeType = "application/xml";
    private static final String textXmlMimeType = "text/xml";
    private static final String formUrlEncodedMimeType = "application/x-www-form-urlencoded";
    private static final String jsonMimeType = "application/json";
    private static final String mergePatchJsonMimeType = "application/merge-patch+json";
    private static final String problemJsonMimeType = "application/problem+json";
    private static final String problemXmlMimeType = "application/problem+xml";
    private final Map<String, ArrayList<MethodOperation>> pathMethodOpMap = new HashMap<String, ArrayList<MethodOperation>>();
    private final Logger LOGGER = LoggerFactory.getLogger(RustAxumServerCodegen.class);

    public RustAxumServerCodegen() {
        this.modifyFeatureSet(features -> features.wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.Custom)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.Info, GlobalFeature.ExternalDocumentation, GlobalFeature.Examples, GlobalFeature.XMLStructureDefinitions, GlobalFeature.MultiServer, GlobalFeature.ParameterizedServer, GlobalFeature.ParameterStyling, GlobalFeature.Callbacks, GlobalFeature.LinkObjects}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.hideGenerationTimestamp = Boolean.FALSE;
        this.outputFolder = Path.of("generated-code", apiPath).toString();
        this.templateDir = apiPath;
        this.embeddedTemplateDir = apiPath;
        this.importMapping = new HashMap();
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.clear();
        this.defaultIncludes = new HashSet<String>(Set.of("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Set.of("bool", "char", "i8", "i16", "i32", "i64", "u8", "u16", "u32", "u64", "isize", "usize", "f32", "f64", "str", stringType));
        assert (this.languageSpecificPrimitives.size() == 16);
        this.instantiationTypes = new HashMap<String, String>(Map.of("array", vecType, "map", mapType));
        assert (this.instantiationTypes.size() == 2);
        this.typeMapping = new HashMap(Map.ofEntries(new AbstractMap.SimpleEntry<String, String>("number", "f64"), new AbstractMap.SimpleEntry<String, String>("integer", "i32"), new AbstractMap.SimpleEntry<String, String>("long", "i64"), new AbstractMap.SimpleEntry<String, String>("float", "f32"), new AbstractMap.SimpleEntry<String, String>("double", "f64"), new AbstractMap.SimpleEntry<String, String>("string", stringType), new AbstractMap.SimpleEntry<String, String>("UUID", uuidType), new AbstractMap.SimpleEntry<String, String>("URI", stringType), new AbstractMap.SimpleEntry<String, String>("byte", "u8"), new AbstractMap.SimpleEntry<String, String>(bytesType, bytesType), new AbstractMap.SimpleEntry<String, String>("binary", bytesType), new AbstractMap.SimpleEntry<String, String>("boolean", "bool"), new AbstractMap.SimpleEntry<String, String>("date", dateType), new AbstractMap.SimpleEntry<String, String>("DateTime", dateTimeType), new AbstractMap.SimpleEntry<String, String>("password", stringType), new AbstractMap.SimpleEntry<String, String>("File", bytesType), new AbstractMap.SimpleEntry<String, String>("file", bytesType), new AbstractMap.SimpleEntry<String, String>("array", vecType), new AbstractMap.SimpleEntry<String, String>("map", mapType), new AbstractMap.SimpleEntry<String, String>("object", objectType), new AbstractMap.SimpleEntry<String, String>("AnyType", objectType)));
        assert (this.typeMapping.size() == 21);
        CliOption optDisableValidator = new CliOption("disableValidator", "Disable validating request-data (header, path, query, body) against OpenAPI Schema Specification.");
        optDisableValidator.setType("bool");
        optDisableValidator.defaultValue(this.disableValidator.toString());
        CliOption optAllowBlockingValidator = new CliOption("allowBlockingValidator", String.join((CharSequence)"", "By default, validation process, which might perform a lot of compute in a ", "future without yielding, is executed on a blocking thread via tokio::task::spawn_blocking. ", "Set this option to true will override this behaviour and allow blocking call to happen. ", "It helps to improve the performance when validating request-data (header, path, query, body) ", "is low cost."));
        optAllowBlockingValidator.setType("bool");
        optAllowBlockingValidator.defaultValue(this.allowBlockingValidator.toString());
        CliOption optAllowBlockingResponseSerialize = new CliOption("allowBlockingResponseSerialize", String.join((CharSequence)"", "By default, json/form-urlencoded response serialization, which might ", "perform a lot of compute in a future without yielding, is executed on a blocking thread ", "via tokio::task::spawn_blocking. Set this option to true will override this behaviour and ", "allow blocking call to happen. It helps to improve the performance when response ", "serialization (e.g. returns tiny data) is low cost."));
        optAllowBlockingResponseSerialize.setType("bool");
        optAllowBlockingResponseSerialize.defaultValue(this.allowBlockingResponseSerialize.toString());
        this.cliOptions = new ArrayList<CliOption>(List.of(new CliOption("packageName", "Rust crate name (convention: snake_case).").defaultValue("openapi"), new CliOption("packageVersion", "Rust crate version."), optDisableValidator, optAllowBlockingValidator, optAllowBlockingResponseSerialize));
        this.supportingFiles.add(new SupportingFile("Cargo.mustache", "", "Cargo.toml"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("lib.mustache", "src", "lib.rs"));
        this.supportingFiles.add(new SupportingFile("models.mustache", "src", "models.rs"));
        this.supportingFiles.add(new SupportingFile("types.mustache", "src", "types.rs"));
        this.supportingFiles.add(new SupportingFile("header.mustache", "src", "header.rs"));
        this.supportingFiles.add(new SupportingFile("server-mod.mustache", "src/server", "mod.rs"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md").doNotOverwrite());
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return apiPath;
    }

    @Override
    public String getHelp() {
        return "Generates a Rust server library which bases on Axum.";
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return compiler.emptyStringIsFalse(true).zeroIsFalse(true);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("RUST_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable RUST_POST_PROCESS_FILE not defined. rustfmt will be used by default. To choose a different tool, try 'export RUST_POST_PROCESS_FILE=\"/usr/local/bin/rustfmt\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true`  (--enable-post-process-file for CLI).");
        }
        if (!Boolean.TRUE.equals(ModelUtils.isGenerateAliasAsModel())) {
            this.LOGGER.warn("generateAliasAsModel is set to false, which means array/map will be generated as model instead and the resulting code may have issues. Please enable `generateAliasAsModel` to address the issue.");
        }
        this.setPackageName(this.additionalProperties.getOrDefault("packageName", "openapi"));
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("externCrateName", this.externCrateName);
        if (this.additionalProperties.containsKey("disableValidator")) {
            this.disableValidator = this.convertPropertyToBooleanAndWriteBack("disableValidator");
        } else {
            this.additionalProperties.put("disableValidator", this.disableValidator);
        }
        if (this.additionalProperties.containsKey("allowBlockingValidator")) {
            this.allowBlockingValidator = this.convertPropertyToBooleanAndWriteBack("allowBlockingValidator");
        } else {
            this.additionalProperties.put("allowBlockingValidator", this.allowBlockingValidator);
        }
        if (this.additionalProperties.containsKey("allowBlockingResponseSerialize")) {
            this.allowBlockingResponseSerialize = this.convertPropertyToBooleanAndWriteBack("allowBlockingResponseSerialize");
        } else {
            this.additionalProperties.put("allowBlockingResponseSerialize", this.allowBlockingResponseSerialize);
        }
    }

    private void setPackageName(String packageName) {
        this.packageName = packageName;
        this.externCrateName = packageName.replace('-', '_');
    }

    private void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String apiPackage() {
        return apiPath;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Info info = openAPI.getInfo();
        if (this.packageVersion == null || this.packageVersion.isEmpty()) {
            ArrayList<String> versionComponents = new ArrayList<String>(Arrays.asList(info.getVersion().split("[.]")));
            if (versionComponents.isEmpty()) {
                versionComponents.add("1");
            }
            while (versionComponents.size() < 3) {
                versionComponents.add("0");
            }
            this.setPackageVersion(String.join((CharSequence)".", versionComponents));
        }
        this.additionalProperties.put("packageVersion", this.packageVersion);
    }

    @Override
    public String toApiName(String name) {
        return name.isEmpty() ? "default" : this.sanitizeIdentifier(name, AbstractRustCodegen.CasingType.SNAKE_CASE, "api", "API", true);
    }

    @Override
    public String apiFileFolder() {
        return Path.of(this.outputFolder, this.apiPackage().replace('.', File.separatorChar)).toString();
    }

    @Override
    public String toOperationId(String operationId) {
        return this.sanitizeIdentifier(operationId, AbstractRustCodegen.CasingType.CAMEL_CASE, "call", "method", true);
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        return "\"" + super.toEnumValue(value, datatype) + "\"";
    }

    private boolean isObjectType(String type) {
        return "object".equals(type);
    }

    private boolean isMimetypeXml(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(xmlMimeType) || mimetype.toLowerCase(Locale.ROOT).startsWith(problemXmlMimeType) || mimetype.toLowerCase(Locale.ROOT).startsWith(textXmlMimeType);
    }

    private boolean isMimetypeJson(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(jsonMimeType) || mimetype.toLowerCase(Locale.ROOT).startsWith(mergePatchJsonMimeType) || mimetype.toLowerCase(Locale.ROOT).startsWith(problemJsonMimeType);
    }

    private boolean isMimetypeWwwFormUrlEncoded(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(formUrlEncodedMimeType);
    }

    private boolean isMimetypeMultipartFormData(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith("multipart/form-data");
    }

    private boolean isMimetypeMultipartRelated(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith("multipart/related");
    }

    private boolean isMimetypeUnknown(String mimetype) {
        return "*/*".equals(mimetype);
    }

    boolean isMimetypePlain(String mimetype) {
        return !this.isMimetypeUnknown(mimetype) && !this.isMimetypeJson(mimetype) && !this.isMimetypeWwwFormUrlEncoded(mimetype) && !this.isMimetypeMultipartFormData(mimetype) && !this.isMimetypeMultipartRelated(mimetype);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        String underscoredOperationId = StringUtils.underscore(op.operationId);
        op.vendorExtensions.put("x-operation-id", underscoredOperationId);
        op.vendorExtensions.put("x-uppercase-operation-id", underscoredOperationId.toUpperCase(Locale.ROOT));
        if (!op.isCallbackRequest) {
            String axumPath = op.path;
            for (CodegenParameter param : op.pathParams) {
                String paramSearch = "{" + param.baseName + "}";
                String string = ":" + param.paramName;
                axumPath = axumPath.replace(paramSearch, string);
            }
            this.pathMethodOpMap.computeIfAbsent(axumPath, key -> new ArrayList()).add(new MethodOperation(op.httpMethod.toLowerCase(Locale.ROOT), underscoredOperationId));
        }
        Set<String> producesInfo = RustAxumServerCodegen.getProducesInfo(this.openAPI, operation);
        boolean producesPlainText = false;
        boolean producesFormUrlEncoded = false;
        if (producesInfo != null && !producesInfo.isEmpty()) {
            ArrayList<Map<String, String>> produces = new ArrayList<Map<String, String>>(producesInfo.size());
            for (String mimeType : producesInfo) {
                if (this.isMimetypeWwwFormUrlEncoded(mimeType)) {
                    producesFormUrlEncoded = true;
                } else if (this.isMimetypePlain(mimeType)) {
                    producesPlainText = true;
                }
                HashMap<String, String> mediaType = new HashMap<String, String>();
                mediaType.put("mediaType", mimeType);
                produces.add(mediaType);
            }
            op.produces = produces;
            op.hasProduces = true;
        }
        for (CodegenResponse codegenResponse : op.responses) {
            ApiResponse original = "0".equals(codegenResponse.code) ? (ApiResponse)operation.getResponses().get((Object)"default") : (ApiResponse)operation.getResponses().get((Object)codegenResponse.code);
            String[] words = codegenResponse.message.split("[^A-Za-z ]");
            String responseId = "Status" + codegenResponse.code + (String)(words.length != 0 && !words[0].trim().isEmpty() ? "_" + StringUtils.camelize(words[0].replace(" ", "_")) : "");
            codegenResponse.vendorExtensions.put("x-response-id", responseId);
            if (codegenResponse.dataType != null) {
                String outputMime;
                String firstProduces = null;
                if (original.getContent() != null) {
                    firstProduces = original.getContent().keySet().stream().findFirst().orElse(null);
                }
                if (firstProduces == null) {
                    outputMime = producesFormUrlEncoded ? formUrlEncodedMimeType : (producesPlainText ? (bytesType.equals(codegenResponse.dataType) ? octetMimeType : plainTextMimeType) : jsonMimeType);
                } else {
                    if (this.isMimetypeWwwFormUrlEncoded(firstProduces)) {
                        producesFormUrlEncoded = true;
                        producesPlainText = false;
                    } else if (this.isMimetypePlain(firstProduces)) {
                        producesFormUrlEncoded = false;
                        producesPlainText = true;
                    } else {
                        producesFormUrlEncoded = false;
                        producesPlainText = false;
                    }
                    outputMime = firstProduces;
                    if (this.isMimetypeXml(outputMime)) {
                        outputMime = plainTextMimeType;
                    }
                }
                codegenResponse.vendorExtensions.put("x-mime-type", outputMime);
                if (producesFormUrlEncoded) {
                    codegenResponse.vendorExtensions.put("x-produces-form-urlencoded", true);
                } else if (producesPlainText) {
                    if (bytesType.equals(codegenResponse.dataType)) {
                        codegenResponse.vendorExtensions.put("x-produces-bytes", true);
                    } else {
                        codegenResponse.vendorExtensions.put("x-produces-plain-text", true);
                    }
                } else {
                    codegenResponse.vendorExtensions.put("x-produces-json", true);
                    if (this.isObjectType(codegenResponse.dataType)) {
                        codegenResponse.dataType = objectType;
                    }
                }
            }
            for (CodegenProperty header : codegenResponse.headers) {
                header.nameInCamelCase = this.toModelName(header.baseName);
                header.nameInLowerCase = header.baseName.toLowerCase(Locale.ROOT);
            }
        }
        for (CodegenParameter codegenParameter : op.headerParams) {
            codegenParameter.nameInLowerCase = codegenParameter.baseName.toLowerCase(Locale.ROOT);
        }
        for (CodegenProperty codegenProperty : op.responseHeaders) {
            codegenProperty.nameInCamelCase = this.toModelName(codegenProperty.baseName);
            codegenProperty.nameInLowerCase = codegenProperty.baseName.toLowerCase(Locale.ROOT);
        }
        return op;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap operationsMap, List<ModelMap> allModels) {
        OperationMap operations = operationsMap.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            this.postProcessOperationWithModels(op);
        }
        return operationsMap;
    }

    private void postProcessOperationWithModels(CodegenOperation op) {
        boolean consumesJson = false;
        boolean consumesPlainText = false;
        boolean consumesFormUrlEncoded = false;
        if (op.consumes != null) {
            for (Map map : op.consumes) {
                String mediaType = (String)map.get("mediaType");
                if (mediaType == null) continue;
                if (this.isMimetypeJson(mediaType)) {
                    consumesJson = true;
                    continue;
                }
                if (this.isMimetypeWwwFormUrlEncoded(mediaType)) {
                    consumesFormUrlEncoded = true;
                    continue;
                }
                if (this.isMimetypePlain(mediaType)) {
                    consumesPlainText = true;
                    continue;
                }
                if (this.isMimetypeMultipartFormData(mediaType)) {
                    op.vendorExtensions.put("x-consumes-multipart", true);
                    continue;
                }
                if (!this.isMimetypeMultipartRelated(mediaType)) continue;
                op.vendorExtensions.put("x-consumes-multipart-related", true);
            }
        }
        if (op.bodyParam != null) {
            if (consumesJson) {
                op.bodyParam.vendorExtensions.put("x-consumes-json", true);
            } else if (consumesFormUrlEncoded) {
                op.bodyParam.vendorExtensions.put("x-consumes-form-urlencoded", true);
            } else if (consumesPlainText) {
                op.bodyParam.vendorExtensions.put("x-consumes-plain-text", true);
            } else {
                op.bodyParam.vendorExtensions.put("x-consumes-json", true);
            }
        }
        for (CodegenParameter codegenParameter : op.bodyParams) {
            if (consumesJson) {
                codegenParameter.vendorExtensions.put("x-consumes-json", true);
                continue;
            }
            if (consumesFormUrlEncoded) {
                codegenParameter.vendorExtensions.put("x-consumes-form-urlencoded", true);
                continue;
            }
            if (consumesPlainText) {
                codegenParameter.vendorExtensions.put("x-consumes-plain-text", true);
                continue;
            }
            codegenParameter.vendorExtensions.put("x-consumes-json", true);
        }
        for (CodegenParameter codegenParameter : op.queryParams) {
            if (codegenParameter.contentType == null || !this.isMimetypeJson(codegenParameter.contentType)) continue;
            codegenParameter.vendorExtensions.put("x-consumes-json", true);
        }
        for (CodegenParameter codegenParameter : op.headerParams) {
            codegenParameter.nameInLowerCase = codegenParameter.baseName.toLowerCase(Locale.ROOT);
        }
        for (CodegenProperty codegenProperty : op.responseHeaders) {
            codegenProperty.nameInCamelCase = this.toModelName(codegenProperty.baseName);
            codegenProperty.nameInLowerCase = codegenProperty.baseName.toLowerCase(Locale.ROOT);
        }
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals(this.typeMapping.get("File"));
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation op, Map<String, List<CodegenOperation>> operations) {
        String expectedTag;
        if (tag != null && op.tags.size() > 1 && !tag.equals(expectedTag = this.sanitizeTag(op.tags.get(0).getName()))) {
            this.LOGGER.info("generated skip additional tag `{}` with operationId={}", (Object)tag, (Object)op.operationId);
            return;
        }
        super.addOperationToGroup(tag, resourcePath, operation, op, operations);
    }

    @Override
    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        Schema original_schema = ModelUtils.getSchemaFromRequestBody(body);
        CodegenParameter codegenParameter = super.fromRequestBody(body, imports, bodyParameterName);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)original_schema.get$ref())) {
            codegenParameter.dataType = this.getTypeDeclaration(original_schema);
            codegenParameter.isPrimitiveType = false;
            codegenParameter.isArray = false;
            codegenParameter.isString = false;
            codegenParameter.isByteArray = ModelUtils.isByteArraySchema(original_schema);
        }
        return codegenParameter;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            String innerType = this.getTypeDeclaration(inner);
            return (String)this.typeMapping.get("array") + "<" + innerType + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            String innerType = this.getTypeDeclaration(inner);
            StringBuilder typeDeclaration = new StringBuilder((String)this.typeMapping.get("map")).append("<").append((String)this.typeMapping.get("string")).append(", ");
            typeDeclaration.append(innerType).append(">");
            return typeDeclaration.toString();
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            Object datatype;
            try {
                datatype = p.get$ref();
                if (((String)datatype).indexOf("#/components/schemas/") == 0) {
                    datatype = this.toModelName(((String)datatype).substring("#/components/schemas/".length()));
                    datatype = "models::" + (String)datatype;
                }
            }
            catch (Exception e) {
                this.LOGGER.warn("Error obtaining the datatype from schema (model):{}. Datatype default to Object", (Object)p);
                datatype = "Object";
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return datatype;
        }
        if (p instanceof FileSchema) {
            return (String)this.typeMapping.get("File");
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return (String)this.instantiationTypes.get("array") + "<" + this.getSchemaType(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return (String)this.instantiationTypes.get("map") + "<" + (String)this.typeMapping.get("string") + ", " + this.getSchemaType(inner) + ">";
        }
        return null;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        this.LOGGER.trace("Creating model from schema: {}", (Object)model);
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel mdl = super.fromModel(name, model);
        mdl.vendorExtensions.put("x-upper-case-name", name.toUpperCase(Locale.ROOT));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model.get$ref())) {
            Schema schema = allDefinitions.get(ModelUtils.getSimpleRef(model.get$ref()));
            mdl.dataType = (String)this.typeMapping.get(schema.getType());
        }
        if (ModelUtils.isArraySchema(model)) {
            mdl.arrayModelType = this.typeMapping.containsKey(mdl.arrayModelType) ? (String)this.typeMapping.get(mdl.arrayModelType) : this.toModelName(mdl.arrayModelType);
        } else if (!mdl.anyOf.isEmpty() || !mdl.oneOf.isEmpty()) {
            mdl.dataType = this.getSchemaType(model);
        }
        Schema additionalProperties = ModelUtils.getAdditionalProperties(model);
        if (additionalProperties != null) {
            mdl.additionalPropertiesType = this.getTypeDeclaration(additionalProperties);
        }
        this.LOGGER.trace("Created model: {}", (Object)mdl);
        return mdl;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> bundle) {
        this.generateYAMLSpecFile(bundle);
        List pathMethodOps = this.pathMethodOpMap.entrySet().stream().map(entry -> {
            ArrayList methodOps = (ArrayList)entry.getValue();
            methodOps.sort(Comparator.comparing(a -> a.method));
            return new PathMethodOperations((String)entry.getKey(), methodOps);
        }).sorted(Comparator.comparing(a -> a.path)).collect(Collectors.toList());
        bundle.put("pathMethodOps", pathMethodOps);
        return super.postProcessSupportingFileData(bundle);
    }

    @Override
    public String toDefaultValue(Schema p) {
        Object defaultValue = null;
        if (ModelUtils.isNullable(p) && p.getDefault() != null && "null".equalsIgnoreCase(p.getDefault().toString())) {
            return "Nullable::Null";
        }
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                defaultValue = "false".equalsIgnoreCase(p.getDefault().toString()) ? "false" : "true";
            }
        } else if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                defaultValue = p.getDefault().toString();
            }
        } else if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                defaultValue = p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
            defaultValue = "\"" + p.getDefault() + "\".to_string()";
        }
        if (defaultValue != null && ModelUtils.isNullable(p)) {
            defaultValue = "Nullable::Present(" + defaultValue + ")";
        }
        return defaultValue;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!this.languageSpecificPrimitives.contains(property.dataType)) {
            int position = property.dataType.lastIndexOf(":");
            property.dataType = position != -1 ? property.dataType.substring(0, position) + StringUtils.camelize(property.dataType.substring(position)) : StringUtils.camelize(property.dataType);
            property.isPrimitiveType = property.isContainer && this.languageSpecificPrimitives.contains(this.typeMapping.get(property.complexType));
        } else {
            property.isPrimitiveType = true;
        }
        if (Objects.equals(property.baseType, "integer")) {
            BigInteger minimum = Optional.ofNullable(property.getMinimum()).map(BigInteger::new).orElse(null);
            BigInteger maximum = Optional.ofNullable(property.getMaximum()).map(BigInteger::new).orElse(null);
            property.dataType = this.bestFittingIntegerType(minimum, property.getExclusiveMinimum(), maximum, property.getExclusiveMaximum(), true);
        }
        property.name = StringUtils.underscore(property.name);
        if (!property.required) {
            String string = property.defaultValue = property.defaultValue != null ? "Some(" + property.defaultValue + ")" : "None";
        }
        if (this.isObjectType(property.baseType)) {
            property.dataType = objectType;
            property.isNullable = false;
        }
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap modelsMap) {
        for (ModelMap mo : modelsMap.getModels()) {
            CodegenModel cm = mo.getModel();
            this.LOGGER.trace("Post processing model: {}", (Object)cm);
            if (this.isObjectType(cm.dataType)) {
                cm.dataType = null;
            } else if ("map".equals(cm.dataType)) {
                if (!cm.allVars.isEmpty() || cm.additionalPropertiesType == null) {
                    this.LOGGER.warn("Ignoring additionalProperties (see https://github.com/OpenAPITools/openapi-generator/issues/318) alongside defined properties");
                    cm.dataType = null;
                } else {
                    cm.dataType = "std::collections::HashMap<String, " + cm.additionalPropertiesType + ">";
                }
            } else if (cm.dataType != null) {
                cm.isAlias = false;
                cm.dataType = (String)this.typeMapping.get(cm.dataType);
            }
            cm.vendorExtensions.put("x-is-string", stringType.equals(cm.dataType));
        }
        return super.postProcessModelsEnum(modelsMap);
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        String[] command;
        if (file == null) {
            return;
        }
        String fileName = file.toString();
        String cmd = System.getenv("RUST_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cmd)) {
            cmd = "rustfmt";
            command = new String[]{cmd, "--edition", "2021", fileName};
        } else {
            command = new String[]{cmd, fileName};
        }
        if ("rs".equals(FilenameUtils.getExtension((String)fileName))) {
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({} {}). Exit code: {}", new Object[]{cmd, file, exitValue});
                } else {
                    this.LOGGER.info("Successfully executed: {} {}", (Object)cmd, (Object)file);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({} {}). Exception: {}", new Object[]{cmd, file, e.getMessage()});
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void updateParameterForString(CodegenParameter codegenParameter, Schema parameterSchema) {
        if (ModelUtils.isEmailSchema(parameterSchema)) {
            codegenParameter.isEmail = true;
        } else if (ModelUtils.isUUIDSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isUuid = true;
        } else if (ModelUtils.isByteArraySchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isByteArray = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isBinarySchema(parameterSchema)) {
            codegenParameter.isBinary = true;
            codegenParameter.isFile = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isDateSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDate = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isDateTimeSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDateTime = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isDecimalSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDecimal = true;
            codegenParameter.isPrimitiveType = true;
        }
        if (Boolean.TRUE.equals(codegenParameter.isString)) {
            codegenParameter.isPrimitiveType = true;
        }
    }

    @Override
    protected void updatePropertyForAnyType(CodegenProperty property, Schema p) {
        if (Boolean.FALSE.equals(p.getNullable())) {
            this.LOGGER.warn("Schema '{}' is any type, which includes the 'null' value. 'nullable' cannot be set to 'false'", (Object)p.getName());
        }
        if (this.languageSpecificPrimitives.contains(property.dataType)) {
            property.isPrimitiveType = true;
        }
        if (ModelUtils.isMapSchema(p)) {
            this.updatePropertyForMap(property, p);
        }
    }

    @Override
    protected String getParameterDataType(Parameter parameter, Schema schema) {
        if (parameter.get$ref() != null) {
            String refName = ModelUtils.getSimpleRef(parameter.get$ref());
            return this.toModelName(refName);
        }
        return null;
    }

    static class MethodOperation {
        public String method;
        public String operationID;

        MethodOperation(String method, String operationID) {
            this.method = method;
            this.operationID = operationID;
        }
    }

    static class PathMethodOperations {
        public String path;
        public ArrayList<MethodOperation> methodOperations;

        PathMethodOperations(String path, ArrayList<MethodOperation> methodOperations) {
            this.path = path;
            this.methodOperations = methodOperations;
        }
    }
}

