/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyExtensionStorage;
import org.nuiton.wikitty.storage.WikittySearchEngine;
import org.nuiton.wikitty.storage.solr.Restriction2Solr;
import org.nuiton.wikitty.storage.solr.SolrResource;
import org.nuiton.wikitty.storage.solr.SolrUtil;
import org.nuiton.wikitty.storage.solr.TypeFieldModifier;

public class WikittySearchEngineSolr
implements WikittySearchEngine {
    private static Log log = LogFactory.getLog(WikittySearchEngineSolr.class);
    public static final String[] fieldToCopyPattern = new String[]{"#id", "#extensions", "#not_null_fields", ".*_bi", ".*_b", ".*_dt", ".*_d", ".*_s", ".*_w"};
    public static final String[] fieldToCopyPatternWithExcludeAll = new String[]{"#id", "#extensions", "#not_null_fields", "(?!(#all\\.)).*_bi", "(?!(#all\\.)).*_b", "(?!(#all\\.)).*_dt", "(?!(#all\\.)).*_d", "(?!(#all\\.)).*_s", "(?!(#all\\.)).*_w"};
    protected SolrServer solrServer;
    protected TypeFieldModifier fieldModifier;
    protected SolrResource solrResource;

    public WikittySearchEngineSolr(ApplicationConfig config, WikittyExtensionStorage extensionStorage) {
        if (config != null) {
            String solrDataDirKey;
            String solrDataDir;
            String solrDirFactoryKey = WikittyConfig.WikittyOption.WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_FACTORY.getKey();
            String solrDirFactory = config.getOption(solrDirFactoryKey);
            if (solrDirFactory != null) {
                System.setProperty(solrDirFactoryKey, solrDirFactory);
            }
            if (solrDirFactory != null && !solrDirFactory.contains("RAMDirectoryFactory") && (solrDataDir = config.getOption(solrDataDirKey = WikittyConfig.WikittyOption.WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_DATA.getKey())) != null) {
                File file = new File(solrDataDir);
                file.mkdirs();
                System.setProperty(solrDataDirKey, solrDataDir);
            }
        }
        try {
            CoreContainer.Initializer initializer = new CoreContainer.Initializer();
            CoreContainer coreContainer = initializer.initialize();
            this.solrServer = new EmbeddedSolrServer(coreContainer, "");
            this.fieldModifier = new TypeFieldModifier(extensionStorage);
            this.solrResource = new SolrResource(this.solrServer);
        }
        catch (Exception eee) {
            throw new WikittyException("SolR initialization error", (Throwable)eee);
        }
    }

    public void clear(WikittyTransaction transaction) {
        try {
            this.solrResource.init();
            this.solrServer.deleteByQuery("*:*");
        }
        catch (Exception eee) {
            throw new WikittyException("Error during clearing SolR data", (Throwable)eee);
        }
    }

    public void store(WikittyTransaction transaction, Collection<Wikitty> wikitties) {
        try {
            this.solrResource.init();
            ReindexChildTreeNode reindexChildTreeNode = new ReindexChildTreeNode(this.solrServer, this.solrResource);
            for (Wikitty w : wikitties) {
                String id = w.getId();
                if (w.hasExtension("WikittyTreeNode")) {
                    Set<String> attachments = WikittyTreeNodeHelper.getAttachment((Wikitty)w);
                    if (attachments == null) {
                        attachments = Collections.emptySet();
                    }
                    Set oldAttachments = null;
                    SolrDocument treeNodeDoc = SolrUtil.findById(this.solrServer, id);
                    if (treeNodeDoc != null) {
                        oldAttachments = treeNodeDoc.getFieldValues("WikittyTreeNode.attachment_w");
                    }
                    if (oldAttachments == null) {
                        oldAttachments = Collections.emptySet();
                    }
                    HashSet<String> oldAttachmentsCopy = new HashSet<String>(oldAttachments);
                    oldAttachmentsCopy.removeAll(attachments);
                    reindexChildTreeNode.putExcludedAttachments(id, oldAttachmentsCopy);
                    if (w.getDirty().contains("WikittyTreeNode.parent") || null == WikittyTreeNodeHelper.getParent((Wikitty)w) || WikittyUtil.versionGreaterThan((String)"1", (String)w.getVersion())) {
                        reindexChildTreeNode.putIncludedAttachments(id, attachments);
                        String parentId = WikittyTreeNodeHelper.getParent((Wikitty)w);
                        reindexChildTreeNode.putParent(id, parentId);
                    } else {
                        HashSet<String> attachmentsCopy = new HashSet<String>(attachments);
                        attachmentsCopy.removeAll(oldAttachments);
                        reindexChildTreeNode.putIncludedAttachments(id, attachmentsCopy);
                    }
                }
                SolrInputDocument doc = this.createIndexDocument(w);
                this.solrResource.addDoc(id, doc);
            }
            reindexChildTreeNode.reindex();
        }
        catch (Exception eee) {
            throw new WikittyException("Can't store wikitty", (Throwable)eee);
        }
    }

    public void delete(WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        try {
            this.solrResource.init();
            ReindexChildTreeNode reindexChildTreeNode = new ReindexChildTreeNode(this.solrServer, this.solrResource);
            for (String id : ids) {
                SolrQuery query = new SolrQuery("{!wikitty}#tree." + id + ":*");
                QueryResponse response = this.solrServer.query((SolrParams)query);
                SolrDocumentList updateDocs = response.getResults();
                for (SolrDocument solrDocument : updateDocs) {
                    String childId = (String)solrDocument.getFieldValue("#id");
                    reindexChildTreeNode.putExcludedAttachment(id, childId);
                }
                this.solrResource.deleteDoc(id);
            }
            reindexChildTreeNode.reindex();
        }
        catch (Exception eee) {
            throw new WikittyException("Can't delete wikitty in index", (Throwable)eee);
        }
    }

    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria) {
        try {
            String facetName;
            List sortDescending;
            Restriction2Solr restriction2Solr = new Restriction2Solr(transaction, this.fieldModifier);
            String queryString = restriction2Solr.toSolr(criteria.getRestriction(), this.solrServer);
            SolrQuery query = new SolrQuery("{!wikitty}" + queryString);
            int firstIndex = criteria.getFirstIndex();
            int endIndex = criteria.getEndIndex();
            query.setStart(Integer.valueOf(firstIndex));
            int nbRows = endIndex == -1 ? Integer.MAX_VALUE - firstIndex : endIndex - firstIndex + 1;
            query.setRows(Integer.valueOf(nbRows));
            List sortAscending = criteria.getSortAscending();
            if (sortAscending != null) {
                for (String sort : sortAscending) {
                    String tranform = this.fieldModifier.convertToSolr(transaction, sort);
                    query.addSortField(tranform, SolrQuery.ORDER.asc);
                }
            }
            if ((sortDescending = criteria.getSortDescending()) != null) {
                for (String sort : sortDescending) {
                    String tranform = this.fieldModifier.convertToSolr(transaction, sort);
                    query.addSortField(tranform, SolrQuery.ORDER.desc);
                }
            }
            List facetField = criteria.getFacetField();
            log.debug((Object)("facetField : " + facetField));
            List facetCriteria = criteria.getFacetCriteria();
            HashMap<String, String> facetQueryToName = new HashMap<String, String>();
            if (facetField != null && !facetField.isEmpty() || facetCriteria != null && !facetCriteria.isEmpty()) {
                query.setFacet(true);
                query.setFacetMinCount(1);
                if (facetField != null) {
                    for (String fqfieldName : facetField) {
                        String tranform = this.fieldModifier.convertToSolr(transaction, fqfieldName);
                        query.addFacetField(new String[]{tranform});
                    }
                }
                if (facetCriteria != null) {
                    for (Criteria facet : facetCriteria) {
                        String queryFacet = restriction2Solr.toSolr(facet.getRestriction());
                        facetQueryToName.put(queryFacet, facet.getName());
                        query.addFacetQuery(queryFacet);
                    }
                }
            }
            QueryResponse resp = this.solrServer.query((SolrParams)query);
            SolrDocumentList solrResults = resp.getResults();
            HashMap facets = new HashMap();
            if (facetField != null && !facetField.isEmpty()) {
                for (FacetField facetField2 : resp.getFacetFields()) {
                    facetName = this.fieldModifier.convertToField(transaction, facetField2.getName());
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    if (facetField2.getValues() != null) {
                        for (FacetField.Count value : facetField2.getValues()) {
                            String topicName = value.getName();
                            if (topicName.endsWith("#tree.empty")) continue;
                            int topicCount = (int)value.getCount();
                            FacetTopic topic = new FacetTopic(facetName, topicName, topicCount);
                            topics.add(topic);
                        }
                    }
                    facets.put(facetName, topics);
                }
            }
            if (facetCriteria != null && !facetCriteria.isEmpty()) {
                for (Map.Entry entry : resp.getFacetQuery().entrySet()) {
                    facetName = (String)entry.getKey();
                    if (null != facetQueryToName.get(facetName)) {
                        facetName = (String)facetQueryToName.get(facetName);
                    }
                    Integer count = (Integer)entry.getValue();
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    FacetTopic topic = new FacetTopic(facetName, facetName, count.intValue());
                    topics.add(topic);
                    facets.put(facetName, topics);
                }
            }
            ArrayList<String> ids = new ArrayList<String>(solrResults.size());
            for (SolrDocument doc : solrResults) {
                String id = (String)doc.getFieldValue("#id");
                ids.add(id);
            }
            int n = (int)resp.getResults().getNumFound();
            PagedResult result = new PagedResult(firstIndex, n, queryString, facets, ids);
            return result;
        }
        catch (SolrServerException eee) {
            throw new WikittyException("Error during find", (Throwable)eee);
        }
    }

    public Integer findNodeCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
        String wikittyId = w.getId();
        String parent = WikittyTreeNodeHelper.getParent((Wikitty)w);
        parent = parent == null ? "#tree.root" : "#tree." + parent;
        Criteria criteria = Search.query((Criteria)filter).eq(parent, wikittyId).criteria().setFirstIndex(0).setEndIndex(0);
        PagedResult<String> search = this.findAllByCriteria(transaction, criteria);
        int numFound = search.getNumFound();
        return numFound;
    }

    public Map<String, Integer> findAllChildrenCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
        String wikittyId = w.getId();
        String parent = WikittyTreeNodeHelper.getParent((Wikitty)w);
        parent = parent == null ? "#tree.root" : "#tree." + parent;
        Criteria criteria = Search.query((Criteria)filter).eq(parent, wikittyId).criteria().setFirstIndex(0).setEndIndex(0).addFacetField("#tree." + wikittyId);
        PagedResult<String> search = this.findAllByCriteria(transaction, criteria);
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        List topics = search.getTopic("#tree." + wikittyId);
        if (topics != null) {
            for (FacetTopic topic : topics) {
                String topicName = topic.getTopicName();
                int topicCount = topic.getCount();
                counts.put(topicName, topicCount);
            }
        }
        log.debug((Object)("Facet result " + counts));
        criteria = Search.query().eq("WikittyTreeNode.parent", wikittyId).criteria().setFirstIndex(0).setEndIndex(-1);
        search = this.findAllByCriteria(transaction, criteria);
        List children = search.getAll();
        for (String child : children) {
            if (counts.containsKey(child)) continue;
            counts.put(child, 0);
        }
        return counts;
    }

    protected SolrInputDocument createIndexDocument(Wikitty w) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("index wikitty " + w.getId()));
        }
        SolrInputDocument doc = new SolrInputDocument();
        String id = w.getId();
        doc.addField("#id", (Object)id);
        for (String name : w.getExtensionNames()) {
            doc.addField("#extensions", (Object)name);
        }
        for (String fqfieldName : w.fieldNames()) {
            FieldType fieldType = w.getFieldType(fqfieldName);
            FieldType.TYPE type = fieldType.getType();
            String solrFqFieldName = SolrUtil.getSolrFieldName(fqfieldName, type);
            String solrAllFieldName = "#all." + WikittyUtil.getFieldNameFromFQFieldName((String)solrFqFieldName);
            Object objectValue = w.getFqField(fqfieldName);
            if (objectValue == null) continue;
            if (fieldType.isCollection()) {
                Collection collectionValue = (Collection)objectValue;
                for (Object itemValue : collectionValue) {
                    if (itemValue == null) continue;
                    doc.addField(solrFqFieldName, itemValue);
                    doc.addField(solrAllFieldName, itemValue);
                    doc.addField("#not_null_fields", (Object)fqfieldName);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("index field " + solrFqFieldName + " with value '" + itemValue + "'"));
                }
                continue;
            }
            doc.addField(solrFqFieldName, objectValue);
            doc.addField(solrAllFieldName, objectValue);
            doc.addField("#not_null_fields", (Object)fqfieldName);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("index field " + solrFqFieldName + " with value '" + objectValue + "'"));
        }
        return doc;
    }

    protected static class ReindexChildTreeNode {
        protected SolrResource solrResource;
        protected SolrServer solrServer;
        protected Map<String, Collection<String>> includedNodeIds;
        protected Map<String, Collection<String>> excludedNodeIds;
        protected Map<String, String> parents;

        public ReindexChildTreeNode(SolrServer solrServer, SolrResource solrResource) {
            this.solrServer = solrServer;
            this.solrResource = solrResource;
            this.includedNodeIds = new HashMap<String, Collection<String>>();
            this.excludedNodeIds = new HashMap<String, Collection<String>>();
            this.parents = new HashMap<String, String>();
        }

        public void putIncludedAttachments(String nodeId, Collection<String> attchmentIds) {
            this.putAttachements(this.includedNodeIds, nodeId, attchmentIds);
        }

        public void putExcludedAttachments(String nodeId, Collection<String> attachmentIds) {
            this.putAttachements(this.excludedNodeIds, nodeId, attachmentIds);
        }

        public void putIncludedAttachment(String nodeId, String attachmentId) {
            this.putAttachment(this.includedNodeIds, nodeId, attachmentId);
        }

        public void putExcludedAttachment(String nodeId, String attachmentId) {
            this.putAttachment(this.excludedNodeIds, nodeId, attachmentId);
        }

        public Collection<String> getExcludedNodeIds(String attachmentId) {
            Collection<String> result = this.excludedNodeIds.get(attachmentId);
            if (result == null) {
                result = new HashSet<String>();
            }
            return result;
        }

        public Collection<String> getIncludedNodeIds(String attachmentId) {
            Collection<String> result = this.includedNodeIds.get(attachmentId);
            if (result == null) {
                result = new HashSet<String>();
            }
            return result;
        }

        protected void putAttachements(Map<String, Collection<String>> map, String nodeId, Collection<String> attachmentIds) {
            if (attachmentIds != null) {
                for (String attachmentId : attachmentIds) {
                    this.putAttachment(map, nodeId, attachmentId);
                }
            }
        }

        protected void putAttachment(Map<String, Collection<String>> map, String nodeId, String attachmentId) {
            Collection<String> values = map.get(attachmentId);
            if (values == null) {
                values = new HashSet<String>();
                map.put(attachmentId, values);
            }
            values.add(nodeId);
        }

        public void putParent(String nodeId, String parentId) {
            this.parents.put(nodeId, parentId);
        }

        public String getParent(String nodeId) {
            List<String> deletedDocIds;
            String parentId = this.parents.get(nodeId);
            if (parentId == null) {
                SolrDocument doc = SolrUtil.findById(this.solrServer, nodeId);
                if (doc == null) {
                    return null;
                }
                parentId = (String)doc.getFieldValue("WikittyTreeNode.parent_w");
                this.putParent(nodeId, parentId);
            }
            if ((deletedDocIds = this.solrResource.getDeletedDocs()).contains(parentId)) {
                return null;
            }
            return parentId;
        }

        public Collection<String> getReindexIds() {
            HashSet<String> result = new HashSet<String>();
            result.addAll(this.includedNodeIds.keySet());
            result.addAll(this.excludedNodeIds.keySet());
            result.addAll(this.solrResource.getAddedDocIds());
            return result;
        }

        public void reindex() throws SolrServerException {
            for (String id : this.getReindexIds()) {
                SolrInputDocument doc = this.solrResource.getAddedDoc(id);
                if (doc == null) {
                    SolrDocument found = SolrUtil.findById(this.solrServer, id);
                    if (found != null) {
                        doc = SolrUtil.copySolrDocument(found, true, fieldToCopyPattern);
                        this.solrResource.addDoc(id, doc);
                    } else {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)String.format("Can't find wikitty id '%s' in index. Skip this wikitty.", id));
                        continue;
                    }
                }
                Collection<String> includedChildNodeIds = this.getIncludedNodeIds(id);
                Collection<String> excludedChildNodeIds = this.getExcludedNodeIds(id);
                SolrQuery query = new SolrQuery("{!wikitty}WikittyTreeNode.attachment_w:" + id);
                QueryResponse response = this.solrServer.query((SolrParams)query);
                SolrDocumentList updateDocs = response.getResults();
                for (SolrDocument solrDocument : updateDocs) {
                    String nodeId = (String)solrDocument.getFieldValue("#id");
                    includedChildNodeIds.add(nodeId);
                }
                includedChildNodeIds.removeAll(excludedChildNodeIds);
                includedChildNodeIds.removeAll(this.solrResource.getDeletedDocs());
                HashMap<String, String> paths = new HashMap<String, String>();
                for (String nodeId : includedChildNodeIds) {
                    String parentPath;
                    doc.addField("#tree." + nodeId, (Object)"#tree.empty");
                    String childParent = nodeId;
                    String parent = this.getParent(childParent);
                    while (parent != null) {
                        parentPath = (String)paths.get(childParent);
                        if (parentPath == null) {
                            doc.addField("#tree." + parent, (Object)childParent);
                            paths.put(childParent, parent);
                        }
                        childParent = parent;
                        parent = this.getParent(childParent);
                    }
                    parentPath = (String)paths.get(childParent);
                    if (parentPath != null) continue;
                    doc.addField("#tree.root", (Object)childParent);
                    paths.put(childParent, "#tree.root");
                }
            }
        }
    }
}

