/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage.solr;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.search.RestrictionHelper;
import org.nuiton.wikitty.search.operators.And;
import org.nuiton.wikitty.search.operators.AssociatedRestriction;
import org.nuiton.wikitty.search.operators.Between;
import org.nuiton.wikitty.search.operators.Contains;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.search.operators.EndsWith;
import org.nuiton.wikitty.search.operators.Equals;
import org.nuiton.wikitty.search.operators.False;
import org.nuiton.wikitty.search.operators.Greater;
import org.nuiton.wikitty.search.operators.GreaterOrEqual;
import org.nuiton.wikitty.search.operators.In;
import org.nuiton.wikitty.search.operators.Keyword;
import org.nuiton.wikitty.search.operators.Less;
import org.nuiton.wikitty.search.operators.LessOrEqual;
import org.nuiton.wikitty.search.operators.Like;
import org.nuiton.wikitty.search.operators.Not;
import org.nuiton.wikitty.search.operators.NotEquals;
import org.nuiton.wikitty.search.operators.Null;
import org.nuiton.wikitty.search.operators.Or;
import org.nuiton.wikitty.search.operators.Restriction;
import org.nuiton.wikitty.search.operators.StartsWith;
import org.nuiton.wikitty.search.operators.Unlike;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.solr.FieldModifier;
import org.nuiton.wikitty.storage.solr.SolrUtil;

public class Restriction2Solr {
    private static final int MAX_SUBQUERY_RESULT = 100;
    protected static final FieldModifier dummyFieldModifier = new FieldModifier(){

        @Override
        public String convertToSolr(WikittyTransaction transaction, String fieldname) {
            return fieldname;
        }

        @Override
        public String convertToField(WikittyTransaction transaction, String solrName) {
            return solrName;
        }
    };
    protected FieldModifier fieldModifer;
    protected WikittyTransaction transaction;

    public Restriction2Solr() {
        this(null, dummyFieldModifier);
    }

    public Restriction2Solr(WikittyTransaction transaction, FieldModifier fieldModifer) {
        this.transaction = transaction;
        this.fieldModifer = fieldModifer;
    }

    public String toSolr(Restriction restriction, SolrServer solr) throws WikittyException {
        switch (restriction.getName()) {
            case TRUE: {
                return this.true2solr();
            }
            case FALSE: {
                return this.false2solr();
            }
            case NOT: {
                Not not = (Not)restriction;
                return this.not2solr(not, solr);
            }
            case AND: {
                And and = (And)restriction;
                return this.and2solr(and, solr);
            }
            case OR: {
                Or or = (Or)restriction;
                return this.or2solr(or, solr);
            }
            case EQUALS: {
                Equals eq = (Equals)restriction;
                return this.eq2solr(eq);
            }
            case NOT_EQUALS: {
                NotEquals neq = (NotEquals)restriction;
                return this.neq2solr(neq);
            }
            case LESS: {
                Less less = (Less)restriction;
                return this.less2solr(less);
            }
            case LESS_OR_EQUAL: {
                LessOrEqual lessEq = (LessOrEqual)restriction;
                return this.lessEq2solr(lessEq);
            }
            case GREATER: {
                Greater great = (Greater)restriction;
                return this.great2solr(great);
            }
            case GREATER_OR_EQUAL: {
                GreaterOrEqual greatEq = (GreaterOrEqual)restriction;
                return this.greatEq2solr(greatEq);
            }
            case BETWEEN: {
                Between between = (Between)restriction;
                return this.between2solr(between);
            }
            case CONTAINS: {
                Contains contains = (Contains)restriction;
                return this.contains2solr(contains);
            }
            case IN: {
                In in = (In)restriction;
                return this.in2solr(in);
            }
            case STARTS_WITH: {
                StartsWith start = (StartsWith)restriction;
                return this.start2solr(start);
            }
            case ENDS_WITH: {
                EndsWith end = (EndsWith)restriction;
                return this.end2solr(end);
            }
            case LIKE: {
                Like like = (Like)restriction;
                return this.like2solr(like);
            }
            case UNLIKE: {
                Unlike unlike = (Unlike)restriction;
                return this.unlike2solr(unlike);
            }
            case ASSOCIATED: {
                AssociatedRestriction associated = (AssociatedRestriction)restriction;
                return this.associated2solr(associated, solr);
            }
            case KEYWORD: {
                Keyword keyword = (Keyword)restriction;
                return this.keyword2solr(keyword);
            }
            case IS_NULL: {
                Null isNull = (Null)restriction;
                return this.isNull2solr(isNull);
            }
            case IS_NOT_NULL: {
                Null isNotNull = (Null)restriction;
                return this.isNotNull2solr(isNotNull);
            }
        }
        throw new WikittyException("this kind of restriction is not supported : " + restriction.getName().toString());
    }

    private String in2solr(In in) {
        if (in.getElement() == null) {
            throw new WikittyException("in.element must not be null");
        }
        if (in.getValue() == null) {
            throw new WikittyException("in.values must not be null");
        }
        if (in.getValue().size() < 1) {
            throw new WikittyException("IN is an operator that handle 1 operand at least");
        }
        String operand = "";
        StringBuilder result = new StringBuilder();
        result.append(this.element2solr(in.getElement())).append(':');
        result.append('(');
        for (String value : in.getValue()) {
            result.append(operand);
            result.append(this.value2solr(value));
            operand = " OR ";
        }
        result.append(')');
        return result.toString();
    }

    private String associated2solr(AssociatedRestriction associated, SolrServer solr) throws WikittyException {
        And and;
        False generatedRestriction;
        String subQuery = this.toSolr(associated.getRestriction(), solr);
        SolrQuery query = new SolrQuery("{!wikitty}" + subQuery);
        query.setRows(Integer.valueOf(100));
        QueryResponse resp = null;
        try {
            resp = SolrUtil.executeQuery(solr, query);
        }
        catch (SolrServerException e) {
            throw new WikittyException("Unable to execute associative query on " + associated.getElement().getName(), (Throwable)e);
        }
        SolrDocumentList solrResults = resp.getResults();
        long size = solrResults.size();
        if (size == 0L) {
            generatedRestriction = RestrictionHelper.rFalse();
        } else if (size == 1L) {
            generatedRestriction = RestrictionHelper.eq((Element)associated.getElement(), (String)((String)((SolrDocument)solrResults.get(0)).getFieldValue("#id")));
        } else {
            ArrayList<String> ids = new ArrayList<String>(solrResults.size());
            for (SolrDocument doc : solrResults) {
                String id = (String)doc.getFieldValue("#id");
                ids.add(id);
            }
            generatedRestriction = new In(associated.getElement(), ids);
        }
        Restriction parent = associated.getParentRestrictionDto();
        if (parent instanceof And) {
            and = (And)parent;
            and.getRestrictions().add(generatedRestriction);
        } else {
            and = RestrictionHelper.and(Arrays.asList(associated.getParentRestrictionDto(), generatedRestriction));
        }
        return this.toSolr((Restriction)and, solr);
    }

    private String not2solr(Not not, SolrServer solr) throws WikittyException {
        if (not.getRestriction() == null) {
            throw new WikittyException("not.restriction");
        }
        return "( *:* - " + this.toSolr(not.getRestriction(), solr) + " )";
    }

    private String and2solr(And and, SolrServer solr) throws WikittyException {
        if (and.getRestrictions() == null) {
            throw new WikittyException("and.restrictions is null");
        }
        if (and.getRestrictions().size() < 2) {
            throw new WikittyException("AND is an operator that handle 2 operand at least");
        }
        boolean first = true;
        StringBuffer result = new StringBuffer();
        for (Restriction restriction : and.getRestrictions()) {
            if (first) {
                result.append("( ").append(this.toSolr(restriction, solr));
                first = false;
                continue;
            }
            result.append(" AND ").append(this.toSolr(restriction, solr));
        }
        return result.append(" )").toString();
    }

    private String or2solr(Or or, SolrServer solr) throws WikittyException {
        if (or.getRestrictions() == null) {
            throw new WikittyException("or.restrictions is null");
        }
        if (or.getRestrictions().size() < 2) {
            throw new WikittyException("OR is an operator that handle 2 operand at least");
        }
        boolean first = true;
        StringBuffer result = new StringBuffer();
        for (Restriction restriction : or.getRestrictions()) {
            if (first) {
                result.append("( ");
                first = false;
            } else {
                result.append(" OR ");
            }
            result.append(this.toSolr(restriction, solr));
        }
        return result.append(" )").toString();
    }

    private String eq2solr(Equals eq) throws WikittyException {
        return this.element2solr(eq.getElement()) + ":" + this.value2solr(eq.getValue());
    }

    private String neq2solr(NotEquals neq) throws WikittyException {
        return "-" + this.element2solr(neq.getElement()) + ":" + this.value2solr(neq.getValue());
    }

    private String less2solr(Less less) throws WikittyException {
        return this.element2solr(less.getElement()) + ":{* TO " + this.value2solr(less.getValue()) + "}";
    }

    private String lessEq2solr(LessOrEqual lessEq) throws WikittyException {
        return this.element2solr(lessEq.getElement()) + ":[* TO " + this.value2solr(lessEq.getValue()) + "]";
    }

    private String great2solr(Greater great) throws WikittyException {
        return this.element2solr(great.getElement()) + ":{" + this.value2solr(great.getValue()) + " TO *}";
    }

    private String greatEq2solr(GreaterOrEqual greatEq) throws WikittyException {
        return this.element2solr(greatEq.getElement()) + ":[" + this.value2solr(greatEq.getValue()) + " TO *]";
    }

    private String between2solr(Between between) throws WikittyException {
        if (between.getElement() == null) {
            throw new WikittyException("between.element must not be null");
        }
        if (between.getMin() == null) {
            throw new WikittyException("between.min must not be null");
        }
        if (between.getMax() == null) {
            throw new WikittyException("between.max must not be null");
        }
        return this.element2solr(between.getElement()) + ":[" + this.value2solr(between.getMin()) + " TO " + this.value2solr(between.getMax()) + "]";
    }

    private String contains2solr(Contains contains) throws WikittyException {
        if (contains.getElement() == null) {
            throw new WikittyException("contains.element must not be null");
        }
        if (contains.getValue() == null) {
            throw new WikittyException("contains.values must not be null");
        }
        if (contains.getValue().size() < 1) {
            throw new WikittyException("CONTAINS is an operator that handle 1 operand at least");
        }
        String operand = "";
        StringBuilder result = new StringBuilder();
        result.append(this.element2solr(contains.getElement())).append(':');
        result.append('(');
        for (String value : contains.getValue()) {
            result.append(operand);
            result.append(this.value2solr(value));
            operand = " AND ";
        }
        result.append(')');
        return result.toString();
    }

    private String start2solr(StartsWith start) throws WikittyException {
        return this.element2solr(start.getElement()) + ":" + this.value2solr(start.getValue()) + "*";
    }

    private String end2solr(EndsWith end) {
        return this.element2solr(end.getElement()) + ":*" + this.value2solr(end.getValue());
    }

    private String true2solr() {
        return "( *:* )";
    }

    private String false2solr() {
        return "( *:* - *:* )";
    }

    private String keyword2solr(Keyword keyword) {
        return this.value2solr(keyword.getValue());
    }

    private String isNull2solr(Null isNull) {
        return "#null_field-" + isNull.getFieldName() + ":true";
    }

    private String isNotNull2solr(Null isNotNull) {
        return "#null_field-" + isNotNull.getFieldName() + ":false";
    }

    private String element2solr(Element element) throws WikittyException {
        String result = element.getName();
        result = this.fieldModifer.convertToSolr(this.transaction, result);
        return result;
    }

    private String value2solr(String value) {
        if (value == null) {
            throw new WikittyException("Parse error, value must be not empty");
        }
        String result = Restriction2Solr.escapeValue(value);
        if (result.contains(" ")) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    private String like2solr(Like like) throws WikittyException {
        Like.SearchAs searchAs = like.getSearchAs();
        String element2solr = this.element2solr(like.getElement());
        if (element2solr.endsWith("_s")) {
            switch (searchAs) {
                case AsText: {
                    element2solr = element2solr + "_t";
                    break;
                }
                case ToLowerCase: {
                    element2solr = element2solr + "_c";
                }
            }
        }
        String value2solr = this.value2solr(like.getValue());
        if (!element2solr.endsWith("_dt")) {
            value2solr = value2solr.toLowerCase();
        }
        return element2solr + ":" + value2solr;
    }

    private String unlike2solr(Unlike unlike) throws WikittyException {
        Like.SearchAs searchAs = unlike.getSearchAs();
        String element2solr = this.element2solr(unlike.getElement());
        if (element2solr.endsWith("_s")) {
            switch (searchAs) {
                case AsText: {
                    element2solr = element2solr + "_t";
                    break;
                }
                case ToLowerCase: {
                    element2solr = element2solr + "_c";
                }
            }
        }
        String value2solr = this.value2solr(unlike.getValue());
        if (!element2solr.endsWith("_dt")) {
            value2solr = value2solr.toLowerCase();
        }
        return "-" + element2solr + ":" + value2solr;
    }

    private static String escapeValue(String value) {
        String LUCENE_REPLACE_PATTERN = "\\+|-|&&|\\||!|\\(|\\)|\\[|\\]|\\{|\\}|\"|:";
        return value.replaceAll("\\+|-|&&|\\||!|\\(|\\)|\\[|\\]|\\{|\\}|\"|:", "\\\\$0");
    }
}

