/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyContractGenerator
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(WikittyContractGenerator.class);
    protected Map<ObjectModelClass, ObjectModelInterface> processedClasses = new HashMap<ObjectModelClass, ObjectModelInterface>();
    protected Set<ObjectModelClass> processedEntities = new HashSet<ObjectModelClass>();

    public void transformFromModel(ObjectModel model) {
        log.info((Object)(model.getClasses().size() + " classes to process"));
        for (ObjectModelClass clazz : model.getClasses()) {
            if (WikittyTransformerUtil.isBusinessEntity(clazz)) {
                this.processEntity(clazz);
            }
            if (!WikittyTransformerUtil.isMetaExtension(clazz)) continue;
            this.processMetaExtension(clazz);
        }
        this.processedClasses.clear();
        this.processedEntities.clear();
    }

    protected ObjectModelInterface prepareOutputClass(ObjectModelClass businessEntity) {
        ObjectModelInterface contract = this.processedClasses.get(businessEntity);
        if (contract == null) {
            log.debug((Object)("preparing " + businessEntity.getPackageName() + "." + businessEntity.getName()));
            contract = this.createInterface(WikittyTransformerUtil.businessEntityToContractName(businessEntity), businessEntity.getPackageName());
            this.addInterface((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.BusinessEntity");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.BusinessEntity");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.BusinessEntityImpl");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.Wikitty");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.WikittyExtension");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.query.conditions.ElementField");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.WikittyUtil");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.WikittyUser");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.WikittyUserAbstract");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.WikittyUserImpl");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.WikittyTreeNode");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.WikittyTreeNodeAbstract");
            this.addImport((ObjectModelClassifier)contract, "org.nuiton.wikitty.entities.WikittyTreeNodeImpl");
            this.addImport((ObjectModelClassifier)contract, List.class);
            this.addImport((ObjectModelClassifier)contract, ArrayList.class);
            this.addImport((ObjectModelClassifier)contract, Collection.class);
            this.addImport((ObjectModelClassifier)contract, Collections.class);
            this.addImport((ObjectModelClassifier)contract, Set.class);
            this.addImport((ObjectModelClassifier)contract, Date.class);
            this.addImport((ObjectModelClassifier)contract, LinkedHashSet.class);
            String documentation = businessEntity.getDocumentation();
            if (businessEntity.hasTagValue("documentation")) {
                documentation = documentation + "\n\n";
                documentation = documentation + businessEntity.getTagValue("documentation");
            }
            this.setDocumentation((ObjectModelElement)contract, documentation);
            this.processedClasses.put(businessEntity, contract);
        } else {
            log.debug((Object)("already prepared : " + businessEntity.getPackageName() + "." + businessEntity.getName()));
        }
        return contract;
    }

    protected void processEntity(ObjectModelClass businessEntity) {
        if (this.processedEntities.contains(businessEntity)) {
            log.debug((Object)("entity already processed : " + businessEntity.getPackageName() + "." + businessEntity.getName()));
            return;
        }
        log.debug((Object)("processing entity : " + businessEntity.getPackageName() + "." + businessEntity.getName()));
        ObjectModelInterface contract = this.prepareOutputClass(businessEntity);
        this.addConstant((ObjectModelClassifier)contract, "EXT_" + businessEntity.getName().toUpperCase(), "String", "\"" + businessEntity.getName() + "\"", ObjectModelModifier.PUBLIC);
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(businessEntity, false);
        for (ObjectModelOperation operation : businessEntity.getOperations()) {
            if (operation.getReturnType() == null || operation.getReturnType().isEmpty()) {
                this.addOperation((ObjectModelClassifier)contract, operation.getName(), "void", new ObjectModelModifier[0]);
                continue;
            }
            this.addOperation((ObjectModelClassifier)contract, operation);
        }
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, false);
            String name = attribute.getName();
            this.addConstant((ObjectModelClassifier)contract, fieldVariableName, "String", "\"" + name + "\"", ObjectModelModifier.PUBLIC);
            this.addConstant((ObjectModelClassifier)contract, "FQ_" + fieldVariableName, "String", extensionVariableName + " + \"." + name + "\"", ObjectModelModifier.PUBLIC);
            this.addConstant((ObjectModelClassifier)contract, "ELEMENT_" + fieldVariableName, "ElementField", "new ElementField(FQ_" + fieldVariableName + ")", ObjectModelModifier.PUBLIC);
        }
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String attributeName = businessEntity.hasTagValue("alternativeName." + businessEntity.getName() + "." + attribute.getName()) ? businessEntity.getTagValue("alternativeName." + businessEntity.getName() + "." + attribute.getName()) : (attribute.hasTagValue("alternativeName") ? attribute.getTagValue("alternativeName") : attribute.getName());
            this.addOperationWithName(contract, attribute, attributeName);
        }
        Collection superClasses = businessEntity.getSuperclasses();
        for (ObjectModelClass superClass : superClasses) {
            superClass = ((ObjectModel)this.model).getClass(superClass.getQualifiedName());
            this.addInterface((ObjectModelClassifier)contract, superClass.getQualifiedName());
            if (!WikittyTransformerUtil.isBusinessEntity(superClass)) continue;
            for (ObjectModelAttribute attribute : superClass.getAttributes()) {
                if (!businessEntity.hasTagValue("alternativeName." + superClass.getName() + "." + attribute.getName())) continue;
                String attributeName = businessEntity.getTagValue("alternativeName." + superClass.getName() + "." + attribute.getName());
                this.addOperationWithName(contract, attribute, attributeName);
            }
        }
        this.processedEntities.add(businessEntity);
    }

    protected void addOperationWithName(ObjectModelInterface contract, ObjectModelAttribute attribute, String getterSetterName) {
        String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
        if (attribute.getMaxMultiplicity() > 1 || attribute.getMaxMultiplicity() == -1) {
            String attributeTypeCollectionStrict = WikittyTransformerUtil.generateResultType(attribute, true);
            String attributeTypeCollectionGeneric = "Collection<" + attributeType + ">";
            String attributeTypeVarargs = attributeType + "...";
            String getterName = "get" + StringUtils.capitalize((String)getterSetterName);
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)contract, getterName, attributeTypeCollectionStrict, new ObjectModelModifier[0]);
            this.setDocumentation((ObjectModelElement)getter, attribute.getDocumentation());
            String setterName = "set" + StringUtils.capitalize((String)getterSetterName);
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)contract, setterName, "void", new ObjectModelModifier[0]);
            this.addParameter(setter, attributeTypeCollectionStrict, getterSetterName);
            String addAllName = "addAll" + StringUtils.capitalize((String)getterSetterName);
            ObjectModelOperation addAll = this.addOperation((ObjectModelClassifier)contract, addAllName, "void", new ObjectModelModifier[0]);
            this.addParameter(addAll, attributeTypeCollectionGeneric, getterSetterName);
            String addName = "add" + StringUtils.capitalize((String)getterSetterName);
            ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)contract, addName, "void", new ObjectModelModifier[0]);
            this.addParameter(adder, attributeTypeVarargs, "element");
            String removeName = "remove" + StringUtils.capitalize((String)getterSetterName);
            ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)contract, removeName, "void", new ObjectModelModifier[0]);
            this.addParameter(remover, attributeTypeVarargs, "element");
            String clearName = "clear" + StringUtils.capitalize((String)getterSetterName);
            this.addOperation((ObjectModelClassifier)contract, clearName, "void", new ObjectModelModifier[0]);
        } else {
            String getterName = "get" + StringUtils.capitalize((String)getterSetterName);
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)contract, getterName, attributeType, new ObjectModelModifier[0]);
            this.setDocumentation((ObjectModelElement)getter, attribute.getDocumentation());
            String setterName = "set" + StringUtils.capitalize((String)getterSetterName);
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)contract, setterName, "void", new ObjectModelModifier[0]);
            this.addParameter(setter, attributeType, getterSetterName);
        }
    }

    protected void processMetaExtension(ObjectModelClass metaExtension) {
    }
}

