/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.And;
import org.nuiton.wikitty.query.conditions.Between;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.ContainsAll;
import org.nuiton.wikitty.query.conditions.ContainsOne;
import org.nuiton.wikitty.query.conditions.Equals;
import org.nuiton.wikitty.query.conditions.False;
import org.nuiton.wikitty.query.conditions.Greater;
import org.nuiton.wikitty.query.conditions.GreaterOrEquals;
import org.nuiton.wikitty.query.conditions.Keyword;
import org.nuiton.wikitty.query.conditions.Less;
import org.nuiton.wikitty.query.conditions.LessOrEquals;
import org.nuiton.wikitty.query.conditions.Like;
import org.nuiton.wikitty.query.conditions.Not;
import org.nuiton.wikitty.query.conditions.NotEquals;
import org.nuiton.wikitty.query.conditions.NotNull;
import org.nuiton.wikitty.query.conditions.Null;
import org.nuiton.wikitty.query.conditions.Or;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.query.conditions.True;
import org.nuiton.wikitty.query.conditions.Unlike;
import org.nuiton.wikitty.query.function.FunctionValue;
import org.nuiton.wikitty.query.function.WikittyQueryFunction;

public class WikittyQueryVisitorToString
extends WikittyQueryVisitor {
    private static Log log = LogFactory.getLog(WikittyQueryVisitorToString.class);
    public String text = "";

    public String getText() {
        return this.text;
    }

    @Override
    public boolean visitEnter(WikittyQuery o) {
        this.text = this.text + o.getName() + "(";
        return true;
    }

    @Override
    public void visitLeave(WikittyQuery o, boolean enterResult) {
        this.text = this.text + ")";
    }

    @Override
    public boolean visitEnter(And o) {
        this.text = this.text + "(";
        return true;
    }

    @Override
    public boolean visitMiddle(And o) {
        this.text = this.text + " AND ";
        return true;
    }

    @Override
    public void visitLeave(And o, boolean enterResult) {
        this.text = this.text + ")";
    }

    @Override
    public boolean visitEnter(Or o) {
        this.text = this.text + "(";
        return true;
    }

    @Override
    public boolean visitMiddle(Or o) {
        this.text = this.text + " OR ";
        return true;
    }

    @Override
    public void visitLeave(Or o, boolean enterResult) {
        this.text = this.text + ")";
    }

    @Override
    public boolean visitEnter(Select o) {
        this.text = this.text + "SELECT ";
        return true;
    }

    @Override
    public boolean visitMiddle(Select o) {
        this.text = this.text + " WHERE (";
        return true;
    }

    @Override
    public void visitLeave(Select o, boolean enterOrMiddleResult) {
        this.text = this.text + ")";
    }

    @Override
    public boolean visitEnter(Not o) {
        this.text = this.text + "NOT(";
        return true;
    }

    @Override
    public void visitLeave(Not o, boolean enterResult) {
        this.text = this.text + ")";
    }

    @Override
    public boolean visitEnter(Between o) {
        this.text = this.text + o.getElement().getValue() + "=" + "[";
        return true;
    }

    @Override
    public boolean visitMiddle(Between o) {
        this.text = this.text + " TO ";
        return true;
    }

    @Override
    public void visitLeave(Between o, boolean enterOrMiddleResult) {
        this.text = this.text + "]";
    }

    @Override
    public void visit(ConditionValueString o) {
        this.text = this.text + "\"" + o.getValue() + "\"";
    }

    @Override
    public boolean visitEnter(ContainsAll o) {
        this.text = this.text + o.getElement().getValue() + "=" + "[";
        return true;
    }

    @Override
    public boolean visitMiddle(ContainsAll o) {
        this.text = this.text + ",";
        return true;
    }

    @Override
    public void visitLeave(ContainsAll o, boolean enterOrMiddleResult) {
        this.text = this.text + "]";
    }

    @Override
    public boolean visitEnter(ContainsOne o) {
        this.text = this.text + o.getElement().getValue() + "=" + "{";
        return true;
    }

    @Override
    public boolean visitMiddle(ContainsOne o) {
        this.text = this.text + ",";
        return true;
    }

    @Override
    public void visitLeave(ContainsOne o, boolean enterOrMiddleResult) {
        this.text = this.text + "}";
    }

    @Override
    public boolean visitEnter(Equals o) {
        this.text = this.text + o.getElement().getValue();
        this.text = o.isIgnoreCaseAndAccent() ? this.text + "~" : this.text + "=";
        return true;
    }

    @Override
    public void visitLeave(Equals o, boolean enterOrMiddleResult) {
    }

    @Override
    public void visit(False o) {
        this.text = this.text + "FALSE";
    }

    @Override
    public boolean visitEnter(Greater o) {
        this.text = this.text + o.getElement().getValue() + ">";
        return true;
    }

    @Override
    public void visitLeave(Greater o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(GreaterOrEquals o) {
        this.text = this.text + o.getElement().getValue() + ">=";
        return true;
    }

    @Override
    public void visitLeave(GreaterOrEquals o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(Keyword o) {
        return true;
    }

    @Override
    public void visitLeave(Keyword o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(Less o) {
        this.text = this.text + o.getElement().getValue() + "<";
        return true;
    }

    @Override
    public void visitLeave(Less o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(LessOrEquals o) {
        this.text = this.text + o.getElement().getValue() + "<=";
        return true;
    }

    @Override
    public void visitLeave(LessOrEquals o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(Like o) {
        this.text = this.text + o.getElement().getValue() + " " + "LIKE" + " ";
        return true;
    }

    @Override
    public void visitLeave(Like o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(Unlike o) {
        this.text = this.text + o.getElement().getValue() + " " + "UNLIKE" + " ";
        return true;
    }

    @Override
    public void visitLeave(Unlike o, boolean enterOrMiddleResult) {
    }

    @Override
    public boolean visitEnter(NotEquals o) {
        this.text = this.text + o.getElement().getValue();
        this.text = o.isIgnoreCaseAndAccent() ? this.text + "!~" : this.text + "!=";
        return true;
    }

    @Override
    public void visitLeave(NotEquals o, boolean enterOrMiddleResult) {
    }

    @Override
    public void visit(Null o) {
        this.text = this.text + o.getElement().getValue() + "=" + "NULL";
    }

    @Override
    public void visit(NotNull o) {
        this.text = this.text + o.getElement().getValue() + "!=" + "NULL";
    }

    @Override
    public void visit(True o) {
        this.text = this.text + "TRUE";
    }

    @Override
    public boolean visitEnter(WikittyQueryFunction function) {
        this.text = this.text + function.getMethodName() + "(";
        return true;
    }

    @Override
    public boolean visitMiddle(WikittyQueryFunction function) {
        this.text = this.text + ",";
        return true;
    }

    @Override
    public void visitLeave(WikittyQueryFunction function, boolean enterOrMiddleResult) {
        this.text = this.text + ")";
        if (StringUtils.isNotBlank((CharSequence)function.getName())) {
            this.text = this.text + " AS " + function.getName();
        }
    }

    @Override
    public void visit(FunctionValue function) {
        this.text = this.text + '\"' + String.valueOf(function.getValue()).replaceAll("\"", "\\\"") + '\"';
    }

    @Override
    public void defaultVisit(Object o) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }

    @Override
    public boolean defaultVisitEnter(Object o) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }

    @Override
    public boolean defaultVisitMiddle(Object o) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }

    @Override
    public void defaultVisitLeave(Object o, boolean enterResult) {
        throw new UnsupportedOperationException("Not supported:" + o.getClass());
    }
}

