/*
 * #%L
 * Nuiton Web :: Nuiton Tapestry
 * 
 * $Id: NuitonModule.java 80 2011-06-28 12:25:30Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-web/tags/nuiton-web-1.13/nuiton-tapestry/src/main/java/org/nuiton/web/tapestry5/services/NuitonModule.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.web.tapestry5.services;

import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.services.BindingFactory;
import org.apache.tapestry5.services.BindingSource;
import org.apache.tapestry5.services.LibraryMapping;

/**
 * NuitonModule
 * <p/>
 * Created: 4 mai 2010
 *
 * @author fdesbois
 * @version $Id: NuitonModule.java 80 2011-06-28 12:25:30Z tchemit $
 */
public class NuitonModule {

    private static final String PACKAGE_ROOT = "org.nuiton.web.tapestry5";

    public void contributeComponentClassResolver(
            Configuration<LibraryMapping> configuration) {

        configuration.add(new LibraryMapping("nuiton", PACKAGE_ROOT));
    }

    public static void contributeBindingSource(
            MappedConfiguration<String, BindingFactory> configuration,
            BindingSource bindingSource) {

        configuration.add("format", new FormatBindingFactory(bindingSource));
    }

}
