/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security.actions;

import java.util.List;
import org.nuiton.web.SecurityTopiaPersistenceContext;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityRoleTopiaDao;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserTopiaDao;
import org.nuiton.web.security.actions.AbstractAction;

public class UserRolesAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected SecurityUserTopiaDao securityUserDAO;
    protected SecurityRoleTopiaDao securityRoleDAO;
    protected List<SecurityUser> users;
    protected List<SecurityRole> roles;
    protected List<String> userIds;

    public String input() throws Exception {
        SecurityTopiaPersistenceContext transaction = this.rootContext.newPersistenceContext();
        this.securityUserDAO = transaction.getSecurityUserDao();
        this.securityRoleDAO = transaction.getSecurityRoleDao();
        this.users = this.securityUserDAO.newQueryBuilder().setOrderByArguments(new String[]{"login"}).findAll();
        this.roles = this.securityRoleDAO.newQueryBuilder().setOrderByArguments(new String[]{"name"}).findAll();
        transaction.closeContext();
        return super.input();
    }

    public List<SecurityUser> getUsers() {
        return this.users;
    }

    public List<SecurityRole> getRoles() {
        return this.roles;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public String execute() throws Exception {
        String result = super.execute();
        if (this.userIds == null) {
            result = this.input();
        } else {
            try {
                SecurityTopiaPersistenceContext transaction = this.rootContext.newPersistenceContext();
                this.securityUserDAO = transaction.getSecurityUserDao();
                this.securityRoleDAO = transaction.getSecurityRoleDao();
                for (String userId : this.userIds) {
                    SecurityUser securityUser = (SecurityUser)this.securityUserDAO.findByTopiaId(userId);
                    securityUser.clearSecurityRole();
                    String[] roleIds = this.getParameters("roles-" + userId);
                    if (roleIds == null) continue;
                    for (String roleId : roleIds) {
                        SecurityRole secuRole = (SecurityRole)this.securityRoleDAO.findByTopiaId(roleId);
                        securityUser.addSecurityRole(secuRole);
                    }
                }
                transaction.commit();
                transaction.closeContext();
            }
            catch (Exception ex) {
                this.addActionError(ex.getMessage());
                result = this.input();
            }
        }
        return result;
    }
}

