package org.nuiton.web.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.web.SecurityDAOHelper.SecurityEntityEnum;

public abstract class SecurityUserDAOAbstract<E extends SecurityUser> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)SecurityUser.class;
    }

    @Override
    public SecurityEntityEnum getTopiaEntityEnum() {
        return SecurityEntityEnum.SecurityUser;
    }

    public E findByLogin(String v) throws TopiaException {
        E result = findByProperty(SecurityUser.LOGIN, v);
        return result;
    }

    public List<E> findAllByLogin(String v) throws TopiaException {
        List<E> result = findAllByProperty(SecurityUser.LOGIN, v);
        return result;
    }

    public E findByPassword(String v) throws TopiaException {
        E result = findByProperty(SecurityUser.PASSWORD, v);
        return result;
    }

    public List<E> findAllByPassword(String v) throws TopiaException {
        List<E> result = findAllByProperty(SecurityUser.PASSWORD, v);
        return result;
    }

    public E findByExternalId(String v) throws TopiaException {
        E result = findByProperty(SecurityUser.EXTERNAL_ID, v);
        return result;
    }

    public List<E> findAllByExternalId(String v) throws TopiaException {
        List<E> result = findAllByProperty(SecurityUser.EXTERNAL_ID, v);
        return result;
    }

    public E findContainsSecurityRole(SecurityRole v) throws TopiaException {
        E result = findContains(SecurityUser.SECURITY_ROLE, v);
        return result;
    }

    public List<E> findAllContainsSecurityRole(SecurityRole v) throws TopiaException {
        List<E> result = findAllContains(SecurityUser.SECURITY_ROLE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //SecurityUserDAOAbstract<E extends SecurityUser>
