/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.actions;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.service.sql.batch.actions.AbstractTablesAction;
import org.nuiton.topia.service.sql.batch.actions.DeleteTablesRequest;
import org.nuiton.topia.service.sql.batch.tables.TopiaSqlTable;

public class DeleteTablesAction
extends AbstractTablesAction<DeleteTablesRequest> {
    public static final String DELETE_STATEMENT = "DELETE FROM %s.%s WHERE topiaId = '%%s'";
    private static final Log log = LogFactory.getLog(DeleteTablesAction.class);

    public DeleteTablesAction(DeleteTablesRequest request) {
        super(request);
    }

    @Override
    protected void executeOnTable(DeleteTablesRequest request, TopiaSqlTable table, PreparedStatement readStatement) throws SQLException {
        ResultSet readResultSet = readStatement.getResultSet();
        ResultSetMetaData readResultSetMetaData = readResultSet.getMetaData();
        int columnCount = readResultSetMetaData.getColumnCount();
        List<String> columnNames = this.getColumnNames(readResultSetMetaData, columnCount);
        String topiaIdColumnName = "topiaId".toLowerCase();
        int topiaIdColumnIndex = columnNames.indexOf(topiaIdColumnName);
        boolean useOutputWriter = this.useOutputWriter();
        boolean useOutputDb = this.useOutputDb();
        PreparedStatement writeStatement = null;
        String deleteStatementSql = this.newDeleteStatementSql(table);
        if (useOutputDb) {
            String sql = String.format(deleteStatementSql, "?");
            writeStatement = this.targetConnection.prepareStatement(sql);
        }
        int writeBatchSize = request.getWriteBatchSize();
        String tableName = table.getFullyTableName();
        long index = 0L;
        while (readResultSet.next()) {
            String topiaId = readResultSet.getString(topiaIdColumnIndex);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Delete " + topiaId));
            }
            if (useOutputDb) {
                writeStatement.clearParameters();
                writeStatement.setObject(1, topiaId);
                writeStatement.addBatch();
            }
            if (useOutputWriter) {
                try {
                    String sql = String.format(deleteStatementSql, topiaId);
                    this.writer.append(sql);
                }
                catch (IOException e) {
                    throw new TopiaException("Could not deleteRow", (Throwable)e);
                }
            }
            if (++index % (long)writeBatchSize != 0L) continue;
            this.flush(writeStatement, this.writer, tableName, index);
        }
        this.flush(writeStatement, this.writer, tableName, index);
    }

    protected String newDeleteStatementSql(TopiaSqlTable table) throws SQLException {
        String sql = String.format(DELETE_STATEMENT, table.getSchemaName(), table.getTableName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delete sql: " + sql));
        }
        return sql;
    }
}

