package org.nuiton.topia.taas.entities;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class TaasUserDAOAbstract<E extends TaasUser> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TaasUser.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByLogin :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut login le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLogin(String v) throws TopiaException {
        E result = findByProperty("login", v);
        return result;
    }

    /**
     * findAllByLogin :
     * Retourne les éléments ayant comme valeur pour l'attribut login le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLogin(String v) throws TopiaException {
        List<E> result = findAllByProperty("login", v);
        return result;
    }

    /**
     * findByPassword :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut password le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPassword(String v) throws TopiaException {
        E result = findByProperty("password", v);
        return result;
    }

    /**
     * findAllByPassword :
     * Retourne les éléments ayant comme valeur pour l'attribut password le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPassword(String v) throws TopiaException {
        List<E> result = findAllByProperty("password", v);
        return result;
    }

    /**
     * findByEmail :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut email le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEmail(String v) throws TopiaException {
        E result = findByProperty("email", v);
        return result;
    }

    /**
     * findAllByEmail :
     * Retourne les éléments ayant comme valeur pour l'attribut email le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEmail(String v) throws TopiaException {
        List<E> result = findAllByProperty("email", v);
        return result;
    }

    /**
     * findByEnabled :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut enabled le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEnabled(boolean v) throws TopiaException {
        E result = findByProperty("enabled", v);
        return result;
    }

    /**
     * findAllByEnabled :
     * Retourne les éléments ayant comme valeur pour l'attribut enabled le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEnabled(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("enabled", v);
        return result;
    }

    /**
     * findByLastConnectionDate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut lastConnectionDate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLastConnectionDate(Date v) throws TopiaException {
        E result = findByProperty("lastConnectionDate", v);
        return result;
    }

    /**
     * findAllByLastConnectionDate :
     * Retourne les éléments ayant comme valeur pour l'attribut lastConnectionDate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLastConnectionDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty("lastConnectionDate", v);
        return result;
    }

    /**
     * findByNumberOfConnection :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut numberOfConnection le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByNumberOfConnection(int v) throws TopiaException {
        E result = findByProperty("numberOfConnection", v);
        return result;
    }

    /**
     * findAllByNumberOfConnection :
     * Retourne les éléments ayant comme valeur pour l'attribut numberOfConnection le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByNumberOfConnection(int v) throws TopiaException {
        List<E> result = findAllByProperty("numberOfConnection", v);
        return result;
    }

    /**
     * findByLink :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut link le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLink(String v) throws TopiaException {
        E result = findByProperty("link", v);
        return result;
    }

    /**
     * findAllByLink :
     * Retourne les éléments ayant comme valeur pour l'attribut link le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLink(String v) throws TopiaException {
        List<E> result = findAllByProperty("link", v);
        return result;
    }

    /**
     * findContainsPrincipals :
     * Retourne le premier élément trouvé dont l'attribut principals contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPrincipals(TaasPrincipal... v) throws TopiaException {
        E result = findContainsProperties("principals", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPrincipals :
     * Retourne les éléments trouvé dont l'attribut principals contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPrincipals(TaasPrincipal... v) throws TopiaException {
        List<E> results = findAllContainsProperties("principals", Arrays.asList(v));
        return results;
    }


} //TaasUserDAOAbstract<E extends TaasUser>
