/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.support.SlowQueryWatcher;
import org.nuiton.topia.persistence.support.SqlFunction;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaSqlQuery;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.support.TopiaSqlWork;

public class HibernateTopiaSqlSupport
implements TopiaSqlSupport {
    protected TopiaHibernateSupport hibernateSupport;
    protected Session session;
    protected Optional<Duration> slowQueriesThreshold;

    public HibernateTopiaSqlSupport(TopiaHibernateSupport hibernateSupport, Optional<Duration> slowQueriesThreshold) {
        this.hibernateSupport = hibernateSupport;
        this.slowQueriesThreshold = slowQueriesThreshold;
    }

    public HibernateTopiaSqlSupport(Session session) {
        this.session = session;
        this.slowQueriesThreshold = Optional.empty();
    }

    @Override
    public void setSlowQueriesThreshold(Duration slowQueriesThreshold) {
        this.slowQueriesThreshold = Optional.ofNullable(slowQueriesThreshold);
    }

    protected SlowQueryWatcher monitorWork(Work query) {
        if (!this.slowQueriesThreshold.isPresent()) {
            return null;
        }
        Supplier<String> descriptionSupplier = () -> {
            String queryString;
            if (query instanceof HibernateTopiaSqlQueryWork && ((HibernateTopiaSqlQueryWork)query).query.getSqlQuery().isPresent()) {
                HibernateTopiaSqlQueryWork tsqWork = (HibernateTopiaSqlQueryWork)query;
                Optional<String> sqlQuery = tsqWork.query.getSqlQuery();
                Optional<List<?>> sqlArgs = tsqWork.query.getSqlArgs();
                queryString = sqlQuery.get();
                boolean hasArgs = sqlArgs.map(l -> !l.isEmpty()).orElse(false);
                if (hasArgs) {
                    queryString = queryString + " -- with args: " + sqlArgs.get();
                }
            } else {
                queryString = query instanceof HibernateSqlWork ? ((HibernateSqlWork)query).script : query.toString();
            }
            String description = String.format("SQL work: %s", queryString);
            return description;
        };
        long thresholdMillis = this.slowQueriesThreshold.get().toMillis();
        SlowQueryWatcher result = SlowQueryWatcher.start(descriptionSupplier, thresholdMillis);
        return result;
    }

    @Override
    public void executeSql(String sqlScript) {
        HibernateSqlWork work = new HibernateSqlWork(sqlScript);
        try (SlowQueryWatcher m = this.monitorWork(work);){
            this.getHibernateSession().doWork((Work)work);
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not execute sql code", e);
        }
    }

    protected Session getHibernateSession() {
        Session result = this.session;
        if (result == null) {
            result = this.hibernateSupport.getHibernateSession();
        }
        return result;
    }

    @Override
    public void doSqlWork(TopiaSqlWork sqlWork) {
        HibernateTopiaSqlWork work = new HibernateTopiaSqlWork(sqlWork);
        try (SlowQueryWatcher m = this.monitorWork(work);){
            this.getHibernateSession().doWork((Work)work);
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not execute sql code", e);
        }
    }

    @Override
    public <O> O findSingleResult(TopiaSqlQuery<O> query) throws TopiaException {
        HibernateTopiaSqlQueryWork<O> work = new HibernateTopiaSqlQueryWork<O>(query, false);
        try (SlowQueryWatcher m = this.monitorWork(work);){
            this.getHibernateSession().doWork(work);
        }
        List<O> result = work.getResult();
        return result.isEmpty() ? null : (O)result.get(0);
    }

    @Override
    public <O> O findSingleResult(SqlFunction<Connection, PreparedStatement> preparer, SqlFunction<ResultSet, O> transformer) throws TopiaException {
        TopiaSqlQuery<O> query = TopiaSqlQuery.wrap(preparer, transformer);
        O result = this.findSingleResult(query);
        return result;
    }

    @Override
    public <O> O findSingleResult(String sql, SqlFunction<ResultSet, O> transformer) throws TopiaException {
        TopiaSqlQuery<O> query = TopiaSqlQuery.wrap(sql, transformer);
        O result = this.findSingleResult(query);
        return result;
    }

    @Override
    public <O> List<O> findMultipleResult(TopiaSqlQuery<O> query) throws TopiaException {
        HibernateTopiaSqlQueryWork<O> work = new HibernateTopiaSqlQueryWork<O>(query, true);
        try (SlowQueryWatcher m = this.monitorWork(work);){
            this.getHibernateSession().doWork(work);
        }
        List<O> result = work.getResult();
        return result;
    }

    @Override
    public <O> List<O> findMultipleResult(SqlFunction<Connection, PreparedStatement> preparer, SqlFunction<ResultSet, O> transformer) throws TopiaException {
        TopiaSqlQuery<O> query = TopiaSqlQuery.wrap(preparer, transformer);
        List<O> result = this.findMultipleResult(query);
        return result;
    }

    @Override
    public <O> List<O> findMultipleResult(String sql, SqlFunction<ResultSet, O> transformer) throws TopiaException {
        TopiaSqlQuery<O> query = TopiaSqlQuery.wrap(sql, transformer);
        List<O> result = this.findMultipleResult(query);
        return result;
    }

    public static class HibernateTopiaSqlQueryWork<O>
    implements Work {
        protected final TopiaSqlQuery<O> query;
        protected final boolean multipleResult;
        protected final List<O> result = new ArrayList<O>();

        public HibernateTopiaSqlQueryWork(TopiaSqlQuery<O> query, boolean multipleResult) {
            this.query = query;
            this.multipleResult = multipleResult;
        }

        public void execute(Connection connection) {
            try (PreparedStatement ps = this.query.prepareQuery(connection);){
                ResultSet set = ps.executeQuery();
                this.query.afterExecuteQuery(set);
                if (set.next()) {
                    O singleResult = this.query.prepareResult(set);
                    if (singleResult != null) {
                        this.result.add(singleResult);
                    }
                    if (this.multipleResult) {
                        while (set.next()) {
                            singleResult = this.query.prepareResult(set);
                            if (singleResult == null) continue;
                            this.result.add(singleResult);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new TopiaException("Could not execute query", e);
            }
        }

        public List<O> getResult() {
            return this.result;
        }
    }

    public static class HibernateTopiaSqlWork
    implements Work {
        protected final TopiaSqlWork work;

        public HibernateTopiaSqlWork(TopiaSqlWork work) {
            this.work = work;
        }

        public void execute(Connection connection) throws SQLException {
            this.work.execute(connection);
        }
    }

    public static class HibernateSqlWork
    implements Work {
        protected final String script;

        public HibernateSqlWork(String script) {
            this.script = script;
        }

        public void execute(Connection connection) throws SQLException {
            try (PreparedStatement sta = connection.prepareStatement(this.script);){
                sta.execute();
            }
        }
    }
}

