/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaApplicationContextCache;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaConfigurationBuilder;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaMigrationService;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaService;
import org.nuiton.topia.persistence.event.TopiaEntitiesVetoable;
import org.nuiton.topia.persistence.event.TopiaEntityListener;
import org.nuiton.topia.persistence.event.TopiaEntityVetoable;
import org.nuiton.topia.persistence.event.TopiaSchemaListener;
import org.nuiton.topia.persistence.event.TopiaTransactionListener;
import org.nuiton.topia.persistence.event.TopiaTransactionVetoable;
import org.nuiton.topia.persistence.internal.HibernateProvider;
import org.nuiton.topia.persistence.internal.TopiaHibernateSessionRegistry;
import org.nuiton.topia.persistence.internal.support.TopiaFiresSupport;
import org.nuiton.topia.persistence.internal.support.TopiaServiceSupportImpl;
import org.nuiton.topia.persistence.support.TopiaServiceSupport;
import org.nuiton.topia.persistence.util.TopiaUtil;

public abstract class AbstractTopiaApplicationContext<K extends TopiaPersistenceContext>
implements TopiaApplicationContext<K> {
    private static final Log log = LogFactory.getLog(AbstractTopiaApplicationContext.class);
    protected TopiaIdFactory topiaIdFactory;
    protected TopiaConfiguration configuration;
    protected TopiaFiresSupport topiaFiresSupport;
    protected TopiaServiceSupport topiaServiceSupport;
    protected HibernateProvider hibernateProvider;
    protected TopiaHibernateSessionRegistry sessionRegistry;
    protected boolean closed = false;
    protected Set<TopiaPersistenceContext> persistenceContexts = Collections.newSetFromMap(new WeakHashMap());

    @Deprecated
    public AbstractTopiaApplicationContext(Properties properties) {
        this(new TopiaConfigurationBuilder().readProperties(properties));
    }

    @Deprecated
    public AbstractTopiaApplicationContext(Map<String, String> map) {
        this(new TopiaConfigurationBuilder().readMap(map));
    }

    public AbstractTopiaApplicationContext(TopiaConfiguration configuration) {
        this.configuration = configuration;
        this.init();
    }

    protected void init() {
        new TopiaConfigurationBuilder().check(this.configuration);
        this.topiaFiresSupport = new TopiaFiresSupport();
        this.sessionRegistry = new TopiaHibernateSessionRegistry();
        this.initServices();
        if (this.isInitSchema()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Schema initialization enabled");
            }
            this.initSchema();
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Schema initialization disabled");
        }
        this.getHibernateProvider().getHibernateConfiguration();
    }

    protected void initServices() {
        TopiaServiceSupportImpl topiaServiceSupportImpl = new TopiaServiceSupportImpl();
        this.topiaServiceSupport = topiaServiceSupportImpl;
        topiaServiceSupportImpl.initServices(this);
    }

    protected boolean isInitSchema() {
        boolean initSchema = this.configuration.isInitSchema();
        return initSchema;
    }

    @Override
    public void initSchema() {
        boolean migrationServiceEnabled;
        Collection<TopiaMigrationService> migrationServices = this.getServices(TopiaMigrationService.class).values();
        Preconditions.checkState((migrationServices.size() <= 1 ? 1 : 0) != 0, (Object)("your configuration include multiple migration services: " + migrationServices));
        boolean bl = migrationServiceEnabled = !migrationServices.isEmpty();
        if (this.isSchemaEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"schema is empty, will create");
            }
            this.createSchema();
            if (migrationServiceEnabled) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"schema created, will call migration service");
                }
                TopiaMigrationService migrationService = (TopiaMigrationService)Iterables.getOnlyElement(migrationServices);
                migrationService.initOnCreateSchema();
            } else if (log.isInfoEnabled()) {
                log.info((Object)"schema created, no migration service provided");
            }
        } else if (migrationServiceEnabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)"schema exists, will try to migrate");
            }
            TopiaMigrationService migrationService = (TopiaMigrationService)Iterables.getOnlyElement(migrationServices);
            migrationService.runSchemaMigration();
        } else if (log.isInfoEnabled()) {
            log.info((Object)"schema exists, no migration service provided");
        }
    }

    protected abstract Set<Class<? extends TopiaEntity>> getImplementationClasses();

    protected void registerPersistenceContext(TopiaPersistenceContext persistenceContext) {
        this.persistenceContexts.add(persistenceContext);
    }

    public HibernateProvider getHibernateProvider() {
        if (this.hibernateProvider == null) {
            this.hibernateProvider = new HibernateProvider(this.getConfiguration(), this.topiaServiceSupport, this.sessionRegistry, this.getImplementationClasses());
        }
        return this.hibernateProvider;
    }

    protected TopiaFiresSupport getTopiaFiresSupport() {
        return this.topiaFiresSupport;
    }

    @Override
    public TopiaConfiguration getConfiguration() {
        return this.configuration;
    }

    protected TopiaIdFactory getTopiaIdFactory() {
        return this.getConfiguration().getTopiaIdFactory();
    }

    public TopiaHibernateSessionRegistry getSessionRegistry() {
        return this.sessionRegistry;
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaFiresSupport.addTopiaEntityListener(listener);
    }

    @Override
    public void addTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.topiaFiresSupport.addTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaFiresSupport.removeTopiaEntityListener(listener);
    }

    @Override
    public void removeTopiaEntityListener(Class<? extends TopiaEntity> entityClass, TopiaEntityListener listener) {
        this.topiaFiresSupport.removeTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.addTopiaEntityVetoable(vetoable);
    }

    @Override
    public void addTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.addTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.removeTopiaEntityVetoable(vetoable);
    }

    @Override
    public void removeTopiaEntityVetoable(Class<? extends TopiaEntity> entityClass, TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.removeTopiaEntityVetoable(entityClass, vetoable);
    }

    @Override
    public void addTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.topiaFiresSupport.addTopiaEntitiesVetoable(vetoable);
    }

    @Override
    public void removeTopiaEntitiesVetoable(TopiaEntitiesVetoable vetoable) {
        this.topiaFiresSupport.removeTopiaEntitiesVetoable(vetoable);
    }

    @Override
    public void addTopiaTransactionListener(TopiaTransactionListener listener) {
        this.topiaFiresSupport.addTopiaTransactionListener(listener);
    }

    @Override
    public void removeTopiaTransactionListener(TopiaTransactionListener listener) {
        this.topiaFiresSupport.removeTopiaTransactionListener(listener);
    }

    @Override
    public void addTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.topiaFiresSupport.addTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void removeTopiaTransactionVetoable(TopiaTransactionVetoable vetoable) {
        this.topiaFiresSupport.removeTopiaTransactionVetoable(vetoable);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.topiaFiresSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.topiaFiresSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addTopiaSchemaListener(TopiaSchemaListener listener) {
        this.topiaFiresSupport.addTopiaSchemaListener(listener);
    }

    @Override
    public void removeTopiaSchemaListener(TopiaSchemaListener listener) {
        this.topiaFiresSupport.removeTopiaSchemaListener(listener);
    }

    @Override
    public Map<String, TopiaService> getServices() {
        return this.topiaServiceSupport.getServices();
    }

    @Override
    public <T extends TopiaService> Map<String, T> getServices(Class<T> interfaceService) {
        return this.topiaServiceSupport.getServices(interfaceService);
    }

    @Override
    public List<Class<?>> getPersistenceClasses() {
        return new ArrayList(this.getImplementationClasses());
    }

    @Override
    public boolean isSchemaEmpty() {
        Configuration configuration = this.getHibernateProvider().getHibernateConfiguration();
        boolean result = TopiaUtil.isSchemaEmpty(configuration);
        return result;
    }

    @Override
    public boolean isTableExists(Class<?> clazz) {
        Configuration configuration = this.getHibernateProvider().getHibernateConfiguration();
        boolean result = TopiaUtil.isSchemaExist(configuration, clazz.getName());
        return result;
    }

    @Override
    public String getSchemaName() {
        return this.getConfiguration().getSchemaName();
    }

    @Override
    public void createSchema() {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            this.topiaFiresSupport.firePreCreateSchema(this);
            Configuration hibernateConfiguration = this.getHibernateProvider().getHibernateConfiguration();
            new SchemaExport(hibernateConfiguration).execute(showSchema, true, false, true);
            this.topiaFiresSupport.firePostCreateSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not create schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void showCreateSchema() {
        try {
            Configuration hibernateConfiguration = this.getHibernateProvider().getHibernateConfiguration();
            new SchemaExport(hibernateConfiguration).execute(true, false, false, true);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not show create schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void updateSchema() {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            this.topiaFiresSupport.firePreUpdateSchema(this);
            Configuration hibernateConfiguration = this.getHibernateProvider().getHibernateConfiguration();
            new SchemaUpdate(hibernateConfiguration).execute(showSchema, true);
            this.topiaFiresSupport.firePostUpdateSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not update schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void dropSchema() {
        try {
            boolean showSchema = false;
            if (log.isDebugEnabled()) {
                showSchema = true;
            }
            this.topiaFiresSupport.firePreDropSchema(this);
            Configuration hibernateConfiguration = this.getHibernateProvider().getHibernateConfiguration();
            new SchemaExport(hibernateConfiguration).execute(showSchema, true, true, false);
            this.topiaFiresSupport.firePostDropSchema(this);
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not drop schema for reason: %s", eee.getMessage()), eee);
        }
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"TopiaApplicationContext was already closed");
        if (log.isDebugEnabled()) {
            log.debug((Object)("will close " + this));
        }
        for (TopiaPersistenceContext persistenceContext : this.persistenceContexts) {
            if (persistenceContext == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"null TopiaPersistenceContext found in #persistenceContexts");
                continue;
            }
            try {
                if (persistenceContext.isClosed()) continue;
                persistenceContext.close();
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"unable to close TopiaPersistenceContext", (Throwable)eee);
            }
        }
        this.hibernateProvider.close();
        for (TopiaService topiaService : this.getServices().values()) {
            topiaService.close();
        }
        this.closed = true;
        TopiaApplicationContextCache.removeContext(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " closed"));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

