package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topiatest.deletetest.Party2DAOImpl;


public  abstract class PersonneDAOAbstract<E extends Personne> extends Party2DAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Personne.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Personne.PROPERTY_NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Personne.PROPERTY_NAME, v);
        return result;
    }

    /**
     * findContainsOtherNames :
     * Retourne le premier élément ayant comme valeur pour l'attribut otherNames le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsOtherNames(String v) throws TopiaException {
        E result = findContains(Personne.PROPERTY_OTHER_NAMES, v);
        return result;
    }

    /**
     * findAllContainsOtherNames :
     * Retourne les éléments ayant comme valeur pour l'attribut otherNames le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsOtherNames(String v) throws TopiaException {
        List<E> result = findAllContains(Personne.PROPERTY_OTHER_NAMES, v);
        return result;
    }

    /**
     * findByGender :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut gender le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGender(Gender v) throws TopiaException {
        E result = findByProperty(Personne.PROPERTY_GENDER, v);
        return result;
    }

    /**
     * findAllByGender :
     * Retourne les éléments ayant comme valeur pour l'attribut gender le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGender(Gender v) throws TopiaException {
        List<E> result = findAllByProperty(Personne.PROPERTY_GENDER, v);
        return result;
    }

    /**
     * findByOtherGender :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut otherGender le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByOtherGender(Gender v) throws TopiaException {
        E result = findByProperty(Personne.PROPERTY_OTHER_GENDER, v);
        return result;
    }

    /**
     * findAllByOtherGender :
     * Retourne les éléments ayant comme valeur pour l'attribut otherGender le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByOtherGender(Gender v) throws TopiaException {
        List<E> result = findAllByProperty(Personne.PROPERTY_OTHER_GENDER, v);
        return result;
    }

    /**
     * findByAddress :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut address le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAddress(Address v) throws TopiaException {
        E result = findByProperty(Personne.PROPERTY_ADDRESS, v);
        return result;
    }

    /**
     * findAllByAddress :
     * Retourne les éléments ayant comme valeur pour l'attribut address le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAddress(Address v) throws TopiaException {
        List<E> result = findAllByProperty(Personne.PROPERTY_ADDRESS, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //PersonneDAOAbstract<E extends Personne>
