/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonDAO;

public class TopiaDAOTest {
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();

    @Test
    public void testCreateAndFindInTransaction() throws Exception {
        TopiaContext context = this.db.beginTransaction();
        PersonDAO personDAO = TopiaTestDAOHelper.getPersonDAO(context);
        Person person = (Person)personDAO.create(new Object[]{"name", "toto"});
        List allPerson = personDAO.findAll();
        Assert.assertEquals((long)1L, (long)allPerson.size());
        context.commitTransaction();
        Person person2 = (Person)personDAO.create(new Object[]{"name", "titi"});
        allPerson = personDAO.findAll();
        Assert.assertEquals((long)2L, (long)allPerson.size());
        Assert.assertThat((Object)allPerson, (Matcher)JUnitMatchers.hasItem((Object)person2));
        context.rollbackTransaction();
        Person person3 = (Person)personDAO.create(new Object[]{"name", "tata"});
        allPerson = personDAO.findAll();
        Assert.assertEquals((long)2L, (long)allPerson.size());
        Assert.assertThat((Object)allPerson, (Matcher)JUnitMatchers.hasItem((Object)person3));
        context.commitTransaction();
    }
}

