/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AddressDAOAbstract<E extends Address> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Address.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Address;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Personne> list = getContext()
                                                    .getDAO(Personne.class)
                                                    .findAllByProperties(Personne.PROPERTY_ADDRESS, entity);
                                            for (Personne item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getAddress())) {
                                                    item.setAddress(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByCity(String v) throws TopiaException {
        E result = findByProperty(Address.PROPERTY_CITY, v);
        return result;
    }

    public List<E> findAllByCity(String v) throws TopiaException {
        List<E> result = findAllByProperty(Address.PROPERTY_CITY, v);
        return result;
    }

    public E findByAdress(String v) throws TopiaException {
        E result = findByProperty(Address.PROPERTY_ADRESS, v);
        return result;
    }

    public List<E> findAllByAdress(String v) throws TopiaException {
        List<E> result = findAllByProperty(Address.PROPERTY_ADRESS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Personne.class) {
            PersonneDAO dao = (PersonneDAO)
                getContext().getDAO(Personne.class);
            tmp = dao.findAllByAddress(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Personne.class, entity);
        if (!list.isEmpty()) {
            result.put(Personne.class, list);
        }

        return result;
    }

} //AddressDAOAbstract<E extends Address>
