/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.AbstractMetaTransformer;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.validator.AttributeNamesValidator;
import org.nuiton.eugene.models.object.validator.ClassNamesValidator;
import org.nuiton.eugene.models.object.validator.ObjectModelValidator;
import org.nuiton.topia.generator.DAOAbstractTransformer;
import org.nuiton.topia.generator.DAOHelperTransformer;
import org.nuiton.topia.generator.DAOImplTransformer;
import org.nuiton.topia.generator.DAOTransformer;
import org.nuiton.topia.generator.EntityHibernateMappingGenerator;
import org.nuiton.topia.generator.EntityTransformer;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.generator.TopiaJavaValidator;
import org.nuiton.topia.generator.TopiaRelationValidator;

public class TopiaMetaTransformer
extends AbstractMetaTransformer<ObjectModel> {
    private static final Log log = LogFactory.getLog(TopiaMetaTransformer.class);

    public TopiaMetaTransformer() {
        this.setTemplateTypes(new Class[]{EntityTransformer.class, DAOTransformer.class, DAOImplTransformer.class, DAOAbstractTransformer.class, DAOHelperTransformer.class, EntityHibernateMappingGenerator.class});
    }

    protected boolean validateModel(ObjectModel model) {
        ArrayList<Object> validators = new ArrayList<Object>();
        AttributeNamesValidator attrValidator = new AttributeNamesValidator(model);
        attrValidator.addNameAndReason("next", "Le nom d'attribut \"next\" est incompatible avec HSQL");
        attrValidator.addNameAndReason("value", "Le nom d'attribut \"value\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("values", "Le nom d'attribut \"values\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("begin", "Le nom d'attribut \"begin\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("end", "Le nom d'attribut \"end\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("authorization", "Le nom d'attribut \"authorization\" est incompatible avec certains SGBD");
        attrValidator.addNameAndReason("order", "Le nom d'attribut \"order\" est incompatible avec certains SGBD");
        validators.add(attrValidator);
        ClassNamesValidator classValidator = new ClassNamesValidator(model);
        classValidator.addNameAndReason("constraint", "Nom de classe incompatible avec certains SGBD");
        classValidator.addNameAndReason("user", "Nom de classe incompatible avec certains SGBD");
        validators.add(classValidator);
        validators.add((Object)new TopiaJavaValidator(model));
        validators.add((Object)new TopiaRelationValidator(model));
        for (ObjectModelValidator objectModelValidator : validators) {
            if (objectModelValidator.validate()) continue;
            for (String error : objectModelValidator.getErrors()) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("[VALIDATION] " + error));
            }
        }
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model, true);
        if (classes.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No entity to generate, " + ((Object)((Object)this)).getClass().getName() + " is skipped"));
            }
            return false;
        }
        return true;
    }
}

