/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.topia.generator;

import java.util.ArrayList;
import java.util.List;

import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.validator.ObjectModelValidator;

/**
 * Validateur qui valide :
 *  - les types des attributs
 *  - les nom des attributs
 *  - les duplication d'attibuts
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 21 janv. 2009 $
 * By : $Author: chatellier $
 */
public class TopiaJavaValidator extends ObjectModelValidator {

    /**
     * Constructor.
     * 
     * @param model
     */
    public TopiaJavaValidator(ObjectModel model) {
        super(model);
    }

    /*
     * @see org.nuiton.eugene.models.object.validator.ObjectModelValidator#validateAttribute(org.nuiton.eugene.models.object.ObjectModelAttribute)
     */
    @Override
    protected boolean validateAttribute(ObjectModelAttribute attr) {

        boolean isValid = super.validateAttribute(attr);

        // type null ou vide
        if (attr.getType() == null || attr.getType().isEmpty()) {
            isValid = false;
            
            addError(attr, "Invalid type \"" + attr.getType() + "\"");
        }

        // name = java reserved keywords
        if (!isJavaIdentifier(attr.getName())) {
            isValid = false;
            
            addError(attr, "Attribute name " + attr.getName()
                    + " is not valid java identifier");
        }

        // test sur les mots réservés ?
        
        return isValid;

    }

    /*
     * @see org.nuiton.eugene.models.object.validator.ObjectModelValidator#validateClass(org.nuiton.eugene.models.object.ObjectModelClass)
     */
    @Override
    protected boolean validateClass(ObjectModelClass clazz) {

        boolean isValid = super.validateClass(clazz);
        
        // test attribute names duplication
        List<String> attributesName = new ArrayList<String>();
        for(ObjectModelAttribute attr : clazz.getAttributes()) {
            if(attributesName.contains(attr.getName())) {
                addError(attr, "Attribute name " + attr.getName()
                        + " already exists");
                
                isValid = false;
            }
            else {
                attributesName.add(attr.getName());
            }
        }
        
        return isValid;
    }

    /*
     * @see org.nuiton.eugene.models.object.validator.ObjectModelValidator#validateModel(org.nuiton.eugene.models.object.ObjectModel)
     */
    @Override
    protected boolean validateModel(ObjectModel model) {
        
        return super.validateModel(model);
    }

    /**
     * Returns true if s is a legal Java identifier.
     * 
     * @param s
     * @return true if s is a legal Java identifier
     */
    public static boolean isJavaIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); i++) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
        }
        return true;
    }
}
