/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.text.StyleContext;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;

public class SyntaxScheme
implements Cloneable {
    public Style[] styles = new Style[27];
    private static final String VERSION = "*ver1";

    public SyntaxScheme(boolean bl) {
        if (bl) {
            this.restoreDefaults();
        }
    }

    public Object clone() {
        SyntaxScheme syntaxScheme = null;
        try {
            syntaxScheme = (SyntaxScheme)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        syntaxScheme.styles = new Style[27];
        for (int i = 0; i < 27; ++i) {
            Style style = this.styles[i];
            if (style == null) continue;
            syntaxScheme.styles[i] = (Style)style.clone();
        }
        return syntaxScheme;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SyntaxScheme)) {
            return false;
        }
        Style[] styleArray = ((SyntaxScheme)object).styles;
        int n = this.styles.length;
        for (int i = 0; i < n; ++i) {
            if (!(this.styles[i] == null ? styleArray[i] != null : !this.styles[i].equals(styleArray[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.styles.length;
        for (int i = 0; i < n2; ++i) {
            if (this.styles[i] == null) continue;
            n ^= this.styles[i].hashCode();
            break;
        }
        return n;
    }

    public static SyntaxScheme loadFromString(String string) {
        SyntaxScheme syntaxScheme = new SyntaxScheme(true);
        try {
            if (string != null) {
                String[] stringArray = string.split(",", -1);
                if (stringArray.length == 0 || !VERSION.equals(stringArray[0])) {
                    return syntaxScheme;
                }
                int n = 27;
                int n2 = n * 7 + 1;
                if (stringArray.length != n2) {
                    throw new Exception("Not enough tokens in packed color scheme: expected " + n2 + ", found " + stringArray.length);
                }
                for (int i = 0; i < n; ++i) {
                    int n3 = i * 7 + 1;
                    int n4 = Integer.parseInt(stringArray[n3]);
                    if (n4 != i) {
                        throw new Exception("Expected " + i + ", found " + n4);
                    }
                    Color color = null;
                    String string2 = stringArray[n3 + 1];
                    if (!"-".equals(string2)) {
                        color = SyntaxScheme.stringToColor(string2);
                    }
                    Color color2 = null;
                    string2 = stringArray[n3 + 2];
                    if (!"-".equals(string2)) {
                        color2 = SyntaxScheme.stringToColor(string2);
                    }
                    if (!"t".equals(string2 = stringArray[n3 + 3]) && !"f".equals(string2)) {
                        throw new Exception("Expected 't' or 'f', found " + string2);
                    }
                    boolean bl = "t".equals(string2);
                    Font font = null;
                    String string3 = stringArray[n3 + 4];
                    if (!"-".equals(string3)) {
                        font = new Font(string3, Integer.parseInt(stringArray[n3 + 5]), Integer.parseInt(stringArray[n3 + 6]));
                    }
                    syntaxScheme.styles[i] = new Style(color, color2, font, bl);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return syntaxScheme;
    }

    void refreshFontMetrics(Graphics2D graphics2D) {
        for (int i = 0; i < this.styles.length; ++i) {
            Style style = this.styles[i];
            if (style == null) continue;
            style.fontMetrics = style.font == null ? null : graphics2D.getFontMetrics(style.font);
        }
    }

    public void restoreDefaults() {
        Font font;
        Color color = new Color(0, 128, 0);
        Color color2 = new Color(164, 0, 0);
        Color color3 = Color.BLUE;
        Color color4 = new Color(173, 128, 0);
        Color color5 = new Color(100, 0, 200);
        Color color6 = new Color(220, 0, 156);
        Color color7 = new Color(148, 148, 0);
        Font font2 = RSyntaxTextArea.getDefaultFont();
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        Font font3 = styleContext.getFont(font2.getFamily(), 1, font2.getSize());
        Font font4 = font = styleContext.getFont(font2.getFamily(), 2, font2.getSize());
        Font font5 = font3;
        this.styles[1] = new Style(color, null, font4);
        this.styles[2] = new Style(color, null, font4);
        this.styles[3] = new Style(color2, null, font4);
        this.styles[4] = new Style(color3, null, font5);
        this.styles[5] = new Style(color4, null);
        this.styles[6] = new Style(color5, null);
        this.styles[7] = new Style(color5, null);
        this.styles[8] = new Style(color5, null);
        this.styles[9] = new Style(color5, null);
        this.styles[10] = new Style(color6, null);
        this.styles[11] = new Style(color6, null);
        this.styles[12] = new Style(color6, null);
        this.styles[13] = new Style(new Color(0, 128, 128), null);
        this.styles[14] = new Style(new Color(255, 153, 0), null);
        this.styles[15] = new Style(null, null);
        this.styles[16] = new Style(null, null);
        this.styles[17] = new Style(Color.RED, null);
        this.styles[18] = new Style(new Color(128, 64, 64), null);
        this.styles[19] = new Style(new Color(128, 128, 128), null);
        this.styles[20] = new Style(Color.RED, null);
        this.styles[21] = new Style(Color.BLUE, null);
        this.styles[22] = new Style(new Color(63, 127, 127), null);
        this.styles[23] = new Style(color7, null);
        this.styles[24] = new Style(color7, null);
        this.styles[25] = new Style(color7, null);
        this.styles[26] = new Style(color7, null);
    }

    public void setStyle(int n, Style style) {
        this.styles[n] = style;
    }

    private static final Color stringToColor(String string) {
        return new Color(string.charAt(0) == '$' ? Integer.parseInt(string.substring(1), 16) : Integer.parseInt(string));
    }

    public String toCommaSeparatedString() {
        StringBuffer stringBuffer = new StringBuffer(VERSION);
        stringBuffer.append(',');
        for (int i = 0; i < 27; ++i) {
            stringBuffer.append(i).append(',');
            Style style = this.styles[i];
            if (style == null) {
                stringBuffer.append("-,-,f,-,,,");
                continue;
            }
            Color color = style.foreground;
            stringBuffer.append(color != null ? SyntaxScheme.getHexString(color) + "," : "-,");
            color = style.background;
            stringBuffer.append(color != null ? SyntaxScheme.getHexString(color) + "," : "-,");
            stringBuffer.append(style.underline ? "t," : "f,");
            Font font = style.font;
            if (font != null) {
                stringBuffer.append(font.getFamily()).append(',').append(font.getStyle()).append(',').append(font.getSize()).append(',');
                continue;
            }
            stringBuffer.append("-,,,");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private static final String getHexString(Color color) {
        return "$" + Integer.toHexString((color.getRGB() & 0xFFFFFF) + 0x1000000).substring(1);
    }
}

