/*
 * #%L
 * Nuiton Utils :: Nuiton Utils
 * 
 * $Id: Export.java 2233 2011-11-23 10:29:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.4/nuiton-csv/src/main/java/org/nuiton/util/csv/Export.java $
 * %%
 * Copyright (C) 2011 CodeLutin, Tony Chemit, Brendan Le Ny
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.util.csv;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/**
 * TODO
 *
 * @author bleny <leny@codelutin.com>
 * @author tchemit <chemit@codelutin.com>
 * @since 2.4
 */
public class Export<E> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(Export.class);

    protected ExportModel<E> model;

    protected Collection<E> data;

    public static <E> Export<E> newExport(ExportModel<E> model,
                                          Collection<E> data) {
        return new Export<E>(model, data);
    }

    protected Export(ExportModel<E> model, Collection<E> data) {
        this.model = model;
        this.data = data;
    }

    public String startExportAsString() throws Exception {
        String separator = String.valueOf(model.getSeparator());
        StringBuilder csv = new StringBuilder();

        // add headers
        List<String> headerNames = new LinkedList<String>();
        for (ExportableColumn<E, ?> column : model.getColumnsForExport()) {
            headerNames.add(column.getHeaderName());
        }
        String headersLine = StringUtil.join(headerNames, separator, true);
        csv.append(headersLine).append('\n');

        if (log.isDebugEnabled()) {
            log.debug("headers for export are '" + headersLine + "'");
            log.debug("will export " + data.size() + " lines");
        }

        Collection<ExportableColumn<E, Object>> columnsForExport =
                model.getColumnsForExport();

        for (E object : data) {
            for (ExportableColumn<E, Object> column :
                    columnsForExport) {
                Object value = column.getValue(object);
                String formattedValue = column.formatValue(value);
                if (formattedValue == null) {
                    throw new NullPointerException(
                            "column for header " + column.getHeaderName() +
                            " returned a null value." + column.toString());
                }
                formattedValue =
                        StringUtil.escapeCsvValue(formattedValue, separator);
                csv.append(formattedValue).append(separator);
            }
            csv.append('\n');
        }
        return csv.toString();
    }

    public InputStream startExport() throws Exception {
        String content = startExportAsString();
        return IOUtils.toInputStream(content);
    }
}
