/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.csv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;

public class Export<E> {
    private static final Log log = LogFactory.getLog(Export.class);
    protected ExportModel<E> model;
    protected Iterable<E> data;

    public static <E> Export<E> newExport(ExportModel<E> model, Iterable<E> data) {
        return new Export<E>(model, data);
    }

    public static <E> void exportToFile(ExportModel<E> model, Iterable<E> data, File file) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        exporter.exportToFile(file);
    }

    public static <E> String exportToString(ExportModel<E> model, Iterable<E> data) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        return exporter.startExportAsString();
    }

    public static <E> void exportToWriter(ExportModel<E> model, Iterable<E> data, Writer writer) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        exporter.startExport(writer);
    }

    protected Export(ExportModel<E> model, Iterable<E> data) {
        this.model = model;
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToFile(File file) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            this.startExport(writer);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public void startExport(Writer writer) throws Exception {
        String separator = String.valueOf(this.model.getSeparator());
        LinkedList<String> headerNames = new LinkedList<String>();
        for (ExportableColumn<E, Object> column : this.model.getColumnsForExport()) {
            headerNames.add(column.getHeaderName());
        }
        String headersLine = StringUtil.join(headerNames, (String)separator, (boolean)true);
        writer.write(headersLine);
        writer.write(10);
        if (log.isDebugEnabled()) {
            log.debug((Object)("headers for export are '" + headersLine + "'"));
            if (this.data instanceof Collection) {
                log.debug((Object)("will export " + ((Collection)this.data).size() + " lines"));
            }
        }
        Iterable<ExportableColumn<E, Object>> columnsForExport = this.model.getColumnsForExport();
        for (E object : this.data) {
            for (ExportableColumn<E, Object> column : columnsForExport) {
                Object value;
                String formattedValue = column.formatValue(value = column.getValue(object));
                if (formattedValue == null) {
                    throw new NullPointerException("column for header " + column.getHeaderName() + " returned a null value." + column.toString());
                }
                formattedValue = StringUtil.escapeCsvValue((String)formattedValue, (String)separator);
                writer.write(formattedValue);
                writer.write(separator);
            }
            writer.write(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startExportAsString() throws Exception {
        StringWriter writer = new StringWriter();
        try {
            String result;
            this.startExport(writer);
            String string = result = writer.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    public InputStream startExport() throws Exception {
        String content = this.startExportAsString();
        return IOUtils.toInputStream((String)content);
    }
}

