/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin;

import com.google.common.base.Joiner;
import java.io.File;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.config.ApplicationConfigHelper;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.config.plugin.ConfigMojoSupport;
import org.nuiton.config.plugin.model.ActionModel;
import org.nuiton.config.plugin.model.ConfigModel;
import org.nuiton.config.plugin.model.OptionModel;

@Mojo(name="describe", requiresDirectInvocation=true, defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.COMPILE)
public class DescribeMojo
extends ConfigMojoSupport {
    @Parameter(property="providerName")
    private String providerName;
    private ConfigModel configModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() throws Exception {
        ApplicationConfigProvider provider;
        super.init();
        if (this.providerName == null) {
            ArrayList<String> artifactIdPaths = new ArrayList<String>();
            for (String artifactIdPath : Arrays.asList(this.getProject().getArtifactId().replaceAll("-", ".").split("\\."))) {
                artifactIdPaths.add(StringUtils.capitalize((String)artifactIdPath));
            }
            this.providerName = Joiner.on((String)"").join(artifactIdPaths) + "Config";
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Use provider name: " + this.providerName));
        }
        URLClassLoader loader = this.initClassLoader(this.getProject(), new File(this.getProject().getBuild().getOutputDirectory()), true, false, true, true, true);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            provider = ApplicationConfigHelper.getProvider((ClassLoader)loader, (String)this.providerName);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        if (provider == null) {
            throw new MojoExecutionException("Could not find provider with name: " + this.providerName);
        }
        String modelName = StringUtils.removeEnd((String)provider.getName(), (String)"Config");
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Use model name: " + modelName));
        }
        if (this.getModelFile() == null) {
            this.setModelFile(modelName);
        }
        Files.createDirectories(this.getModelFile().getParentFile().toPath(), new FileAttribute[0]);
        String description = provider.getDescription(Locale.FRANCE);
        this.configModel = new ConfigModel();
        this.configModel.setDescription(description);
        LinkedList<OptionModel> optionModels = new LinkedList<OptionModel>();
        for (ConfigOptionDef configOptionDef : provider.getOptions()) {
            optionModels.add(OptionModel.of(configOptionDef));
        }
        this.configModel.setOptions(optionModels);
        LinkedList<ActionModel> actionModels = new LinkedList<ActionModel>();
        for (ConfigActionDef configActionDef : provider.getActions()) {
            actionModels.add(ActionModel.of(configActionDef));
        }
        this.configModel.setActions(actionModels);
    }

    protected void doAction() throws Exception {
        this.getLog().info((CharSequence)("Generate file to: " + this.getModelFile()));
        this.getIO().write(this.configModel, this.getModelFile().toPath());
    }
}

