/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.Vector;

public class DoubleBigMappedVector
implements Vector {
    private static Log log = LogFactory.getLog(DoubleBigMappedVector.class);
    public static final int DOUBLE_SIZE = 8;
    protected File file;
    protected int capacity;
    protected DoubleBuffer data = null;
    protected boolean readonly = false;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.file != null) {
            this.file.delete();
        }
    }

    public DoubleBigMappedVector() {
    }

    public DoubleBigMappedVector(int capacity) throws IOException {
        this.init(capacity);
    }

    @Override
    public void init(int capacity) {
        try {
            if (this.data == null) {
                this.capacity = capacity;
                this.file = File.createTempFile("matrix", ".mapped");
                this.file.deleteOnExit();
                RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
                this.data = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, capacity * 8).asDoubleBuffer();
            }
        }
        catch (IOException eee) {
            throw new MatrixException("Can't init vector", eee);
        }
    }

    public DoubleBigMappedVector(RandomAccessFile raf, long offset, int capacity) throws IOException {
        this.capacity = capacity;
        try {
            this.data = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, capacity * 8).asDoubleBuffer();
        }
        catch (Exception eee) {
            log.error((Object)"Can't use mapped file, only read available");
            this.readonly = true;
            byte[] tmp = new byte[capacity * 8];
            long currentOffset = raf.getFilePointer();
            raf.seek(offset);
            raf.readFully(tmp);
            raf.seek(currentOffset);
            ByteBuffer buf = ByteBuffer.wrap(tmp);
            this.data = buf.asDoubleBuffer();
        }
    }

    public DoubleBigMappedVector(MappedByteBuffer bytes, int capacity) {
        this(bytes.asDoubleBuffer(), capacity);
    }

    public DoubleBigMappedVector(DoubleBuffer data, int capacity) {
        this.capacity = capacity;
        this.data = data;
    }

    @Override
    public int size() {
        return this.capacity;
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        this.data.position(0);
        double[] tmp = new double[this.capacity];
        this.data.get(tmp);
        return MatrixHelper.maxOccurrence(tmp);
    }

    @Override
    public double getValue(int pos) {
        return this.data.get(pos);
    }

    @Override
    public void setValue(int pos, double value) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        this.data.put(pos, value);
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = this == o;
        if (!result) {
            if (o instanceof DoubleBigMappedVector) {
                DoubleBigMappedVector other = (DoubleBigMappedVector)o;
                other.data.position(0);
                this.data.position(0);
                result = this.data.equals(other.data);
            } else if (o instanceof Vector) {
                Vector other = (Vector)o;
                result = true;
                for (int i = 0; i < this.size() && result; ++i) {
                    result = this.getValue(i) == other.getValue(i);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof DoubleBigMappedVector;
    }

    @Override
    public boolean isImplementedAdd(Vector v) {
        return v instanceof DoubleBigMappedVector;
    }

    @Override
    public boolean isImplementedMinus(Vector v) {
        return v instanceof DoubleBigMappedVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector src) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        DoubleBigMappedVector dbmSrc = (DoubleBigMappedVector)src;
        dbmSrc.data.position(0);
        this.data.position(0);
        this.data.put(dbmSrc.data);
    }

    @Override
    public void add(Vector v) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        DoubleBigMappedVector fbv = (DoubleBigMappedVector)v;
        for (int i = 0; i < this.capacity; ++i) {
            double value = this.data.get(i);
            this.data.put(i, value += fbv.data.get(i));
        }
    }

    @Override
    public void minus(Vector v) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        DoubleBigMappedVector fbv = (DoubleBigMappedVector)v;
        for (int i = 0; i < this.capacity; ++i) {
            double value = this.data.get(i);
            this.data.put(i, value -= fbv.data.get(i));
        }
    }

    @Override
    public void map(MapFunction f) {
        if (this.readonly) {
            throw new MatrixException("This object is Read only, perhaps because your system (Windows?) doesn't support large mapped file");
        }
        for (int i = 0; i < this.capacity; ++i) {
            double v = this.data.get(i);
            v = f.apply(v);
            this.data.put(i, v);
        }
    }
}

