/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixDimensionPanel;
import org.nuiton.math.matrix.viewer.MatrixFilter;
import org.nuiton.math.matrix.viewer.MatrixRenderer;
import org.nuiton.math.matrix.viewer.MatrixRendererSolution;
import org.nuiton.util.Resource;

public class MatrixViewerPanel
extends JPanel {
    private static final long serialVersionUID = -5447856858278176837L;
    public static final String PROPERTY_MATRIX_COMBO_VISIBLE = "matrixComboVisible";
    public static final String PROPERTY_MATRIX_RENDERER_SOLUTION = "matrixRendererSolution";
    public static final String PROPERTY_MATRIX_RENDERERS = "matrixRenderers";
    public static final String PROPERTY_MATRICES = "matrices";
    protected boolean matrixComboVisible;
    protected MatrixRendererSolution matrixRendererSolution = MatrixRendererSolution.RADIO_BUTTON;
    protected List<MatrixRenderer> matrixRenderers = new ArrayList<MatrixRenderer>();
    protected List<MatrixFilter> matrixFilters = new ArrayList<MatrixFilter>();
    protected List<MatrixND> matrices = new ArrayList<MatrixND>();
    protected MatrixComboBox matrixComboBox;
    protected MatrixDimensionPanel dimensionPanel;
    protected RadioButtonRenderingPanel radioPanel;
    protected IconButtonRenderingPanel iconPanel;
    protected JPanel renderingComponentContainer;
    protected Map<MatrixRenderer, Component> componentForRenderers = new HashMap<MatrixRenderer, Component>();

    public MatrixViewerPanel() {
        this.buildPanel();
    }

    protected boolean isMatrixComboVisible() {
        return this.matrixComboVisible;
    }

    public void setMatrixComboVisible(boolean matrixComboVisible) {
        boolean oldValue = this.matrixComboVisible;
        this.matrixComboVisible = matrixComboVisible;
        this.firePropertyChange(PROPERTY_MATRIX_COMBO_VISIBLE, oldValue, matrixComboVisible);
    }

    public MatrixRendererSolution getMatrixRendererSolution() {
        return this.matrixRendererSolution;
    }

    public void setMatrixRendererSolution(MatrixRendererSolution matrixRendererSolution) {
        MatrixRendererSolution oldValue = this.matrixRendererSolution;
        this.matrixRendererSolution = matrixRendererSolution;
        this.firePropertyChange(PROPERTY_MATRIX_RENDERER_SOLUTION, (Object)oldValue, (Object)matrixRendererSolution);
    }

    public boolean addMatrixRenderer(MatrixRenderer matrixRenderer) {
        boolean result = this.matrixRenderers.add(matrixRenderer);
        this.firePropertyChange(PROPERTY_MATRIX_RENDERERS, null, this.matrixRenderers);
        return result;
    }

    public boolean removeMatrixRenderer(Object matrixRenderer) {
        boolean result = this.matrixRenderers.remove(matrixRenderer);
        this.firePropertyChange(PROPERTY_MATRIX_RENDERERS, null, this.matrixRenderers);
        return result;
    }

    public boolean addMatrixFilter(MatrixFilter matrixFilter) {
        boolean result = this.matrixFilters.add(matrixFilter);
        return result;
    }

    public boolean removeMatrixFilter(Object matrixFilter) {
        boolean result = this.matrixFilters.remove(matrixFilter);
        return result;
    }

    public void addMatrix(MatrixND ... matrices) {
        for (MatrixND matrix : matrices) {
            this.matrices.add(matrix);
        }
        this.firePropertyChange(PROPERTY_MATRICES, null, matrices);
    }

    public void removeMatrix(Object ... matrices) {
        for (Object matrix : matrices) {
            this.matrices.remove(matrix);
        }
        this.firePropertyChange(PROPERTY_MATRICES, null, matrices);
    }

    public void clearMatrix() {
        this.matrices.clear();
        this.firePropertyChange(PROPERTY_MATRICES, null, this.matrices);
    }

    protected void buildPanel() {
        this.setLayout(new BorderLayout());
        JPanel editionSidePanel = new JPanel(new BorderLayout());
        JPanel renderSidePanel = new JPanel(new BorderLayout());
        JSplitPane mainSplitPane = new JSplitPane(1, editionSidePanel, renderSidePanel);
        mainSplitPane.setDividerLocation(0.3);
        this.add((Component)mainSplitPane, "Center");
        this.matrixComboBox = new MatrixComboBox();
        MatrixComboBoxModel matrixListComboBoxModel = new MatrixComboBoxModel();
        this.matrixComboBox.setModel(matrixListComboBoxModel);
        this.matrixComboBox.setRenderer(new MatrixComboRenderer());
        this.matrixComboBox.setVisible(this.matrixComboVisible);
        this.addPropertyChangeListener(PROPERTY_MATRIX_COMBO_VISIBLE, this.matrixComboBox);
        this.addPropertyChangeListener(PROPERTY_MATRICES, matrixListComboBoxModel);
        editionSidePanel.add((Component)this.matrixComboBox, "North");
        this.dimensionPanel = new MatrixDimensionPanel();
        editionSidePanel.add((Component)this.dimensionPanel, "Center");
        this.iconPanel = new IconButtonRenderingPanel();
        editionSidePanel.add((Component)this.iconPanel, "East");
        this.addPropertyChangeListener(PROPERTY_MATRIX_RENDERER_SOLUTION, this.iconPanel);
        this.addPropertyChangeListener(PROPERTY_MATRIX_RENDERERS, this.iconPanel);
        this.renderingComponentContainer = new JPanel(new BorderLayout());
        renderSidePanel.add((Component)this.renderingComponentContainer, "Center");
        this.radioPanel = new RadioButtonRenderingPanel();
        renderSidePanel.add((Component)this.radioPanel, "South");
        this.addPropertyChangeListener(PROPERTY_MATRIX_RENDERER_SOLUTION, this.radioPanel);
        this.addPropertyChangeListener(PROPERTY_MATRIX_RENDERERS, this.radioPanel);
    }

    protected void updateSelectedRenderingComponent() {
        Component component;
        this.renderingComponentContainer.removeAll();
        MatrixRenderer matrixRenderer = null;
        switch (this.matrixRendererSolution) {
            case ICON: {
                matrixRenderer = this.iconPanel.getSelectedRender();
                break;
            }
            case RADIO_BUTTON: {
                matrixRenderer = this.radioPanel.getSelectedRender();
            }
        }
        if (matrixRenderer != null && (component = this.componentForRenderers.get(matrixRenderer)) != null) {
            this.renderingComponentContainer.add(component, "Center");
        }
        this.renderingComponentContainer.validate();
        this.renderingComponentContainer.repaint();
    }

    protected class RadioButtonRenderingPanel
    extends JPanel
    implements PropertyChangeListener,
    ActionListener {
        private static final long serialVersionUID = -6312518069621077533L;
        protected ButtonGroup buttonGroup;

        public RadioButtonRenderingPanel() {
            super(new GridBagLayout());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.rebuildPanel();
            this.validate();
            this.repaint();
        }

        protected void rebuildPanel() {
            this.removeAll();
            if (MatrixViewerPanel.this.matrixRendererSolution == MatrixRendererSolution.RADIO_BUTTON) {
                int index = 0;
                this.buttonGroup = new ButtonGroup();
                for (MatrixRenderer renderer : MatrixViewerPanel.this.matrixRenderers) {
                    JRadioButton radioButton = new JRadioButton(renderer.getName());
                    radioButton.addActionListener(this);
                    radioButton.setModel(new RendererButtonModel(renderer));
                    this.buttonGroup.add(radioButton);
                    if (index == 0) {
                        radioButton.setSelected(true);
                    }
                    this.add((Component)radioButton, new GridBagConstraints(index, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                    ++index;
                }
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }

        public MatrixRenderer getSelectedRender() {
            MatrixRenderer renderer = null;
            RendererButtonModel model = (RendererButtonModel)this.buttonGroup.getSelection();
            if (model != null) {
                renderer = model.getRenderer();
            }
            return renderer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MatrixViewerPanel.this.updateSelectedRenderingComponent();
        }
    }

    protected class IconButtonRenderingPanel
    extends JPanel
    implements PropertyChangeListener,
    ActionListener {
        private static final long serialVersionUID = 2591696695747738619L;
        protected ButtonGroup buttonGroup;

        public IconButtonRenderingPanel() {
            super(new GridBagLayout());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.rebuildPanel();
            this.validate();
            this.repaint();
        }

        protected void rebuildPanel() {
            this.removeAll();
            JButton renderButton = new JButton(Resource.getIcon((String)"/icons/1rightarrow.png"));
            renderButton.setActionCommand("render");
            renderButton.addActionListener(this);
            this.add((Component)renderButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (MatrixViewerPanel.this.matrixRendererSolution == MatrixRendererSolution.ICON) {
                int index = 1;
                this.buttonGroup = new ButtonGroup();
                for (MatrixRenderer renderer : MatrixViewerPanel.this.matrixRenderers) {
                    JToggleButton radioButton = new JToggleButton(renderer.getIcon());
                    radioButton.addActionListener(this);
                    radioButton.setModel(new RendererButtonModel(renderer));
                    if (index == 1) {
                        radioButton.setSelected(true);
                    }
                    this.buttonGroup.add(radioButton);
                    this.add((Component)radioButton, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                    ++index;
                }
            }
        }

        public MatrixRenderer getSelectedRender() {
            MatrixRenderer renderer = null;
            RendererButtonModel model = (RendererButtonModel)this.buttonGroup.getSelection();
            if (model != null) {
                renderer = model.getRenderer();
            }
            return renderer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if ("render".equals(actionCommand)) {
                MatrixND matrix = MatrixViewerPanel.this.dimensionPanel.getModifiedMatrix();
                if ((matrix = this.getFilteredMatrix(matrix)).getDimCount() > 2) {
                    JOptionPane.showMessageDialog(this, I18n._((String)"nuitonmatrix.viewer.matrix.more.2d", (Object[])new Object[0]), I18n._((String)"nuitonmatrix.error", (Object[])new Object[0]), 0);
                } else {
                    MatrixViewerPanel.this.componentForRenderers.clear();
                    for (MatrixRenderer matrixRenderer : MatrixViewerPanel.this.matrixRenderers) {
                        Component component = matrixRenderer.getComponent(matrix);
                        MatrixViewerPanel.this.componentForRenderers.put(matrixRenderer, component);
                    }
                    MatrixViewerPanel.this.updateSelectedRenderingComponent();
                }
            } else {
                MatrixViewerPanel.this.updateSelectedRenderingComponent();
            }
        }

        protected MatrixND getFilteredMatrix(MatrixND matrix) {
            MatrixND filteredMatrix = matrix;
            for (MatrixFilter matrixFilter : MatrixViewerPanel.this.matrixFilters) {
                filteredMatrix = matrixFilter.filter(filteredMatrix);
            }
            return filteredMatrix;
        }
    }

    protected static class RendererButtonModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = -5737246124430280412L;
        protected MatrixRenderer renderer;

        public RendererButtonModel(MatrixRenderer renderer) {
            this.renderer = renderer;
        }

        public MatrixRenderer getRenderer() {
            return this.renderer;
        }
    }

    protected static class MatrixComboRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 6151127818315270895L;

        protected MatrixComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MatrixND matrix = (MatrixND)value;
            String matrixName = null;
            if (matrix != null) {
                matrixName = I18n._((String)matrix.getName(), (Object[])new Object[0]);
            }
            return super.getListCellRendererComponent((JList<?>)list, matrixName, index, isSelected, cellHasFocus);
        }
    }

    protected class MatrixComboBoxModel
    extends DefaultComboBoxModel
    implements PropertyChangeListener {
        private static final long serialVersionUID = 4294576545040155208L;

        protected MatrixComboBoxModel() {
        }

        @Override
        public int getSize() {
            int result = MatrixViewerPanel.this.matrices.size();
            return result;
        }

        @Override
        public Object getElementAt(int index) {
            MatrixND matrix = MatrixViewerPanel.this.matrices.get(index);
            return matrix;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireContentsChanged(this, 0, MatrixViewerPanel.this.matrices.size() - 1);
            if (this.getSelectedItem() == null && this.getSize() > 0) {
                this.setSelectedItem(this.getElementAt(0));
            }
        }
    }

    protected class MatrixComboBox
    extends JComboBox
    implements PropertyChangeListener,
    ItemListener {
        private static final long serialVersionUID = -3166642639854195273L;

        public MatrixComboBox() {
            this.addItemListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setVisible(MatrixViewerPanel.this.matrixComboVisible);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            MatrixViewerPanel.this.dimensionPanel.setMatrix((MatrixND)this.getSelectedItem());
        }
    }
}

