/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.viewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.AbstractMatrixND;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.Resource;

public class MatrixDimensionPanel
extends JPanel {
    private static final long serialVersionUID = -1919447532660452240L;
    private static Log log = LogFactory.getLog(AbstractMatrixND.class);
    protected MatrixND matrix;
    protected List<SubDimensionPanel> subPanelList;

    public MatrixDimensionPanel() {
        this.setLayout(new GridLayout(0, 1));
        this.subPanelList = new ArrayList<SubDimensionPanel>();
    }

    public MatrixND getMatrix() {
        return this.matrix;
    }

    public void setMatrix(MatrixND matrix) {
        this.matrix = matrix;
        this.buildDimensionPanel();
        this.validate();
        this.repaint();
    }

    public MatrixND getModifiedMatrix() {
        MatrixND reducedMatrix = this.createAndReduce(this.matrix);
        return reducedMatrix;
    }

    protected void buildDimensionPanel() {
        this.subPanelList.clear();
        this.removeAll();
        if (this.matrix != null) {
            int index = 0;
            for (List semantic : this.matrix.getSemantics()) {
                SubDimensionPanel dimPanel = new SubDimensionPanel(I18n._((String)this.matrix.getDimensionName(index), (Object[])new Object[0]), semantic);
                this.add(dimPanel);
                this.subPanelList.add(dimPanel);
                ++index;
            }
        }
    }

    protected MatrixND createAndReduce(MatrixND matrix) {
        SubDimensionPanel subDimPanel;
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("matrice avant submatrice : " + matrix));
        }
        int[][] dimIndices = new int[this.subPanelList.size()][];
        for (i = 0; i < this.subPanelList.size(); ++i) {
            subDimPanel = this.subPanelList.get(i);
            JList list = subDimPanel.getList();
            int[] indList = list.getSelectedIndices();
            if (indList.length == 0) {
                list.setSelectionInterval(0, list.getModel().getSize() - 1);
                indList = list.getSelectedIndices();
            }
            if (0 >= indList.length || indList.length >= matrix.getDim(i)) continue;
            dimIndices[i] = indList;
        }
        matrix = matrix.getSubMatrix((int[][])dimIndices);
        if (log.isDebugEnabled()) {
            log.debug((Object)("matrice apres submatrice : " + matrix));
        }
        for (i = 0; i < this.subPanelList.size(); ++i) {
            subDimPanel = this.subPanelList.get(i);
            if (subDimPanel.getSumStep() != 1) {
                if ((matrix = matrix.sumOverDim(i, subDimPanel.getSumStep())).getDim(i) == 1) {
                    matrix.setDimensionName(i, I18n._((String)"nuitonmatrix.viewer.sum", (Object[])new Object[0]));
                } else {
                    String name = matrix.getDimensionName(i) + " " + I18n._((String)"nuitonmatrix.viewer.sum", (Object[])new Object[0]);
                    matrix.setDimensionName(i, name);
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("matrice apres sum de la dim " + i + ": " + matrix));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matrice avant le reduce: " + matrix));
        }
        MatrixND result = matrix.reduce(2);
        return result;
    }

    public static class SemanticListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 4384624824457446070L;
        protected List<?> semantic;

        public SemanticListModel(List<?> semantic) {
            this.semantic = semantic;
        }

        @Override
        public int getSize() {
            return this.semantic.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.semantic.get(index);
        }
    }

    protected static class SubDimensionPanel
    extends JPanel {
        private static final long serialVersionUID = 9170588695850504050L;
        protected String semanticName;
        protected List<?> semantic;
        protected JToggleButton sumAll;
        protected JList semList;

        public SubDimensionPanel(String semanticName, List<?> semantic) {
            super(new GridBagLayout());
            this.semanticName = semanticName;
            this.semantic = semantic;
            this.renderSubPanel();
        }

        protected void renderSubPanel() {
            JLabel semName = new JLabel(this.semanticName);
            this.add((Component)semName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.sumAll = new JToggleButton(Resource.getIcon((String)"/icons/sigma-barre.gif"));
            this.sumAll.setSelectedIcon(Resource.getIcon((String)"/icons/sigma.gif"));
            this.add((Component)this.sumAll, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.semList = new JList();
            SemanticListModel semModel = new SemanticListModel(this.semantic);
            this.semList.setModel(semModel);
            this.add((Component)new JScrollPane(this.semList), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        }

        public JList getList() {
            return this.semList;
        }

        public int getSumStep() {
            int result = 1;
            if (this.sumAll.isSelected()) {
                result = -1;
            }
            return result;
        }
    }
}

