/*
 * #%L
 * 
 * 
 * $Id: MatrixDimensionPanel.java 317 2010-12-16 16:45:33Z echatellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-matrix/tags/matrix-2.1/nuiton-matrix-gui/src/main/java/org/nuiton/math/matrix/viewer/MatrixDimensionPanel.java $
 * %%
 * Copyright (C) 2010 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix.viewer;

import static org.nuiton.i18n.I18n._;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.AbstractMatrixND;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.Resource;

/**
 * Panel d'affichage des dimensions.
 * 
 * @author chatellier
 * @version $Revision: 317 $
 * 
 * Last update : $Date: 2010-12-16 17:45:33 +0100 (jeu., 16 déc. 2010) $
 * By : $Author: echatellier $
 */
public class MatrixDimensionPanel extends JPanel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1919447532660452240L;

    /** Class logger. */
    private static Log log = LogFactory.getLog(AbstractMatrixND.class);

    /** Matrix to display (original). */
    protected MatrixND matrix;

    protected List<SubDimensionPanel> subPanelList;

    public MatrixDimensionPanel() {
        setLayout(new GridLayout(0, 1));
        subPanelList = new ArrayList<MatrixDimensionPanel.SubDimensionPanel>();
    }

    public MatrixND getMatrix() {
        return matrix;
    }

    public void setMatrix(MatrixND matrix) {
        this.matrix = matrix;

        buildDimensionPanel();
        validate();
        repaint();
    }
    
    public MatrixND getModifiedMatrix() {
        MatrixND reducedMatrix = createAndReduce(matrix);
        return reducedMatrix;
    }

    protected static class SubDimensionPanel extends JPanel {

        /** serialVersionUID. */
        private static final long serialVersionUID = 9170588695850504050L;

        protected String semanticName;

        protected List<?> semantic;

        protected JToggleButton sumAll;

        protected JList semList;

        public SubDimensionPanel(String semanticName, List<?> semantic) {
            super(new GridBagLayout());
            this.semanticName = semanticName;
            this.semantic = semantic;
            renderSubPanel();
        }
        
        protected void renderSubPanel() {
            // semantic name
            JLabel semName = new JLabel(semanticName);
            add(semName, new GridBagConstraints(0, 0, 1, 1, 1, 0, GridBagConstraints.CENTER,
                    GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
            
            // sum all button
            sumAll = new JToggleButton(Resource.getIcon("/icons/sigma-barre.gif"));
            sumAll.setSelectedIcon(Resource.getIcon("/icons/sigma.gif"));
            add(sumAll, new GridBagConstraints(1, 0, 1, 1, 0, 0, GridBagConstraints.WEST,
                    GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
            
            // semantic list
            semList = new JList();
            SemanticListModel semModel = new SemanticListModel(semantic);
            semList.setModel(semModel);
            add(new JScrollPane(semList), new GridBagConstraints(0, 1, 2, 1, 1, 1, GridBagConstraints.WEST,
                    GridBagConstraints.BOTH, new Insets(0, 0, 5, 0), 0, 0));
        }

        public JList getList() {
            return semList;
        }

        /**
         * Method getSumStep indique le pas d'increment pour la somme sur
         * la dimension.
         *
         * @return -1 indique de faire la somme sur tous les elmements. 1
         * indique de faire la somme 1 a 1 (donc de ne pas faire de
         * somme), 2 indiques de faire la somme 2 a 2, ...
         */
        public int getSumStep() {
            int result = 1;
            if (sumAll.isSelected()) {
                result = -1;
            }
            return result;
        }
    }

    /**
     * Build dimension panel.
     */
    protected void buildDimensionPanel() {
        subPanelList.clear();
        removeAll();
        
        if (matrix != null) {
            int index = 0;
            for (List<?> semantic : matrix.getSemantics()) {
                SubDimensionPanel dimPanel = new SubDimensionPanel(_(matrix.getDimensionName(index)), semantic);
                add(dimPanel);
                subPanelList.add(dimPanel);
                index++;
            }
        }
    }
    
    public static class SemanticListModel extends DefaultListModel {

        /** serialVersionUID. */
        private static final long serialVersionUID = 4384624824457446070L;

        protected List<?> semantic;

        public SemanticListModel(List<?> semantic) {
            this.semantic = semantic;
        }

        @Override
        public int getSize() {
            return semantic.size();
        }

        @Override
        public Object getElementAt(int index) {
            return semantic.get(index);
        }
    }

    protected MatrixND createAndReduce(MatrixND matrix) {

        if (log.isDebugEnabled()) {
            log.debug("matrice avant submatrice : " + matrix);
        }

        // la matrice doit être reduite avant tout et en une seule
        // fois pour fonctionner avec des matrices réelles ou des proxy
        int[][] dimIndices = new int[subPanelList.size()][];
        for (int i = 0; i < subPanelList.size(); i++) {
            SubDimensionPanel subDimPanel = subPanelList.get(i);
            JList list = subDimPanel.getList();
            int [] indList = list.getSelectedIndices();

            if (indList.length == 0) {
                // si rien n'est selectionné on selectionne tout
                list.setSelectionInterval(0, list.getModel().getSize()-1);
                indList = list.getSelectedIndices();
            }

            if (0 < indList.length && indList.length < matrix.getDim(i)) {
                dimIndices[i] = indList;
            }
        }

        // reduction effective de la matrice
        matrix = matrix.getSubMatrix(dimIndices);

        if (log.isDebugEnabled()) {
            log.debug("matrice apres submatrice : " + matrix);
        }

        // Effectue la somme si l'utilisateur a selectionné l'option somme
        // dans le panel
        for (int i = 0; i < subPanelList.size(); i++) {
            SubDimensionPanel subDimPanel = subPanelList.get(i);

            if (subDimPanel.getSumStep() != 1) {
                // on somme
                matrix = matrix.sumOverDim(i, subDimPanel.getSumStep());
                if (matrix.getDim(i) == 1) {
                    // c une somme global sur tous les elements
                    matrix.setDimensionName(i, _("nuitonmatrix.viewer.sum"));
                } else {
                    // c une somme partielle
                    String name = matrix.getDimensionName(i) + " " + _("nuitonmatrix.viewer.sum");

                    /* FIXME echatellier somme par autre interval que -1
                    //si c une somme pour les annees, on change l'intitule
                    if (item instanceof InfoItemDate){
                        name = _ ("isisfish.common.year");
                    }*/

                    matrix.setDimensionName(i, name);
                }

                /* FIXME echatellier somme par autre interval que -1
                // #1905 : modifie les semantiques de type Date pour que lorsque
                // c'est par exemple une somme par année
                // les semantique se nomment
                // janvier 0, janvier 1...
                // plutot que
                // janvier 0, fevrier 0...
                Object sem = matrix.getSemantics(i);
                if (sem instanceof List) {
                    List<Object> semList = (List<Object>)sem;
                    List<Object> newList = new ArrayList<Object>();
                    for (int index = 0 ; index < semList.size(); ++index) {
                        Object semObject = semList.get(index);
                        if (semObject instanceof Date) {
                            Date semDate = (Date)semObject;
                            Date newDate = new Date(semDate.getDate() * item.getSumStep());
                            newList.add(newDate);
                        }
                        else {
                            newList.add(semObject);
                        }
                    }
                    matrix.setSemantics(i, newList);
                }
                // end semantics modification */
            }

            if (log.isDebugEnabled()) {
                log.debug("matrice apres sum de la dim " + i + ": " + matrix);
            }
        }

        if (log.isDebugEnabled()) {
            log.debug("Matrice avant le reduce: " + matrix);
        }

        // arrive ici on a une matrice qui a des tailles de dimension 1
        // et un tableau des legende pour chaque dimension

        // il faut que la matrice est 2 dimensions
        // reduction de la matrice
        MatrixND result = matrix.reduce(2);

        return result;
    }
}
