/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.js.wro;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.nuiton.js.wro.NuitonJsTestManagerFactory;
import org.nuiton.js.wro.NuitonJsWroConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.DelegatingServletOutputStream;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.util.io.NullOutputStream;

public class NuitonJsLibTest {
    private static final Logger LOG = LoggerFactory.getLogger(NuitonJsLibTest.class);

    @Test
    public void testModelLoad() throws IOException {
        NuitonJsWroConfigurationFactory configFactory = new NuitonJsWroConfigurationFactory();
        WroConfiguration wroConfig = configFactory.create();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)new DelegatingServletOutputStream((OutputStream)new NullOutputStream()));
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Context.set((Context)Context.webContext((HttpServletRequest)request, (HttpServletResponse)response, (FilterConfig)filterConfig), (WroConfiguration)wroConfig);
        NuitonJsTestManagerFactory managerFactory = new NuitonJsTestManagerFactory();
        InjectorBuilder builder = new InjectorBuilder((WroManagerFactory)managerFactory);
        Injector injector = builder.build();
        WroModelFactory modelFactory = managerFactory.newModelFactory();
        injector.inject((Object)modelFactory);
        WroModel model = (WroModel)modelFactory.create();
        Assert.assertTrue((String)"Can't find any valid wro groups !", (model.getGroups().size() >= 1 ? 1 : 0) != 0);
        LOG.info("Successfully parsed {} groups", (Object)model.getGroups().size());
        GroupsProcessor groupProcessor = new GroupsProcessor();
        injector.inject((Object)groupProcessor);
        for (Group group : model.getGroups()) {
            String groupName = group.getName();
            LOG.info("Processing group {}", (Object)groupName);
            groupProcessor.process(new CacheKey(groupName, ResourceType.JS, false));
            groupProcessor.process(new CacheKey(groupName, ResourceType.CSS, false));
        }
    }
}

