/*
 * #%L
 * JRst :: Site util
 * $Id: JrstSiteModule.java 730 2012-06-29 23:56:47Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jrst/tags/jrst-2.0.1/jrst-site-util/src/main/java/org/nuiton/jrst/JrstSiteModule.java $
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jrst;

import org.apache.maven.doxia.module.site.AbstractSiteModule;
import org.apache.maven.doxia.module.site.SiteModule;
import org.codehaus.plexus.component.annotations.Component;

/**
 * The jrst site module.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.1
 */
@Component(role = SiteModule.class, hint = AbstractJrstParser.JRST_PARSER_ID,
           description = "Jrst doxia site mdule using jrst for rst.")
public class JrstSiteModule extends AbstractSiteModule {

    @Override
    public String getSourceDirectory() {
        return "rst";
    }

    @Override
    public String getExtension() {
        return "rst";
    }

    @Override
    public String getParserId() {
        return AbstractJrstParser.JRST_PARSER_ID;
    }
}
