/*
 * #%L
 * JRst :: Doxia module
 * 
 * $Id: JrstParser.java 629 2011-11-29 17:40:02Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/jrst/tags/jrst-1.5/doxia-module-jrst/src/main/java/org/nuiton/jrst/JrstParser.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.jrst;

import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;

import org.apache.maven.doxia.module.xdoc.XdocParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.dom4j.Document;
import org.nuiton.util.Resource;

/**
 * Parse an RST model, transform it into xdoc model and emit events into the
 * specified doxia Sink.
 * 
 * @author <a href="mailto:chatellier@codelutin.com">Eric Chatellier</a>
 * @version $Id: JrstParser.java 629 2011-11-29 17:40:02Z sletellier $
 * @since 0.9.0
 * @plexus.component role="org.apache.maven.doxia.parser.Parser" role-hint="jrst"
 */
public class JrstParser extends XdocParser {

    @Override
    public void parse(Reader source, Sink sink) throws ParseException {

        try {

            // Load source as RST Document
            JRSTReader jrst = new JRSTReader();
            Document doc = jrst.read(source);

            // Apply xsl on rst RST Document
            JRSTGenerator gen = new JRSTGenerator();
            String xsl = JRST.rst2xdoc;
            URL stylesheet = Resource.getURL(xsl);
            if (stylesheet == null) {
                throw new FileNotFoundException("Can't find stylesheet: "
                        + xsl);
            }

            // add entity resolver
            gen.setUriResolver(new JRSTResourceResolver(xsl));

            // do transformation
            doc = gen.transform(doc, stylesheet);

            // Give xsl result to XDoc parser
            Reader reader = new StringReader(doc.asXML());
            super.parse(reader, sink);
        } catch (Exception e) {
            throw new ParseException("Can't parse rst file", e);
        }

    }
}
