package org.nuiton.jaxx.runtime.swing.editor;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.BaseActionPanel;
import static org.nuiton.i18n.I18n.t;

public class FileEditor extends BaseActionPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACCEPT_ALL_FILE_FILTER_USED = "acceptAllFileFilterUsed";
    public static final String PROPERTY_DIRECTORY_ENABLED = "directoryEnabled";
    public static final String PROPERTY_EXTS = "exts";
    public static final String PROPERTY_EXTS_DESCRIPTION = "extsDescription";
    public static final String PROPERTY_FILE_ENABLED = "fileEnabled";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_START_PATH = "startPath";
    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BOUTON_XSL_LOCATION_ENABLED = "boutonXslLocation.enabled";
    public static final String BINDING_PATH_FIELD_ENABLED = "pathField.enabled";
    public static final String BINDING_PATH_FIELD_TEXT = "pathField.text";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_TOOLBAR_VISIBLE = "toolbar.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUzU4UQRDHe1eWdfkGDXpEASFBZ+Wg0UCU7yBZhQAmRC72zjRsk2a67a6B4cLBgzdfwINXL4Z3IJ5MvHjlHUx4BKtnBgbI7rIACbub6upf/+vfXfXzH8kZTR5Lven4AQfpO1s0DB0d+MC3mbMwuba2WN5iLsww42quQGoS/2WyJLtOWr3TuAHirJeQVIxJRUsqJqTitNxW0mf+GdBYibQY2BPMVBgDIMM1N7vGFFdOM8dCFejkrKqqq53158voUYbNfMsSEiqU34Flj1wBkFbdVCJZ7gHpKW3RHVoU1N9EcZr7m1hQu41NC2rMO7rNPpF9ki+RZkU1woA8uZY9ES5ChQpI98AUNWzSBS79Jeoz8RRIsVYhZhdlOczDFe3MccFmo59KRbxmIPkK9T3BNJDnV2TMxxtT1D3qukzBpBA2Cf+B6feGoVPd1hTHGuVMSSkY9dNdXR7X+Lyk3pv1aVkwz8a70/XWDXti1aWCAaphiUIFMekR8V2kaTngIKKruJ8Gm1gI5kKs08ZO/Ed3LywXTEXuLjPD4IKOPGBRZZRC7loVYeLYwiqGp6i2WYW0Hm0JUwGgz0DunNsQR23ig/RUhfXNcSbQx97zeJQbLZw/oLssA6SsGVGSLj2p41GSpMmjWveMTeakTZa+98w6yekAw0D6a/e3bdFlzIqbs792c9pjosTPB/v6x+7x0UlHtqO4vst2nRk+2B5KS4Vvl1ttnXE7BsBF8S1VY+t4YUxETwtXh+orX0kyUT2qiN+rJTnz1FSQlssfHf7q/fj3FsnOkRYhqTdHbf4bUoAK3mhFCi9UrycicW27t/Gzy8oE0izoHl4IkI5xjwLtK3Pfw+t7FaJLQ/VdOhV1sHj8+/vXwcMTpzKocaCRnalbuQ+kmfuC+yyaXslgqjqtWpVhgSfTqVNtDmXsd4tKmmA0+nxWrf72stQe00uU+2BnQc94LKOPAvZpOQCGVtjdL6PC7K+xCP6wAXhhA68C7GywKRPXB+V3uOEJ5sX1MU3cjdutBmOwESksHXY3wLRtSDcwie113GmEVYhYl9jcCKjVTspVruzouhHKhlfrODTcyGVBouLaDBterEMYuXEdlvAf6mOm5aQJAAA=";
    private static final Log log = LogFactory.getLog(FileEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean acceptAllFileFilterUsed;
    protected JButton boutonXslLocation;
    protected Boolean directoryEnabled;
    protected String exts;
    protected String extsDescription;
    protected Boolean fileEnabled;
    protected FileEditorHandler handler;
    protected JTextField pathField;
    protected JButton resetButton;
    protected Boolean showReset;
    protected String startPath;
    protected String title;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FileEditor $BaseActionPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected File selectedFile;
    
    
    public void setSelectedFile(File selectedFile) {
        this.selectedFile = selectedFile;
        setStartPath(selectedFile == null ? null : selectedFile.getAbsolutePath());
        fireActionEvent();
    }
    
    public void setSelectedFilePath(String startPath) {
        setSelectedFile(startPath == null ? null : new File(startPath));
    }
    
    /**public void setSelectedFile(String startPath) {
        this.selectedFile = null;
        setStartPath(startPath);
        fireActionEvent();
    }*/
    
    public File getSelectedFile() {
        if (selectedFile == null) {
            if (StringUtils.isNotEmpty(startPath)) {
                selectedFile = new File(startPath);
            }
        }
        return selectedFile;
    }
    
    public void setDialogOwner(JDialog dialogOwner) {
      handler.setDialogOwner(dialogOwner);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FileEditor() {
        $initialize();
    }

    public FileEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__boutonXslLocation(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openLocation();
    }

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedFile(null);
    }

    public void doKeyReleased__on__pathField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedFilePath(pathField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAcceptAllFileFilterUsed() {
        return acceptAllFileFilterUsed;
    }

    public JButton getBoutonXslLocation() {
        return boutonXslLocation;
    }

    public Boolean getDirectoryEnabled() {
        return directoryEnabled;
    }

    public String getExts() {
        return exts;
    }

    public String getExtsDescription() {
        return extsDescription;
    }

    public Boolean getFileEnabled() {
        return fileEnabled;
    }

    public FileEditorHandler getHandler() {
        return handler;
    }

    public JTextField getPathField() {
        return pathField;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public String getStartPath() {
        return startPath;
    }

    public String getTitle() {
        return title;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean isAcceptAllFileFilterUsed() {
        return acceptAllFileFilterUsed !=null && acceptAllFileFilterUsed;
    }

    public Boolean isDirectoryEnabled() {
        return directoryEnabled !=null && directoryEnabled;
    }

    public Boolean isFileEnabled() {
        return fileEnabled !=null && fileEnabled;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAcceptAllFileFilterUsed(Boolean acceptAllFileFilterUsed) {
        Boolean oldValue = this.acceptAllFileFilterUsed;
        this.acceptAllFileFilterUsed = acceptAllFileFilterUsed;
        firePropertyChange(PROPERTY_ACCEPT_ALL_FILE_FILTER_USED, oldValue, acceptAllFileFilterUsed);
    }

    public void setDirectoryEnabled(Boolean directoryEnabled) {
        Boolean oldValue = this.directoryEnabled;
        this.directoryEnabled = directoryEnabled;
        firePropertyChange(PROPERTY_DIRECTORY_ENABLED, oldValue, directoryEnabled);
    }

    public void setExts(String exts) {
        String oldValue = this.exts;
        this.exts = exts;
        firePropertyChange(PROPERTY_EXTS, oldValue, exts);
    }

    public void setExtsDescription(String extsDescription) {
        String oldValue = this.extsDescription;
        this.extsDescription = extsDescription;
        firePropertyChange(PROPERTY_EXTS_DESCRIPTION, oldValue, extsDescription);
    }

    public void setFileEnabled(Boolean fileEnabled) {
        Boolean oldValue = this.fileEnabled;
        this.fileEnabled = fileEnabled;
        firePropertyChange(PROPERTY_FILE_ENABLED, oldValue, fileEnabled);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setStartPath(String startPath) {
        String oldValue = this.startPath;
        this.startPath = startPath;
        firePropertyChange(PROPERTY_START_PATH, oldValue, startPath);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        toolbar.add(resetButton);
    }

    protected void createAcceptAllFileFilterUsed() {
        $objectMap.put("acceptAllFileFilterUsed", acceptAllFileFilterUsed = Boolean.TRUE);
    }

    protected void createBoutonXslLocation() {
        $objectMap.put("boutonXslLocation", boutonXslLocation = new JButton());
        
        boutonXslLocation.setName("boutonXslLocation");
        boutonXslLocation.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__boutonXslLocation"));
    }

    protected void createDirectoryEnabled() {
        $objectMap.put("directoryEnabled", directoryEnabled = Boolean.TRUE);
    }

    protected void createExts() {
        $objectMap.put("exts", exts = null);
    }

    protected void createExtsDescription() {
        $objectMap.put("extsDescription", extsDescription = null);
    }

    protected void createFileEnabled() {
        $objectMap.put("fileEnabled", fileEnabled = Boolean.TRUE);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FileEditorHandler(this));
    }

    protected void createPathField() {
        $objectMap.put("pathField", pathField = new JTextField());
        
        pathField.setName("pathField");
        pathField.setColumns(15);
        pathField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__pathField"));
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusPainted(false);
        resetButton.setFocusable(false);
        resetButton.setToolTipText(t("fileeditor.action.reset.tip"));
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createStartPath() {
        $objectMap.put("startPath", startPath = null);
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setBorderPainted(false);
        toolbar.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $BaseActionPanel0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$BaseActionPanel0", $BaseActionPanel0);
        createHandler();
        createAcceptAllFileFilterUsed();
        createDirectoryEnabled();
        createFileEnabled();
        createStartPath();
        createTitle();
        createExts();
        createExtsDescription();
        createShowReset();
        createToolbar();
        createResetButton();
        createPathField();
        createBoutonXslLocation();
        // inline creation of $BaseActionPanel0
        setName("$BaseActionPanel0");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbar.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PATH_FIELD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                pathField.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PATH_FIELD_TEXT, true ,"startPath") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(pathField, getStartPath());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BOUTON_XSL_LOCATION_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                boutonXslLocation.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $BaseActionPanel0
        add(toolbar, BorderLayout.WEST);
        add(pathField, BorderLayout.CENTER);
        add(boutonXslLocation, BorderLayout.EAST);
        addChildrenToToolbar();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 property setters
        resetButton.setIcon(SwingUtil.createActionIcon("fileeditor-reset"));
        boutonXslLocation.setIcon(SwingUtil.createActionIcon("open"));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}