package org.nuiton.jaxx.runtime.swing;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import static org.nuiton.i18n.I18n.t;

public class ComboToListSelector<B> extends ListSelector<B> {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENABLED = "add.enabled";
    public static final String BINDING_ADD_TOOL_TIP_TEXT = "add.toolTipText";
    public static final String BINDING_FROM_MODEL = "from.model";
    public static final String BINDING_FROM_RENDERER = "from.renderer";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_REMOVE_TOOL_TIP_TEXT = "remove.toolTipText";
    public static final String BINDING_TO_CELL_RENDERER = "to.cellRenderer";
    public static final String BINDING_TO_MODEL = "to.model";
    public static final String BINDING_TO_SELECTION_MODEL = "to.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVTU8TQRjHnxb6xpsICtGDIeFNA+zK0UBQgRAkRQz0QOzFaXeAJdOdcfZZWD1w8ODNL+DBqxfDdyCeTLx45TuY8BF8Zlv6krSl0h52m5lnfvN/nvk/sz/+QsLXMC/1oeUFLkrPOmZhaOnAQ7fEra2X+/s7hWNexHXuF7WrUGoo/2JxiOeh36mO+whWPksku0yyDcmukOw1WVLS414daCkLfT5+ENw/4hwRHrdcXPR9e68auRSqQFf2aqq62V6/Py9exvj61zhAqEh+mtKe+w9ALeveLMRdB2Eke8xOmC2Yd0jitOsdUkKDZmxNMN9/zUr8PZxBKgtJxTTBEBZuVZ4IF6FChTA0lXV93OOCDkXqpwiLrbLwT0mTyaUgc7J+kVIRLomQKEmHCwS7PaN+8bZZUSP0HmhZQrhv8g4r4VvRnqsyNDGZamiKFdGVHvnkXkN0TkqxynRjcA9zqMajDYGrAZJAEzBSjUtqXpInUaXHG2fSglS/YR5HGG/A7BW1FMLMNG4ZR4lwtyHUJG5mHyqyy0yrIpE9rZo9a06J5SGhAxpGmGzdGcbcuxRVtvVka1ubbaLAT+dn+vvp1eW1lwdJ3MRNq+raloyltFRco2u03SkbOUBX2NtMLeUh41cOm2Zn2yu/tgWpJxVR9SxDsjaZf0S0ROry4ufYuz89EN+APiGZs8FM/CvI4JGmiknhhOr5i0jcwGmansNGZs2bQ8sOQzZRcD2HzmQlpCLNti9SVdP5ztWvb1+mL64LFSOJU52srBUr8RaSridcj0dtX+nopm3er3weOLLWrs0aOGbew6rSQNPR80mz9NN0ZThc86gv5sPAvBaiHMw/u2NO5oCKjqwgyJkjy+VUJhjShVUIkK80B492AO51i+VmbCFurANGintGmdMlph/pCsm5KsdD7AplhlfaEB50RFjrmrDZFQFhoMiF2L3ZQI86MpD0cMF3P0Y+f3ZbkBme61LKUPleoo9I9BW6gfYPYVbfWd0IAAA=";
    private static final Log log = LogFactory.getLog(ComboToListSelector.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actions;
    protected JButton add;
    protected JComboBox from;
    protected JScrollPane listPane;
    protected JButton remove;
    protected JList to;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ComboToListSelector<B> $ListSelector0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
        addPropertyChangeListener(PROPERTY_MODEL, new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
    
                Set<String> bindings = $bindings.keySet();
                JAXXUtil.applyDataBinding(ComboToListSelector.this, bindings);
                JAXXUtil.processDataBinding(
                        ComboToListSelector.this, bindings.toArray(new String[bindings.size()]));
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ComboToListSelector() {
        $initialize();
    }

    public ComboToListSelector(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.add();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.remove();
    }

    public void doMouseClicked__on__to(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getClickCount()==2) { model.remove(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActions() {
        return actions;
    }

    public JButton getAdd() {
        return add;
    }

    public JComboBox getFrom() {
        return from;
    }

    public JScrollPane getListPane() {
        return listPane;
    }

    public JButton getRemove() {
        return remove;
    }

    public JList getTo() {
        return to;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActions() {
        actions.add(add);
        actions.add(remove);
    }

    protected void addChildrenToListPane() {
        listPane.getViewport().add(to);
    }

    protected void createActions() {
        $objectMap.put("actions", actions = new JToolBar());
        
        actions.setName("actions");
        actions.setFloatable(false);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createFrom() {
        $objectMap.put("from", from = new JComboBox());
        
        from.setName("from");
    }

    protected void createListPane() {
        $objectMap.put("listPane", listPane = new JScrollPane());
        
        listPane.setName("listPane");
    }

    @Override
    protected void createModel() {
        $objectMap.put("model", model = new ListSelectorModel());
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createTo() {
        $objectMap.put("to", to = new JList());
        
        to.setName("to");
        if (to.getFont() != null) {
            to.setFont(to.getFont().deriveFont((float) 11));
        }
        to.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__to"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $ListSelector0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$ListSelector0", $ListSelector0);
        createFrom();
        createActions();
        createAdd();
        createRemove();
        createListPane();
        createTo();
        // inline creation of $ListSelector0
        setName("$ListSelector0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fromModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    from.setModel(getModel().getFromModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fromModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FROM_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                from.setRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("addEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    add.setEnabled(getModel().isAddEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("addEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_TOOL_TIP_TEXT, true ,"addToolTip") {
        
            @Override
            public void processDataBinding() {
                add.setToolTipText(t(getAddToolTip()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    remove.setEnabled(getModel().isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TOOL_TIP_TEXT, true ,"removeToolTip") {
        
            @Override
            public void processDataBinding() {
                remove.setToolTipText(t(getRemoveToolTip()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TO_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                to.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setSelectionModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $ListSelector0
        add(from, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(actions, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(listPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToActions();
        addChildrenToListPane();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 2 property setters
        add.setIcon(SwingUtil.createActionIcon("add"));
        remove.setIcon(SwingUtil.createActionIcon("remove"));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}