/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ListToListSelector<B> extends ListSelector<B> {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENABLED = "add.enabled";
    public static final String BINDING_ADD_TOOL_TIP_TEXT = "add.toolTipText";
    public static final String BINDING_FROM_CELL_RENDERER = "from.cellRenderer";
    public static final String BINDING_FROM_MODEL = "from.model";
    public static final String BINDING_FROM_SELECTION_MODEL = "from.selectionModel";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_REMOVE_TOOL_TIP_TEXT = "remove.toolTipText";
    public static final String BINDING_TO_CELL_RENDERER = "to.cellRenderer";
    public static final String BINDING_TO_MODEL = "to.model";
    public static final String BINDING_TO_SELECTION_MODEL = "to.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2UTU8TQRjHny60tRQrUEUImIBC1Ji0HrxBEIEQIQUT6IHYi9PuAEu2O+PMs7BejB/Bj6B3LybePBkPnj14MX4FYzx4NT6zfWN1KU1qD9vNzP/5zf95mX3zHZJawewRC4KC8j106ryw+WBv71H1iNdwjeuaciQKBY1fwgKrAlm7va4RblRKJrzYDC+uiroUHvdORS+UYEjjM5frQ84R4Vo0oqZ1cbe9vRBIX7WobVNx1Fc/f1gv7RevLYBAkrs0pTJzXlQnk8ESWI6NMEYnHbOiy7wDsqEc74D8XjRrqy7TepvV+VN4DukSpCRTBEO43nvKISOMDyRCbq7kaNzlLlVXqLsI8xG/+oROLxhJWZwWShkiUgjJurC5izB3RlwrYsvIOmGD+0rUEUZNVkFTvmn0Zj/TlqVZDR3hUVcvR5RlIdwVpqLiAWZT9fIR4YqPKDwjGGvrUorXxXFYw6vRHQuFeRttchVMRbKiuSh05qLTuEQFksqnZYSJyr+jtENbjSGa+GuIDDDc/T2e//L+27v11uTk6OwrsdJTg08dlUpIrtAxR19qjI2PjlvcYnKhAhndLD7tTscYa/WGzNF5YS8KJrzwkOlDQiTTXz98HH/yeQCsdRhyBbPXmdFvQAYPFVVBuHYg7y+HjoZPLtBzxHhDGK5x193hns0V2YPcos2QzVQdz6auLAVUiumYUrT9VDOffuV33y63ypEge5NnyjslST6GlOO5jsfDq9S8JbFXJys1923RuQ1x9yNh/kdkc2xnw+d8XL6NW2C2bwW++bsdujZvd3qG5Brtonnf+g+0zD41DFnVpUkdW2xUZYYhfU+qPvKleHC+B3BWKIc+LcwY7eKxF9SgU+vKGO+BkeaeSdLuE5NF+qSUHVnmAfaFMstrXQiTPRE2+iZs90242YUw1ROh2Dfh3jmEP5gbF2IxCAAA";
    private static final Log log = LogFactory.getLog(ListToListSelector.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actions;
    protected JButton add;
    protected JList from;
    protected JButton remove;
    protected JList to;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListToListSelector<B> $ListSelector0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
        addPropertyChangeListener(PROPERTY_MODEL, new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
    
                Set<String> bindings = $bindings.keySet();
                JAXXUtil.applyDataBinding(ListToListSelector.this, bindings);
                JAXXUtil.processDataBinding(
                        ListToListSelector.this, bindings.toArray(new String[bindings.size()]));
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListToListSelector() {
        $initialize();
    }

    public ListToListSelector(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.add();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.remove();
    }

    public void doMouseClicked__on__from(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getClickCount()==2) { model.add(); }
    }

    public void doMouseClicked__on__to(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getClickCount()==2) { model.remove(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActions() {
        return actions;
    }

    public JButton getAdd() {
        return add;
    }

    public JList getFrom() {
        return from;
    }

    public JButton getRemove() {
        return remove;
    }

    public JList getTo() {
        return to;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActions() {
        if (!allComponentsCreated) {
            return;
        }
        actions.add(add);
        actions.add(remove);
    }

    protected void createActions() {
        $objectMap.put("actions", actions = new JToolBar());
        
        actions.setName("actions");
        actions.setFloatable(false);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createFrom() {
        $objectMap.put("from", from = new JList());
        
        from.setName("from");
        from.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__from"));
    }

    @Override
    protected void createModel() {
        $objectMap.put("model", model = new ListSelectorModel());
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createTo() {
        $objectMap.put("to", to = new JList());
        
        to.setName("to");
        to.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__to"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $ListSelector0
        add(from, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(actions, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(to, new GridBagConstraints(2, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToActions();
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        actions.setOrientation(SwingConstants.VERTICAL);
        add.setIcon(SwingUtil.createActionIcon("select"));
        remove.setIcon(SwingUtil.createActionIcon("unselect"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$ListSelector0", $ListSelector0);
        createFrom();
        createActions();
        createAdd();
        createRemove();
        createTo();
        // inline creation of $ListSelector0
        setName("$ListSelector0");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FROM_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                from.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fromModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    from.setModel(getModel().getFromModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fromModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fromModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    from.setSelectionModel(getModel().getFromModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fromModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("addEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    add.setEnabled(getModel().isAddEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("addEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_TOOL_TIP_TEXT, true ,"addToolTip") {
        
            @Override
            public void processDataBinding() {
                add.setToolTipText(_(getAddToolTip()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    remove.setEnabled(getModel().isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_TOOL_TIP_TEXT, true ,"removeToolTip") {
        
            @Override
            public void processDataBinding() {
                remove.setToolTipText(_(getRemoveToolTip()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TO_CELL_RENDERER, true ,"renderer") {
        
            @Override
            public void processDataBinding() {
                to.setCellRenderer(getRenderer());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    to.setSelectionModel(getModel().getToModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toModel", this);
                }
            }
        });
    }

}