package jaxx.runtime.swing.editor;
/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class NumberEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_POPUP = "autoPopup";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_MODEL_TEXT = "modelText";
    public static final String PROPERTY_MODEL_TYPE = "modelType";
    public static final String PROPERTY_NUMBER_PATTERN = "numberPattern";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_SELECT_ALL_TEXT_ON_ERROR = "selectAllTextOnError";
    public static final String PROPERTY_SHOW_POPUP_BUTTON = "showPopupButton";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_USE_FLOAT = "useFloat";
    public static final String PROPERTY_USE_SIGN = "useSign";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DOT_ENABLED = "dot.enabled";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_SHOW_POP_UP_BUTTON_ENABLED = "showPopUpButton.enabled";
    public static final String BINDING_TEXT_FIELD_ENABLED = "textField.enabled";
    public static final String BINDING_TEXT_FIELD_TEXT = "textField.text";
    public static final String BINDING_TOGGLE_SIGN_ENABLED = "toggleSign.enabled";
    public static final String BINDING_TOOLBAR_VISIBLE = "toolbar.visible";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON12_ENABLED = "$JButton12.enabled";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON7_ENABLED = "$JButton7.enabled";
    private static final String BINDING_$JTOOL_BAR0_VISIBLE = "$JToolBar0.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVYzW8bRRQfO7Gdz6aQEqXQSqGtyqmO06SFKFE/UhKFkKahCVAIEsx6J/a0653t7Gyy4YBA/AP8CXDnUsSNE0LAGSEuiH8BVT1wRbyZXXu9/lhPmUhZ2TO/95vfe/PmvVl/+zcq+By9+hCHYZkHrqANUt66/eDBPeshqYo3iV/l1BOMo+gvl0f5AzRut8Z9gS4ebEvz+dh8/g5reMwlbpv1yjYa88WJQ/w6IUKg82mLqu/P77WmV0Iv4E3WlqherF8/e5r/yv78mzxCoQfqLoMrc4OsEk+Gt1Ge2gK9CCsd4XkHuzWQwalbA72TcuyOg31/BzfIY/QZKm2jooc5kAl0Qd9lxaHsQ0+gkUtbu9glTkWgyyml/jGsWyY2BdvyTtCwCF9XXzxPWRfB1uPMI1ycCHRaqitLxeVIcYIatgh2U4hoLxNEocFs4qQg0YIJZFRB9k88ItBUAlO+tAkKfLLhMAwBeSEBrTHmgIQEVgLYHq258uvLbWvgQLBd5gVex8SUX2fHamItEIJ12cnp+8QnomNi0lVe7IIewpXVqS6PSCg6JiY8udJ71KeWQzoYz/jEgdDddpThPXedc8Y7MKU6dm0HtgVd0dvQzQjfth9KgUAzMoZhbLilAnCXuEFbvOPkWYCcTWPlqASVE38vbUXRg0ybToGToAJPwaY1KrqMFuTA9WzMVQ3MYgpThbzgXZglDZ5rGpjrGpjXNfS8ocGz3B8z1ophRQfUFmmvezYjxmOC1WpO62A1QSOyRGBZmWPckM1EJiBZbbGHlpKA42xhSO8zqSzah+E1rA7DaAs8zuWxTBJMcVWTnBRwijYocezOZN9vTqT5QFq8joolSc8268S7cZ0Q6GyHRBmgRM0jD/rDK6lDCp2nnHSepDXkDlCBBzAs0OxBd7O6D1NRm5rtaFOSUM3+OzP9xw9/fb/R7E2LsPZLPaFtrRV6RlzjqVx6KmpMgaDO/F3srRxA7VMFSfXdcz2E7cXTIA7Wi4qyNC9vYr8OFIXSnz/+NPPJb0Mov4HGoHTbG1ji34K9qcPm1Zljh97NW0rRxPEIPE/D/xDs3SGrBj6GGgmJeIgd2Gc0ocZ2MXUFsZNhgLriik8/hc/5haUQwnSuR5haWq3RX/+Z3ntyqxmqHEg/2xeehKvwISpS16EuUY087tE9G/e455PAZkkv7tWdEdTgUnwW4qIbqOdJV0BykJuHjJMaZ4Fry6brBCQMJPgL5YH89GWKMHV+dXlLFyuV5eVKZRB1+lDrsg9xYg8UnRTJDNpxteXHhNbqQkZDplEWserHcC1gR9AIn4+86DLewI42/XMEp+jgEwYE6NSqjQWes6hrQyW50bVWTj7HPI0ksXD1URRuifmuN9NVDaaixbhNuBGLHH5iqGNY1nC4f6xGJ28OLlucWoEgfaJ0TUvVz/LxS2+GZWOGVQ2/SsSVxS1rm24aCzFnWDNmWDdm2NRi+D0jkm8bazBn2DFmeMeYYV8/kn0Y3jfeiw+MvdBjyNLwkbEGPYYsDR8baxjMAOWTVqPLaB8VlgbHZNQK4ntXhiBbg2z0UL7A4/jd14CodJS8QvdxbjANDOdmMxhqxts8mKHjXpsRFh2u5N5sSDQuX8T2qdf8CeN/Uw2KENU/CCYMufMZXjhaDBeMGCCkDRzSRtDYg1eVDHd0qIrMw4+DrD3Wc+k1Ix2Djo9rnBxaDLmljDjoMSwbM9wYwPAf5eYVYfsWAAA=";
    private static final Log log = LogFactory.getLog(NumberEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean autoPopup;
    protected Object bean;
    protected JButton dot;
    protected NumberEditorHandler handler;
    protected Number model;
    protected String modelText;
    protected Class<?> modelType;
    protected String numberPattern;
    protected JPopupMenu popup;
    protected Boolean popupVisible;
    protected String property;
    protected JButton resetButton;
    protected Boolean selectAllTextOnError;
    protected JToggleButton showPopUpButton;
    protected Boolean showPopupButton;
    protected Boolean showReset;
    protected JTextField textField;
    protected JButton toggleSign;
    protected JToolBar toolbar;
    protected Boolean useFloat;
    protected Boolean useSign;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton10;
    private JButton $JButton11;
    private JButton $JButton12;
    private JButton $JButton13;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JButton $JButton5;
    private JButton $JButton6;
    private JButton $JButton7;
    private JButton $JButton8;
    private JButton $JButton9;
    private NumberEditor $JPanel0 = this;
    private JPanel $JPanel1;
    private JToolBar $JToolBar0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        handler.init();
    }
    
    public NumberEditor getEditor() {
        return this;
    }
    
    public void addChar(ActionEvent event) {
        getHandler().addChar(((JButton)event.getSource()).getText());
    }
    
    void showPopup() {
       if ( popupVisible || autoPopup ) {
           if (!popupVisible) {
               setPopupVisible(true);
           } else if (!getPopup().isVisible()) {
               getHandler().setPopupVisible(true);
           }
       }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor() {
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__$JButton10(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__$JButton12(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__$JButton13(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validate();
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setModel(null);
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__$JButton5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__$JButton6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__$JButton7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeChar();
    }

    public void doActionPerformed__on__$JButton8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__$JButton9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__dot(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addChar(event);
    }

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setModel(null);
    }

    public void doActionPerformed__on__showPopUpButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().setPopupVisible(!popup.isVisible());
    }

    public void doActionPerformed__on__toggleSign(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().toggleSign();
    }

    public void doFocusGained__on__$JPanel0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        textField.requestFocus();
    }

    public void doFocusGained__on__textField(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopup();
    }

    public void doFocusLost__on__$JPanel0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doKeyReleased__on__textField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().setModel(textField.getText());
    }

    public void doMouseEntered__on__$JButton0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton0, "font-weight", "bold", Pseudoclasses.wrap(($JButton0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton0.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton1(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton1, "font-weight", "bold", Pseudoclasses.wrap(($JButton1.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton1.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton10(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton10, "font-weight", "bold", Pseudoclasses.wrap(($JButton10.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton10.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton11(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton11, "font-weight", "bold", Pseudoclasses.wrap(($JButton11.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton11.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton12(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton12, "font-weight", "bold", Pseudoclasses.wrap(($JButton12.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton12.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton13(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton13, "font-weight", "bold", Pseudoclasses.wrap(($JButton13.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton13.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton2(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton2, "font-weight", "bold", Pseudoclasses.wrap(($JButton2.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton2.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton3(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton3, "font-weight", "bold", Pseudoclasses.wrap(($JButton3.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton3.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton4(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton4, "font-weight", "bold", Pseudoclasses.wrap(($JButton4.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton4.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton5(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton5, "font-weight", "bold", Pseudoclasses.wrap(($JButton5.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton5.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton6(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton6, "font-weight", "bold", Pseudoclasses.wrap(($JButton6.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton6.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton7(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton7, "font-weight", "bold", Pseudoclasses.wrap(($JButton7.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton7.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton8(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton8, "font-weight", "bold", Pseudoclasses.wrap(($JButton8.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton8.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton9(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, $JButton9, "font-weight", "bold", Pseudoclasses.wrap(($JButton9.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton9.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__dot(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, dot, "font-weight", "normal", Pseudoclasses.wrap((dot.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (dot.getFont() != null) {
            if (((String) value).equals("bold")) {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() | Font.BOLD));
            } else {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__resetButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, resetButton, "font-weight", "bold", Pseudoclasses.wrap((resetButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (resetButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() | Font.BOLD));
            } else {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__toggleSign(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor.this, toggleSign, "font-weight", "normal", Pseudoclasses.wrap((toggleSign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (toggleSign.getFont() != null) {
            if (((String) value).equals("bold")) {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() | Font.BOLD));
            } else {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton0, "font-weight", "bold", Pseudoclasses.wrap(($JButton0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton0.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton1(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton1, "font-weight", "bold", Pseudoclasses.wrap(($JButton1.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton1.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton10(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton10, "font-weight", "bold", Pseudoclasses.wrap(($JButton10.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton10.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton11(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton11, "font-weight", "bold", Pseudoclasses.wrap(($JButton11.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton11.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton12(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton12, "font-weight", "bold", Pseudoclasses.wrap(($JButton12.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton12.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton13(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton13, "font-weight", "bold", Pseudoclasses.wrap(($JButton13.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton13.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton2(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton2, "font-weight", "bold", Pseudoclasses.wrap(($JButton2.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton2.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton3(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton3, "font-weight", "bold", Pseudoclasses.wrap(($JButton3.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton3.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton4(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton4, "font-weight", "bold", Pseudoclasses.wrap(($JButton4.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton4.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton5(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton5, "font-weight", "bold", Pseudoclasses.wrap(($JButton5.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton5.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton6(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton6, "font-weight", "bold", Pseudoclasses.wrap(($JButton6.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton6.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton7(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton7, "font-weight", "bold", Pseudoclasses.wrap(($JButton7.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton7.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton8(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton8, "font-weight", "bold", Pseudoclasses.wrap(($JButton8.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton8.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton9(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, $JButton9, "font-weight", "bold", Pseudoclasses.wrap(($JButton9.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton9.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JPanel0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doMouseExited__on__dot(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, dot, "font-weight", "normal", Pseudoclasses.wrap((dot.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (dot.getFont() != null) {
            if (((String) value).equals("bold")) {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() | Font.BOLD));
            } else {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__resetButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, resetButton, "font-weight", "bold", Pseudoclasses.wrap((resetButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (resetButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() | Font.BOLD));
            } else {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__toggleSign(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor.this, toggleSign, "font-weight", "normal", Pseudoclasses.wrap((toggleSign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (toggleSign.getFont() != null) {
            if (((String) value).equals("bold")) {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() | Font.BOLD));
            } else {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(false);
    }

    public void doPopupMenuWillBecomeVisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAutoPopup() {
        return autoPopup;
    }

    public Object getBean() {
        return bean;
    }

    public JButton getDot() {
        return dot;
    }

    public NumberEditorHandler getHandler() {
        return handler;
    }

    public Number getModel() {
        return model;
    }

    public String getModelText() {
        return modelText;
    }

    public Class<?> getModelType() {
        return modelType;
    }

    public String getNumberPattern() {
        return numberPattern;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public Boolean getPopupVisible() {
        return popupVisible;
    }

    public String getProperty() {
        return property;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public Boolean getSelectAllTextOnError() {
        return selectAllTextOnError;
    }

    public JToggleButton getShowPopUpButton() {
        return showPopUpButton;
    }

    public Boolean getShowPopupButton() {
        return showPopupButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JTextField getTextField() {
        return textField;
    }

    public JButton getToggleSign() {
        return toggleSign;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean getUseFloat() {
        return useFloat;
    }

    public Boolean getUseSign() {
        return useSign;
    }

    public Boolean isAutoPopup() {
        return autoPopup !=null && autoPopup;
    }

    public Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    public Boolean isSelectAllTextOnError() {
        return selectAllTextOnError !=null && selectAllTextOnError;
    }

    public Boolean isShowPopupButton() {
        return showPopupButton !=null && showPopupButton;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public Boolean isUseFloat() {
        return useFloat !=null && useFloat;
    }

    public Boolean isUseSign() {
        return useSign !=null && useSign;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoPopup(Boolean autoPopup) {
        Boolean oldValue = this.autoPopup;
        this.autoPopup = autoPopup;
        firePropertyChange(PROPERTY_AUTO_POPUP, oldValue, autoPopup);
    }

    public void setBean(Object bean) {
        Object oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setModel(Number model) {
        Number oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    public void setModelText(String modelText) {
        String oldValue = this.modelText;
        this.modelText = modelText;
        firePropertyChange(PROPERTY_MODEL_TEXT, oldValue, modelText);
    }

    public void setModelType(Class<?> modelType) {
        Class<?> oldValue = this.modelType;
        this.modelType = modelType;
        firePropertyChange(PROPERTY_MODEL_TYPE, oldValue, modelType);
    }

    public void setNumberPattern(String numberPattern) {
        String oldValue = this.numberPattern;
        this.numberPattern = numberPattern;
        firePropertyChange(PROPERTY_NUMBER_PATTERN, oldValue, numberPattern);
    }

    public void setPopupVisible(Boolean popupVisible) {
        Boolean oldValue = this.popupVisible;
        this.popupVisible = popupVisible;
        firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, popupVisible);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setSelectAllTextOnError(Boolean selectAllTextOnError) {
        Boolean oldValue = this.selectAllTextOnError;
        this.selectAllTextOnError = selectAllTextOnError;
        firePropertyChange(PROPERTY_SELECT_ALL_TEXT_ON_ERROR, oldValue, selectAllTextOnError);
    }

    public void setShowPopupButton(Boolean showPopupButton) {
        Boolean oldValue = this.showPopupButton;
        this.showPopupButton = showPopupButton;
        firePropertyChange(PROPERTY_SHOW_POPUP_BUTTON, oldValue, showPopupButton);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setUseFloat(Boolean useFloat) {
        Boolean oldValue = this.useFloat;
        this.useFloat = useFloat;
        firePropertyChange(PROPERTY_USE_FLOAT, oldValue, useFloat);
    }

    public void setUseSign(Boolean useSign) {
        Boolean oldValue = this.useSign;
        this.useSign = useSign;
        firePropertyChange(PROPERTY_USE_SIGN, oldValue, useSign);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton10() {
        return $JButton10;
    }

    protected JButton get$JButton11() {
        return $JButton11;
    }

    protected JButton get$JButton12() {
        return $JButton12;
    }

    protected JButton get$JButton13() {
        return $JButton13;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JButton get$JButton5() {
        return $JButton5;
    }

    protected JButton get$JButton6() {
        return $JButton6;
    }

    protected JButton get$JButton7() {
        return $JButton7;
    }

    protected JButton get$JButton8() {
        return $JButton8;
    }

    protected JButton get$JButton9() {
        return $JButton9;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add($JPanel1);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(resetButton);
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("numbereditor.7"));
        $JButton0.setFocusable(false);
        $JButton0.setFocusPainted(false);
        if ($JButton0.getFont() != null) {
            $JButton0.setFont($JButton0.getFont().deriveFont((float) 14));
        }
        $JButton0.setForeground(new Color(0, 0, 255));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        $JButton0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton0"));
        $JButton0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton0"));
    }

    protected void create$JButton1() {
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("numbereditor.8"));
        $JButton1.setFocusable(false);
        $JButton1.setFocusPainted(false);
        if ($JButton1.getFont() != null) {
            $JButton1.setFont($JButton1.getFont().deriveFont((float) 14));
        }
        $JButton1.setForeground(new Color(0, 0, 255));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        $JButton1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton1"));
        $JButton1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton1"));
    }

    protected void create$JButton10() {
        $objectMap.put("$JButton10", $JButton10 = new JButton());
        
        $JButton10.setName("$JButton10");
        $JButton10.setText(_("numbereditor.3"));
        $JButton10.setFocusable(false);
        $JButton10.setFocusPainted(false);
        if ($JButton10.getFont() != null) {
            $JButton10.setFont($JButton10.getFont().deriveFont((float) 14));
        }
        $JButton10.setForeground(new Color(0, 0, 255));
        $JButton10.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton10"));
        $JButton10.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton10"));
        $JButton10.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton10"));
    }

    protected void create$JButton11() {
        $objectMap.put("$JButton11", $JButton11 = new JButton());
        
        $JButton11.setName("$JButton11");
        $JButton11.setEnabled(false);
        $JButton11.setFocusable(false);
        $JButton11.setFocusPainted(false);
        if ($JButton11.getFont() != null) {
            $JButton11.setFont($JButton11.getFont().deriveFont((float) 14));
        }
        $JButton11.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton11"));
        $JButton11.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton11"));
    }

    protected void create$JButton12() {
        $objectMap.put("$JButton12", $JButton12 = new JButton());
        
        $JButton12.setName("$JButton12");
        $JButton12.setText(_("numbereditor.0"));
        $JButton12.setFocusable(false);
        $JButton12.setFocusPainted(false);
        if ($JButton12.getFont() != null) {
            $JButton12.setFont($JButton12.getFont().deriveFont((float) 14));
        }
        $JButton12.setForeground(new Color(0, 0, 255));
        $JButton12.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton12"));
        $JButton12.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton12"));
        $JButton12.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton12"));
    }

    protected void create$JButton13() {
        $objectMap.put("$JButton13", $JButton13 = new JButton());
        
        $JButton13.setName("$JButton13");
        $JButton13.setFocusable(false);
        $JButton13.setFocusPainted(false);
        if ($JButton13.getFont() != null) {
            $JButton13.setFont($JButton13.getFont().deriveFont((float) 14));
        }
        $JButton13.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton13"));
        $JButton13.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton13"));
        $JButton13.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton13"));
    }

    protected void create$JButton2() {
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("numbereditor.9"));
        $JButton2.setFocusable(false);
        $JButton2.setFocusPainted(false);
        if ($JButton2.getFont() != null) {
            $JButton2.setFont($JButton2.getFont().deriveFont((float) 14));
        }
        $JButton2.setForeground(new Color(0, 0, 255));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        $JButton2.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton2"));
        $JButton2.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton2"));
    }

    protected void create$JButton3() {
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("numbereditor.clearAll"));
        $JButton3.setFocusable(false);
        $JButton3.setFocusPainted(false);
        if ($JButton3.getFont() != null) {
            $JButton3.setFont($JButton3.getFont().deriveFont((float) 14));
        }
        $JButton3.setForeground(new Color(255, 0, 0));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        $JButton3.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton3"));
        $JButton3.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton3"));
    }

    protected void create$JButton4() {
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("numbereditor.4"));
        $JButton4.setFocusable(false);
        $JButton4.setFocusPainted(false);
        if ($JButton4.getFont() != null) {
            $JButton4.setFont($JButton4.getFont().deriveFont((float) 14));
        }
        $JButton4.setForeground(new Color(0, 0, 255));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        $JButton4.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton4"));
        $JButton4.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton4"));
    }

    protected void create$JButton5() {
        $objectMap.put("$JButton5", $JButton5 = new JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("numbereditor.5"));
        $JButton5.setFocusable(false);
        $JButton5.setFocusPainted(false);
        if ($JButton5.getFont() != null) {
            $JButton5.setFont($JButton5.getFont().deriveFont((float) 14));
        }
        $JButton5.setForeground(new Color(0, 0, 255));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        $JButton5.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton5"));
        $JButton5.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton5"));
    }

    protected void create$JButton6() {
        $objectMap.put("$JButton6", $JButton6 = new JButton());
        
        $JButton6.setName("$JButton6");
        $JButton6.setText(_("numbereditor.6"));
        $JButton6.setFocusable(false);
        $JButton6.setFocusPainted(false);
        if ($JButton6.getFont() != null) {
            $JButton6.setFont($JButton6.getFont().deriveFont((float) 14));
        }
        $JButton6.setForeground(new Color(0, 0, 255));
        $JButton6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        $JButton6.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton6"));
        $JButton6.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton6"));
    }

    protected void create$JButton7() {
        $objectMap.put("$JButton7", $JButton7 = new JButton());
        
        $JButton7.setName("$JButton7");
        $JButton7.setText(_("numbereditor.clearOne"));
        $JButton7.setFocusable(false);
        $JButton7.setFocusPainted(false);
        if ($JButton7.getFont() != null) {
            $JButton7.setFont($JButton7.getFont().deriveFont((float) 14));
        }
        $JButton7.setForeground(new Color(255, 0, 0));
        $JButton7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton7"));
        $JButton7.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton7"));
        $JButton7.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton7"));
    }

    protected void create$JButton8() {
        $objectMap.put("$JButton8", $JButton8 = new JButton());
        
        $JButton8.setName("$JButton8");
        $JButton8.setText(_("numbereditor.1"));
        $JButton8.setFocusable(false);
        $JButton8.setFocusPainted(false);
        if ($JButton8.getFont() != null) {
            $JButton8.setFont($JButton8.getFont().deriveFont((float) 14));
        }
        $JButton8.setForeground(new Color(0, 0, 255));
        $JButton8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton8"));
        $JButton8.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton8"));
        $JButton8.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton8"));
    }

    protected void create$JButton9() {
        $objectMap.put("$JButton9", $JButton9 = new JButton());
        
        $JButton9.setName("$JButton9");
        $JButton9.setText(_("numbereditor.2"));
        $JButton9.setFocusable(false);
        $JButton9.setFocusPainted(false);
        if ($JButton9.getFont() != null) {
            $JButton9.setFont($JButton9.getFont().deriveFont((float) 14));
        }
        $JButton9.setForeground(new Color(0, 0, 255));
        $JButton9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton9"));
        $JButton9.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton9"));
        $JButton9.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton9"));
    }

    protected void createAutoPopup() {
        $objectMap.put("autoPopup", autoPopup = false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDot() {
        $objectMap.put("dot", dot = new JButton());
        
        dot.setName("dot");
        dot.setText(_("numbereditor.."));
        dot.setFocusable(false);
        dot.setFocusPainted(false);
        if (dot.getFont() != null) {
            dot.setFont(dot.getFont().deriveFont((float) 14));
        }
        dot.setForeground(new Color(0, 153, 0));
        dot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dot"));
        dot.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__dot"));
        dot.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__dot"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new NumberEditorHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createModelText() {
        $objectMap.put("modelText", modelText = "");
    }

    protected void createModelType() {
        $objectMap.put("modelType", modelType = null);
    }

    protected void createNumberPattern() {
        $objectMap.put("numberPattern", numberPattern = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeVisible", this, "doPopupMenuWillBecomeVisible__on__popup"));
    }

    protected void createPopupVisible() {
        $objectMap.put("popupVisible", popupVisible = false);
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusPainted(false);
        resetButton.setFocusable(false);
        resetButton.setToolTipText(_("numbereditor.action.reset.tip"));
        if (resetButton.getFont() != null) {
            resetButton.setFont(resetButton.getFont().deriveFont((float) 14));
        }
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
        resetButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__resetButton"));
        resetButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__resetButton"));
    }

    protected void createSelectAllTextOnError() {
        $objectMap.put("selectAllTextOnError", selectAllTextOnError = false);
    }

    protected void createShowPopUpButton() {
        $objectMap.put("showPopUpButton", showPopUpButton = new JToggleButton());
        
        showPopUpButton.setName("showPopUpButton");
        showPopUpButton.setFocusPainted(false);
        showPopUpButton.setFocusable(false);
        showPopUpButton.setToolTipText(_("numbereditor.action.show.tip"));
        showPopUpButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showPopUpButton"));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = false);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new JTextField());
        
        textField.setName("textField");
        textField.setColumns(15);
        textField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__textField"));
        textField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textField"));
    }

    protected void createToggleSign() {
        $objectMap.put("toggleSign", toggleSign = new JButton());
        
        toggleSign.setName("toggleSign");
        toggleSign.setText(_("numbereditor.toggleSign"));
        toggleSign.setFocusable(false);
        toggleSign.setFocusPainted(false);
        if (toggleSign.getFont() != null) {
            toggleSign.setFont(toggleSign.getFont().deriveFont((float) 14));
        }
        toggleSign.setForeground(new Color(0, 153, 0));
        toggleSign.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__toggleSign"));
        toggleSign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__toggleSign"));
        toggleSign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__toggleSign"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setBorderPainted(false);
        toolbar.setFloatable(false);
    }

    protected void createUseFloat() {
        $objectMap.put("useFloat", useFloat = false);
    }

    protected void createUseSign() {
        $objectMap.put("useSign", useSign = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.WEST);
        add(textField, BorderLayout.CENTER);
        add($JToolBar0, BorderLayout.EAST);
        addChildrenToPopup();
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton0);
        $JPanel1.add($JButton1);
        $JPanel1.add($JButton2);
        $JPanel1.add($JButton3);
        $JPanel1.add($JButton4);
        $JPanel1.add($JButton5);
        $JPanel1.add($JButton6);
        $JPanel1.add($JButton7);
        $JPanel1.add($JButton8);
        $JPanel1.add($JButton9);
        $JPanel1.add($JButton10);
        $JPanel1.add($JButton11);
        $JPanel1.add($JButton12);
        $JPanel1.add(toggleSign);
        $JPanel1.add(dot);
        $JPanel1.add($JButton13);
        addChildrenToToolbar();
        // inline complete setup of $JToolBar0
        $JToolBar0.add(showPopUpButton);
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        $JPanel1.setBackground(Color.WHITE);
        $JPanel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        $JButton13.setIcon(SwingUtil.createActionIcon("numbereditor-validate"));
        resetButton.setIcon(SwingUtil.createActionIcon("numbereditor-reset"));
        $JToolBar0.setMaximumSize(new Dimension(24,24));
        showPopUpButton.setIcon(SwingUtil.createActionIcon("numbereditor-calculator"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createProperty();
        createBean();
        createModel();
        createModelType();
        createUseFloat();
        createUseSign();
        createAutoPopup();
        createShowPopupButton();
        createShowReset();
        createNumberPattern();
        createModelText();
        createPopupVisible();
        createSelectAllTextOnError();
        createHandler();
        createPopup();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(4,4));
        create$JButton0();
        create$JButton1();
        create$JButton2();
        create$JButton3();
        create$JButton4();
        create$JButton5();
        create$JButton6();
        create$JButton7();
        create$JButton8();
        create$JButton9();
        create$JButton10();
        create$JButton11();
        create$JButton12();
        createToggleSign();
        createDot();
        create$JButton13();
        createToolbar();
        createResetButton();
        createTextField();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        $JToolBar0.setOpaque(false);
        createShowPopUpButton();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JPanel0"));
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$JPanel0"));
        $JPanel0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JPanel0"));
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_ENABLED, true ,"modelText") {
        
            @Override
            public void processDataBinding() {
                if (getModelText() != null) {
                    $JButton3.setEnabled(!getModelText().isEmpty());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON7_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("modelText", this);
                if (textField != null) {
                    textField.addPropertyChangeListener("caretPosition", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModelText() != null && textField != null) {
                    $JButton7.setEnabled(!(getModelText().isEmpty() || textField.getCaretPosition() ==0 ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("modelText", this);
                if (textField != null) {
                    textField.removePropertyChangeListener("caretPosition", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON12_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getEditor() != null) {
                    getEditor().addPropertyChangeListener("modelText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEditor() != null && getEditor().getModelText() != null) {
                    $JButton12.setEnabled(!getEditor().getModelText().equals("0"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getEditor() != null) {
                    getEditor().removePropertyChangeListener("modelText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOGGLE_SIGN_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("useSign", this);
                if (getEditor() != null) {
                    getEditor().addPropertyChangeListener("modelText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEditor() != null && getEditor().getModelText() != null) {
                    toggleSign.setEnabled(isUseSign() && !getEditor().getModelText().isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("useSign", this);
                if (getEditor() != null) {
                    getEditor().removePropertyChangeListener("modelText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOT_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("useFloat", this);
                if (getEditor() != null) {
                    getEditor().addPropertyChangeListener("modelText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEditor() != null && getEditor().getModelText() != null) {
                    dot.setEnabled(isUseFloat() && getEditor().getModelText().indexOf(".") == -1 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("useFloat", this);
                if (getEditor() != null) {
                    getEditor().removePropertyChangeListener("modelText", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbar.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_FIELD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textField.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_FIELD_TEXT, true ,"modelText") {
        
            @Override
            public void processDataBinding() {
                SwingUtil.setText(textField, getModelText());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR0_VISIBLE, true ,"showPopupButton") {
        
            @Override
            public void processDataBinding() {
                $JToolBar0.setVisible(isShowPopupButton());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SHOW_POP_UP_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                showPopUpButton.setEnabled(isEnabled());
            }
        });
    }

}