package jaxx.runtime.swing.editor;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class TimeEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_TIME_MODEL = "timeModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HOUR_ENABLED = "hour.enabled";
    public static final String BINDING_HOUR_VALUE = "hour.value";
    public static final String BINDING_MINUTE_ENABLED = "minute.enabled";
    public static final String BINDING_MINUTE_MODEL_VALUE = "minuteModel.value";
    public static final String BINDING_SLIDER_ENABLED = "slider.enabled";
    public static final String BINDING_SLIDER_VALUE = "slider.value";
    public static final String BINDING_TITLE_TEXT = "title.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTW8bRRgeu7EdJ02aNrQqapAWmkp2W9ZOW6WHIGhwHCWRE1BspApfOvZO7Qnj2WVmtnFqFfET+Alw54LEjRPiwJkDF8RfQIgDV8Q7s2uPN1mUVCJyRrvv1zzv837st3+gnBTo7SM8HLoi5IoOiLu3+fTpR50j0lVbRHYFDZQvUPSXyaJsG817E7lU6Ha7od0rsXul5g8CnxM+5b3RQHNSnTAi+4Qohd5KenSlrDQn6o1hEIpx1AmotKhf//Vn9ivvy2+yCA0DQHcFUnHO87KZzDRQlnoKXYObXuAKw7wHMATlPcC7oGU1hqU8wAPyOfoCFRooH2ABwRR65+IpmxjGfxgoNLu69zHmhFUVWk0glcdwr0s8Cr5uCyR18xgExjcPnoHwAyLUiUJLGpur8boRXmuVY7hDmH5ZtMKZDsE84RaV11oUNYZ93yNMoavWbJcr0iNTIGY8rIhCi8YkVJS5WyCw+vkB5aEaR1rRZsM4tWZAOSdC2xu1dSr0MfcYpIbuXYSSnch6yn+1hTuMAKU3U/yNTlsWLUmKKgZpXJvGt9cYM+dYzlcjaVW/30nqZvp+CJDfSMSIk0xa5k1NdlJi5CO69NvdUxrJqKcpWU7GN9I4G4FuJfKFMXLtGNk+z7RRToQgBoLaZyfvEFTRzN08NXM6oNH+c2P51x9+/357PGgFuPt6qunUnoABiFuW6quvRFOmm6ayj4ONNipKwqALzRJZSQHWjNUADu67antuB8s+hMgVfvvxpxvPfrmEsttojvnY28bafhfauS+ABZ95w+CDJwbR5eNZOJfgPwuk9n1BX/pcYbbJaI8PzFDfHiX6VZ81n0sFsyPdWv2gVT98BXVXZAjGl0c9okxzlMqvhkDeSgp5kww6xZ//Xm5+92RMYAYSevM/zS2JuU9RnnJGOTG7Kl5DqbtpPpAk9Hy7btIWEBo3fxCPz2Nzbpwh6RIYDqIpvjPi5NiJO/sgHHSIMANcqt534Pfg4X1nrQzE5F5gFkLfXdfMtMb7pFR2Ks56FfQFwvUowsJdGFFZj14MeRrCpmFFP9VQPFznYfyfCqnpj5fMThqWeHwvgGahixnhHhbblDDI89bI9mwtVrn7uweftOpTfJU0X/FSK5VdSdS+XaIl0OmVWSqnEzW9cC+AcFzThdGU32vWJl5a5902C+ACTHk0JFLzLXS6c0bYot3PrKz4HEr4rqQv4Tm7tgafqgE+8oU2aga4C/UD+XrV4q+antwiz3HI1Id+yD3iHcIXi0w6c80053rVues8eKTbcwlgnw75sGrLsHSqbV+XlWhhn8dKxvTTiR9C5y2+B19T7HQo9wDO+2eiZvQ5BxH/BbQKs7+mCQAA";
    private static final Log log = LogFactory.getLog(TimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Object bean;
    protected Date date;
    protected TimeEditorHandler handler;
    protected JSpinner hour;
    protected String label;
    protected JLabel labelH;
    protected JSpinner minute;
    protected SpinnerDateModel minuteModel;
    protected String property;
    protected JSlider slider;
    protected Integer timeModel;
    protected JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private TimeEditor $JPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        minute.setEditor(new JSpinner.DateEditor(minute, "mm"));
        handler.init();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TimeEditor() {
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TimeEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doStateChanged__on__hour(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setTimeModel((Integer)hour.getValue() * 60 + getHandler().getMinute());
    }

    public void doStateChanged__on__minute(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateTimeModelFromMinuteModel(minuteModel.getDate());
    }

    public void doStateChanged__on__slider(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!slider.getValueIsAdjusting()) setTimeModel(slider.getValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Object getBean() {
        return bean;
    }

    public Date getDate() {
        return date;
    }

    public TimeEditorHandler getHandler() {
        return handler;
    }

    public JSpinner getHour() {
        return hour;
    }

    public String getLabel() {
        return label;
    }

    public JLabel getLabelH() {
        return labelH;
    }

    public JSpinner getMinute() {
        return minute;
    }

    public SpinnerDateModel getMinuteModel() {
        return minuteModel;
    }

    public String getProperty() {
        return property;
    }

    public JSlider getSlider() {
        return slider;
    }

    public Integer getTimeModel() {
        return timeModel;
    }

    public JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Object bean) {
        Object oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setDate(Date date) {
        Date oldValue = this.date;
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public void setLabel(String label) {
        String oldValue = this.label;
        this.label = label;
        firePropertyChange(PROPERTY_LABEL, oldValue, label);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setTimeModel(Integer timeModel) {
        Integer oldValue = this.timeModel;
        this.timeModel = timeModel;
        firePropertyChange(PROPERTY_TIME_MODEL, oldValue, timeModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDate() {
        $objectMap.put("date", date = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new TimeEditorHandler(this));
    }

    protected void createHour() {
        $objectMap.put("hour", hour = new JSpinner());
        
        hour.setName("hour");
        hour.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hour"));
    }

    protected void createLabel() {
        $objectMap.put("label", label = "");
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new JLabel());
        
        labelH.setName("labelH");
        labelH.setText(t("timeeditor.H"));
    }

    protected void createMinute() {
        $objectMap.put("minute", minute = new JSpinner());
        
        minute.setName("minute");
        minute.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minute"));
    }

    protected void createMinuteModel() {
        $objectMap.put("minuteModel", minuteModel = new SpinnerDateModel());
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createSlider() {
        $objectMap.put("slider", slider = new JSlider());
        
        slider.setName("slider");
        slider.setValue(0);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        if (slider.getFont() != null) {
            slider.setFont(slider.getFont().deriveFont((float) 11));
        }
        slider.setMajorTickSpacing(60);
        slider.setMinorTickSpacing(30);
        slider.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__slider"));
    }

    protected void createTimeModel() {
        $objectMap.put("timeModel", timeModel = 0);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new JLabel());
        
        title.setName("title");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($Table0, BorderLayout.NORTH);
        add(slider, BorderLayout.SOUTH);
        // inline complete setup of $Table0
        $Table0.add(title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(hour, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(labelH, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(minute, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        minuteModel.setCalendarField(java.util.Calendar.MINUTE);
        title.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        hour.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        labelH.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        minute.setModel(minuteModel);
        slider.setModel(new DefaultBoundedRangeModel(0, 1, 0, 60 * 24));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createProperty();
        createLabel();
        createBean();
        createTimeModel();
        createDate();
        createMinuteModel();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createTitle();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createHour();
        createLabelH();
        createMinute();
        createSlider();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_MODEL_VALUE, true ,"date") {
        
            @Override
            public void processDataBinding() {
                minuteModel.setValue(getHandler().setMinuteModel(getDate()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"label") {
        
            @Override
            public void processDataBinding() {
                title.setText(t(getLabel()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_VALUE, true ,"timeModel") {
        
            @Override
            public void processDataBinding() {
                hour.setValue(getTimeModel() / 60);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hour.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                minute.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_VALUE, true ,"timeModel") {
        
            @Override
            public void processDataBinding() {
                slider.setValue(getTimeModel());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SLIDER_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                slider.setEnabled(isEnabled());
            }
        });
    }

}