package jaxx.runtime.swing;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2018 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.Timer;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryStatusWidget extends JComponent implements ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PROGRESS_BACKGROUND = "progressBackground";
    public static final String PROPERTY_PROGRESS_FOREGROUND = "progressForeground";
    public static final String PROPERTY_TIMER = "timer";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TwW7TQBCdGJKQtEBpoSoiSIEWTpXNPQgKRVGpUpAIEhW5dBMviYvjXXbHxL0gPoFPgDsXJG6cEAfOHLggfgEhDlwRs45jJ2BEfbCtnfdm3sy8ff0NilrBhX0WRbYKA/SG3N6+sbt7t7vPe3iL657yJAoF46dggdWBOTc91wirnZahOwnd2RRDKQIeTLEbLahqPPC5HnCOCOdnGT2tnXYabkQyVJOsqai8rC9/fLdeuM9fWQCRJHWmlfr/WFknR1tgeS7CIlV6yhyfBX2SobygT3qPm7NNn2l9hw35E3gG5RaUJFOUDOHi4VuOc8T8SCLMr22n4CsIl2bU6hHVtnf4UKiDNjIM9QPP7XOUMk5QQigPWOD6XCGsH4q5NYZnCYoGTvRTpr0o4d03ZxlmUSrRV1zrm6z3uK9EGNCQThiCzUZIM/VFHropFB+jTeQ0IRScm1FJe7azPWeLKHSgqEI6Rljp/G2NexQam2LlD1OYhHH01/LS53df3zYnTrCo9plc6JSRaUOkXdI4PFP65NgGIXq+s8NkowMVzX26BbHLaznC2kmYxFG9eKS2odtbTA8oRbH85f2H5b1PR8BqQtUXzG0yg78NFRzQyAbCdyN5fSNWND86Ru8Fow2h2p0e/VWXIat3vcClbV2LaBC1nEGkarqVjz+X2m82JsMokLiz/4RnAyk+hJIX+F7A44uReD73IsxJzUNXZN7Oc3vBfKsysUotftdzu300Y53VKDSftVi6+bucZvoNd/ihkrAEAAA=";
    private static final Log log = LogFactory.getLog(MemoryStatusWidget.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected MemoryStatusWidgetHandler handler;
    protected Color progressBackground;
    protected Color progressForeground;
    protected Timer timer;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MemoryStatusWidget $JComponent0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void actionPerformed(ActionEvent evt) {
        repaint();
    }
    
    /** Adds a feature to the Notify attribute of the MemoryStatus object */
    @Override
    public void addNotify() {
        super.addNotify();
        setTimer(new Timer(2000, this));
        timer.start();
    }
    
    @Override
    public void removeNotify() {
        if (timer != null) {
            timer.stop();
            timer = null;
        }
        super.removeNotify();
    }
    
    @Override
    public void paintComponent(Graphics g) {
        handler.paintComponent(g);
    }
    
    
    void $afterCompleteSetup() {
        handler.$afterCompleteSetup();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MemoryStatusWidget() {
        $initialize();
    }

    public MemoryStatusWidget(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public MemoryStatusWidgetHandler getHandler() {
        return handler;
    }

    public Color getProgressBackground() {
        return progressBackground;
    }

    public Color getProgressForeground() {
        return progressForeground;
    }

    public Timer getTimer() {
        return timer;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProgressBackground(Color progressBackground) {
        Color oldValue = this.progressBackground;
        this.progressBackground = progressBackground;
        firePropertyChange(PROPERTY_PROGRESS_BACKGROUND, oldValue, progressBackground);
    }

    public void setProgressForeground(Color progressForeground) {
        Color oldValue = this.progressForeground;
        this.progressForeground = progressForeground;
        firePropertyChange(PROPERTY_PROGRESS_FOREGROUND, oldValue, progressForeground);
    }

    public void setTimer(Timer timer) {
        Timer oldValue = this.timer;
        this.timer = timer;
        firePropertyChange(PROPERTY_TIMER, oldValue, timer);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHandler() {
        $objectMap.put("handler", handler = new MemoryStatusWidgetHandler(this));
    }

    protected void createProgressBackground() {
        $objectMap.put("progressBackground", progressBackground = Color.decode("#666699a"));
    }

    protected void createProgressForeground() {
        $objectMap.put("progressForeground", progressForeground = Color.decode("#cccccc"));
    }

    protected void createTimer() {
        $objectMap.put("timer", timer = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 property setters
        setBackground(Color.WHITE);
        setForeground(Color.BLACK);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JComponent0", $JComponent0);
        createHandler();
        createTimer();
        createProgressBackground();
        createProgressForeground();
        // inline creation of $JComponent0
        setName("$JComponent0");
        
        $completeSetup();
    }

}