package jaxx.runtime.swing;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2018 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.model.GenericListListener;
import jaxx.runtime.swing.model.GenericListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ListSelector<B> extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_TOOL_TIP = "addToolTip";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_REMOVE_TOOL_TIP = "removeToolTip";
    public static final String PROPERTY_RENDERER = "renderer";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI2SzUrDQBDHp8G2UqmIghRU/Oo58d6TVDxIVGh7KOSUNkNN2WTX3WmNF/ERfAS9e/Tmc3jzFUR8AXE3/Uirgu5xZn7/+c/OPL5BXknY7ftJYstBTGGE9slhu33e6WOXjlB1ZSiISxi9nAWWB0vBNK4I9j3X4M4Yd+o8EjzGeIauuVBSdM1QXSASwdY80VXKaU7TtUQM5ER1auo31fuPd+suuH2wABKh3ZlRdv6iskkWXLDCgGBVdxr6DvPjnrYhw7in/ZZNrM58pc78CC/hBoouFIQvtRjB3v9HTjVSPhEExWrL7zA8INieM6qudFvbDRU1kemf51KIlCoQlPwgaHHOWloYVowv23i1R16zurLEiA9xXGqCy1kyH/EAGUH1j7anpizDFvW8AUqUBJumczKD1JGxxjitCQkbc9p6q3a21ezbcx7k5UCHCSrez0No6NToBCrfTsAIptnP9bWX59en48ne4Qtq3j+fxwIAAA==";
    private static final Log log = LogFactory.getLog(ListSelector.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected String addToolTip;
    protected ListSelectorModel<B> model;
    protected String removeToolTip;
    protected ListCellRenderer renderer;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListSelector<B> $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setValues(Collection<B> values) {
        model.setValues(values);
    }
    
    public Collection<B> getValues() {
        return model.getValues();
    }
    
    public void setSelectedValues(Collection<B> selectedValues) {
        model.setSelectedValues(selectedValues);
    }
    
    public Collection<B> getSelectedValues() {
        return model.getSelectedValues();
    }
    
    public void addGenericListListener(GenericListListener l) {
        model.addGenericListListener(l);
    }
    
    public void removeGenericListListener(GenericListListener l) {
        model.removeGenericListListener(l);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListSelector() {
        $initialize();
    }

    public ListSelector(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getAddToolTip() {
        return addToolTip;
    }

    public ListSelectorModel<B> getModel() {
        return model;
    }

    public String getRemoveToolTip() {
        return removeToolTip;
    }

    public ListCellRenderer getRenderer() {
        return renderer;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddToolTip(String addToolTip) {
        String oldValue = this.addToolTip;
        this.addToolTip = addToolTip;
        firePropertyChange(PROPERTY_ADD_TOOL_TIP, oldValue, addToolTip);
    }

    public void setModel(ListSelectorModel<B> model) {
        ListSelectorModel<B> oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    public void setRemoveToolTip(String removeToolTip) {
        String oldValue = this.removeToolTip;
        this.removeToolTip = removeToolTip;
        firePropertyChange(PROPERTY_REMOVE_TOOL_TIP, oldValue, removeToolTip);
    }

    public void setRenderer(ListCellRenderer renderer) {
        ListCellRenderer oldValue = this.renderer;
        this.renderer = renderer;
        firePropertyChange(PROPERTY_RENDERER, oldValue, renderer);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddToolTip() {
        $objectMap.put("addToolTip", addToolTip = "+");
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createRemoveToolTip() {
        $objectMap.put("removeToolTip", removeToolTip = "-");
    }

    protected void createRenderer() {
        $objectMap.put("renderer", renderer = new DefaultListCellRenderer());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createAddToolTip();
        createRemoveToolTip();
        createModel();
        createRenderer();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}