package jaxx.runtime.swing.editor.bean;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.bean.BeanTypeAware;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.JXPathDecorator;
import static org.nuiton.i18n.I18n.t;

public class BeanListHeader<O> extends JPanel implements BeanTypeAware<O>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN_TYPE = "beanType";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_I18N_PREFIX = "i18nPrefix";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_LABEL_TEXT = "labelText";
    public static final String PROPERTY_LIST = "list";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_TITLE_TEXT = "popupTitleText";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CHANGE_DECORATOR_VISIBLE = "changeDecorator.visible";
    public static final String BINDING_LABEL_TEXT = "label.text";
    public static final String BINDING_RESET_SELECTION_ENABLED = "resetSelection.enabled";
    public static final String BINDING_RESET_SELECTION_VISIBLE = "resetSelection.visible";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_GROUP_SELECTED_VALUE = "sortGroup.selectedValue";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WTW8jRRDteGM7dhJ7QyBK2EVystLKQcpEKwEChY8lG0KCvBDFXhQRhGh7OvasOtOzPT3JRFYQP4GfAHcuSNw4IQ6cOXBB/AWEOHBFVPXY0zOTiWIkchjFXV1Vr15Xve5v/yBFX5LVpzQMLRm4yjll1gfvHh191H3KemqH+T3peEpIEv1NFUjhmMza8bqvyL3jFrpvjtw3H4lTT7jMTXhvtUjVVxec+QPGlCIvpT16vr/Zjs1boRfIcdQYVF7Ur//6s/CV/eU3BUJCD9DdgVIaN3mZSqZbpODYijwHmc7oJqduH2BIx+0D3nlce8Sp739IT9kz8gUpt0jJoxKCKbI2eck6hvYPPUVuKQHfjRRI/xxSWsx2wM3qMupa2/BpOb7aY9Rm0vO0f0mRij8Q54fMRw4XEKCFoK1tITh4mH3zuG+H9YSkEBMXa8Y4K9kZkz5rC6kyphkEQbucZdcRVefCY4rUTVpdWQIcp13GOywEcLfNrohRs63ouDbsSeLfdxXrJ+uctqmiitT0lkA53EI2jL2sYzBovrUcJrF/twOlhPu+FIGXpA9K1mu4cC8Rb0BdmzOpyCv/6WT2IjcTaNFnHOaG2R04ko7jIRtoetFsWXKFat+4q+YJL/A6juIsx1p1HrzuHkh24oQZS1H7QRakLhwTcoCLj5kbZBNgD7Tw2GAKUh56Ebc+iD1KyN4TiN1I7TyktiMiujHDvmKnab8Z9NsR5y7+fiNtG6FgMFfYqVncsSHtVdVeMcTX0tZpDucz6i9TD6yhvWKY4il/YygrOJUuBTDPp0LgYW1Tmd5ckziN0Xk6woUOSPlEvODe3dil3oNu67N4PBVZyeTp9zlLeUpyJ9WXIJiWEUyjaFPHpCgDjoOxfHxVYw/BFKnrckZdMaC2/rO0+OsPv3+/O5bUWcj9Qu7WxI0AUudJ4cH8OJi6Hukpzu3mY+ptHcPgaYL0dXE3B1h7ZAZwkG/BjP0e9QcQolj+7ceflj7/5RYp7JIqF9Tepbh/n1TUAE5gILgdeu881IjmzmfgexuxwfkEPktMGXSHkgELgYK7ORTEOLqVn/9ebH/3cEzDFMBauXa7oaL4CSk5Lndcpu+W0bWRe5fMej4LbGGuh7wLgxitG+tYR3+PrhRbQNkf6crHlAfQFwtDxz80Yt9cv7yeEAz6qa4U//uMJNXyptTAc6krpI0CujF02XlDC5e9rdeaqrmG2oljaenJtRSa19bXL/PyRhI2QblVqmduv4dzV8EUGwgZS9KV1bVi45KlZz0vWUYGb8pahOuza66WJEkZPHMxng20jSDNGUi4WjyLDqo8PKHcZ5colqMjBEEermaPL6+CkSz/f8hrBrkNqh1jrxns0foYfWmILZQGf7X18rDHV8MEp10SHn2G6YqaqxjWy8M26uYTlIs+SLF+bugBaMLP1vhN0ryu2/gk547DFXX4AXVcXeEYRuUE9Eg/msZreWnGl8pNiUrZw+iJ067oinBDRs++8pnjOzpZHShuj9+DerYrJ6IX+EkocOgqOewr8SBGSSwdFeYRmqDMXHSF0l6FyO9FP5rrjfv3G0gkODXXNcNJkQH76lsNN+Ac8s/p/BmGcqcufWtO0LspUuZjUqJ5N5wsjjiJL9cJeVnO8qLbXNMycVHZe30S1eT0QgQ4W2/ii7fRBa2H7n37Svgp/FYh4r+pYsxIsQ0AAA==";
    private static final Log log = LogFactory.getLog(BeanListHeader.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Class<O> beanType;
    protected JToggleButton changeDecorator;
    protected List<O> data;
    protected Boolean editable;
    protected BeanListHeaderHandler<O> handler;
    protected String i18nPrefix;
    protected Integer index;
    protected JAXXButtonGroup indexes;
    protected JLabel label;
    protected String labelText;
    protected JList list;
    protected String notSelectedToolTipText;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JSeparator popupSeparator;
    protected JLabel popupSortLabel;
    protected String popupTitleText;
    protected JButton resetSelection;
    protected Boolean reverseSort;
    protected String selectedToolTipText;
    protected Boolean showDecorator;
    protected Boolean showReset;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;
    protected JToolBar toolbar;
    protected BeanListHeader<O> top = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(JXPathDecorator<O> decorator, List<O> data) {
        handler.init(decorator, data);
    }
    
    public O getSelectedValue() {
        return handler.getSelectedValue();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanListHeader(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanListHeader(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BeanListHeader(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanListHeader(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BeanListHeader() {
        $initialize();
    }

    public BeanListHeader(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BeanListHeader(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanListHeader(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__changeDecorator(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().togglePopup();
    }

    public void doActionPerformed__on__resetSelection(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getList().getSelectionModel().clearSelection();
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getChangeDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getChangeDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Class<O> getBeanType() {
        return beanType;
    }

    public JToggleButton getChangeDecorator() {
        return changeDecorator;
    }

    public List<O> getData() {
        return data;
    }

    public Boolean getEditable() {
        return editable;
    }

    public BeanListHeaderHandler<O> getHandler() {
        return handler;
    }

    public String getI18nPrefix() {
        return i18nPrefix;
    }

    public Integer getIndex() {
        return index;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public JLabel getLabel() {
        return label;
    }

    public String getLabelText() {
        return labelText;
    }

    public JList getList() {
        return list;
    }

    public String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JSeparator getPopupSeparator() {
        return popupSeparator;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public String getPopupTitleText() {
        return popupTitleText;
    }

    public JButton getResetSelection() {
        return resetSelection;
    }

    public Boolean getReverseSort() {
        return reverseSort;
    }

    public String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public Boolean getShowDecorator() {
        return showDecorator;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    public Boolean isReverseSort() {
        return reverseSort !=null && reverseSort;
    }

    public Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBeanType(Class<O> beanType) {
        Class<O> oldValue = this.beanType;
        this.beanType = beanType;
        firePropertyChange(PROPERTY_BEAN_TYPE, oldValue, beanType);
    }

    public void setData(List<O> data) {
        List<O> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setI18nPrefix(String i18nPrefix) {
        String oldValue = this.i18nPrefix;
        this.i18nPrefix = i18nPrefix;
        firePropertyChange(PROPERTY_I18N_PREFIX, oldValue, i18nPrefix);
    }

    public void setIndex(Integer index) {
        Integer oldValue = this.index;
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public void setLabelText(String labelText) {
        String oldValue = this.labelText;
        this.labelText = labelText;
        firePropertyChange(PROPERTY_LABEL_TEXT, oldValue, labelText);
    }

    public void setList(JList list) {
        JList oldValue = this.list;
        this.list = list;
        firePropertyChange(PROPERTY_LIST, oldValue, list);
    }

    public void setNotSelectedToolTipText(String notSelectedToolTipText) {
        String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = notSelectedToolTipText;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, notSelectedToolTipText);
    }

    public void setPopupTitleText(String popupTitleText) {
        String oldValue = this.popupTitleText;
        this.popupTitleText = popupTitleText;
        firePropertyChange(PROPERTY_POPUP_TITLE_TEXT, oldValue, popupTitleText);
    }

    public void setReverseSort(Boolean reverseSort) {
        Boolean oldValue = this.reverseSort;
        this.reverseSort = reverseSort;
        firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, reverseSort);
    }

    public void setSelectedToolTipText(String selectedToolTipText) {
        String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = selectedToolTipText;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, selectedToolTipText);
    }

    public void setShowDecorator(Boolean showDecorator) {
        Boolean oldValue = this.showDecorator;
        this.showDecorator = showDecorator;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, showDecorator);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add(popupSeparator);
        popup.add(popupLabel);
    }

    protected void addChildrenToSortDown() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(resetSelection);
        toolbar.add(changeDecorator);
    }

    protected void addChildrenToTop() {
        if (!allComponentsCreated) {
            return;
        }
        add(list);
        add(label, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void createBeanType() {
        $objectMap.put("beanType", beanType = null);
    }

    protected void createChangeDecorator() {
        $objectMap.put("changeDecorator", changeDecorator = new JToggleButton());
        
        changeDecorator.setName("changeDecorator");
        changeDecorator.setFocusable(false);
        changeDecorator.setToolTipText(t("beanlist.action.sort.tip"));
        changeDecorator.setFocusPainted(false);
        changeDecorator.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeDecorator"));
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new BeanListHeaderHandler<O>(this));
    }

    protected void createI18nPrefix() {
        $objectMap.put("i18nPrefix", i18nPrefix = "beanlist.common.");
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createLabel() {
        $objectMap.put("label", label = new JLabel());
        
        label.setName("label");
        label.setOpaque(false);
    }

    protected void createLabelText() {
        $objectMap.put("labelText", labelText = null);
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSeparator() {
        $objectMap.put("popupSeparator", popupSeparator = new JSeparator());
        
        popupSeparator.setName("popupSeparator");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(t("bean.sort.label"));
    }

    protected void createPopupTitleText() {
        $objectMap.put("popupTitleText", popupTitleText = null);
    }

    protected void createResetSelection() {
        $objectMap.put("resetSelection", resetSelection = new JButton());
        
        resetSelection.setName("resetSelection");
        resetSelection.setFocusable(false);
        resetSelection.setToolTipText(t("beanlist.action.reset.tip"));
        resetSelection.setFocusPainted(false);
        resetSelection.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetSelection"));
    }

    protected void createReverseSort() {
        $objectMap.put("reverseSort", reverseSort = false);
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(t("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.setUseToolTipText(true);
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(t("bean.sort.up"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setBorderPainted(false);
        toolbar.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        addChildrenToToolbar();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        popup.setBorder(new TitledBorder(t("beanlist.popup.title")));
        popupSortLabel.setIcon(SwingUtil.createActionIcon("bean-sort"));
        sortUp.setIcon(SwingUtil.createActionIcon("bean-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.createActionIcon("bean-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        resetSelection.setIcon(SwingUtil.createActionIcon("combobox-reset"));
        changeDecorator.setIcon(SwingUtil.createActionIcon("combobox-sort"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createShowReset();
        createShowDecorator();
        createReverseSort();
        createEditable();
        createBeanType();
        createLabelText();
        createIndex();
        createData();
        createIndexes();
        createSortGroup();
        createHandler();
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupTitleText();
        createI18nPrefix();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        createPopupSeparator();
        createPopupLabel();
        createList();
        createLabel();
        createToolbar();
        createResetSelection();
        createChangeDecorator();
        // inline creation of top
        setName("top");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_GROUP_SELECTED_VALUE, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortGroup.setSelectedValue(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_UP_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortUp.setSelected(!isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_DOWN_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortDown.setSelected(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT, true ,"labelText") {
        
            @Override
            public void processDataBinding() {
                label.setText(t(SwingUtil.getStringValue(getLabelText())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_SELECTION_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                resetSelection.setVisible(isShowReset());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_SELECTION_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                addPropertyChangeListener("list", this);
                if (getList() != null) {
                    $bindingSources.put(" getList().getSelectionModel()",  getList().getSelectionModel());
                     getList().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    getList().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.runtime.swing.editor.bean.BeanListHeader.this, BINDING_RESET_SELECTION_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getList() != null) {
                    resetSelection.setEnabled(isEnabled() && getList().getSelectedValue() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                removePropertyChangeListener("list", this);
                if (getList() != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove(" getList().getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    getList().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.runtime.swing.editor.bean.BeanListHeader.this, BINDING_RESET_SELECTION_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CHANGE_DECORATOR_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                changeDecorator.setVisible(isShowDecorator());
            }
        });
    }

}