/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.config.model.CallBackFinalizer;
import jaxx.runtime.swing.editor.config.model.CallBackMap;
import jaxx.runtime.swing.editor.config.model.CallBacksManager;
import jaxx.runtime.swing.editor.config.model.CategoryModel;
import jaxx.runtime.swing.editor.config.model.OptionModel;
import org.apache.commons.beanutils.PropertyUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

public class ConfigUIModel
implements Iterable<CategoryModel> {
    public static final String CATEGORY_MODEL_PROPERTY_NAME = "categoryModel";
    protected final Map<String, CategoryModel> categories;
    protected final ApplicationConfig config;
    protected CategoryModel categoryModel;
    protected boolean saved;
    protected boolean standalone;
    protected CallBacksManager callBacksManager;
    protected Runnable closeAction;
    protected final PropertyChangeSupport pcs;

    public ConfigUIModel(ApplicationConfig config) {
        this.config = config;
        this.categories = new LinkedHashMap<String, CategoryModel>();
        this.callBacksManager = new CallBacksManager();
        this.pcs = new PropertyChangeSupport(this);
    }

    public void addCategory(CategoryModel category) {
        if (this.categories.containsKey(category.getCategory())) {
            throw new IllegalArgumentException(I18n._((String)"config.error.category.already.exists", (Object[])new Object[]{category.getCategory()}));
        }
        this.categories.put(category.getCategory(), category);
    }

    public void setCategory(String category) {
        if (!this.categories.containsKey(category)) {
            throw new IllegalArgumentException(I18n._((String)"config.error.category.not.found", (Object[])new Object[]{category}));
        }
        CategoryModel newCategoryModel = this.categories.get(category);
        this.setCategoryModel(newCategoryModel);
        newCategoryModel.firePropertyChange("modified", false, this.getCategoryModel().isModified());
        newCategoryModel.firePropertyChange("valid", false, this.getCategoryModel().isValid());
    }

    public void registerCallBack(String name, String description, Icon icon, Runnable action) {
        this.callBacksManager.registerCallBack(name, description, icon, action);
    }

    public void registerOptionCallBack(String name, OptionModel option) {
        this.callBacksManager.registerOption(name, option);
    }

    public void setFinalizer(CallBackFinalizer finalizer) {
        this.callBacksManager.setFinalizer(finalizer);
    }

    public Runnable getCloseAction() {
        return this.closeAction;
    }

    public void setCloseAction(Runnable closeAction) {
        this.closeAction = closeAction;
    }

    public CallBackMap getCallBacksForSaved() {
        return this.callBacksManager.getCallBacksForSaved(this);
    }

    @Override
    public Iterator<CategoryModel> iterator() {
        return this.categories.values().iterator();
    }

    public CategoryModel getCategoryModel() {
        return this.categoryModel;
    }

    public void setCategoryModel(CategoryModel categoryModel) {
        CategoryModel old = this.categoryModel;
        this.categoryModel = categoryModel;
        this.firePropertyChange(CATEGORY_MODEL_PROPERTY_NAME, old, categoryModel);
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveModified() {
        ArrayList<String> transients = new ArrayList<String>();
        this.config.setAdjusting(true);
        try {
            for (OptionModel option : this.categoryModel) {
                if (option.isModified()) {
                    Object value = option.getValue();
                    if (option.getPropertyName() != null) {
                        try {
                            PropertyUtils.setProperty((Object)this.config, (String)option.getPropertyName(), (Object)value);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("could not set property [" + option.getPropertyName() + "] with value = " + value, e);
                        }
                    } else {
                        this.config.setOption(option.getKey(), value == null ? null : value.toString());
                    }
                    option.setSaved(true);
                    option.initValue(value);
                }
                if (!option.isTransient()) continue;
                transients.add(option.getKey());
            }
        }
        finally {
            this.config.setAdjusting(false);
        }
        this.setSaved(true);
        this.config.saveForUser(transients.toArray(new String[transients.size()]));
        this.categoryModel.firePropertyChange("modified", this.categoryModel.isModified(), true);
        this.categoryModel.firePropertyChange("valid", false, this.categoryModel.isValid());
        this.categoryModel.firePropertyChange("reload", false, true);
    }

    public void reset() {
        for (OptionModel key : this.categoryModel) {
            if (!key.isModified()) continue;
            key.initValue(key.getOriginalValue());
        }
        this.categoryModel.firePropertyChange("modified", this.categoryModel.isModified(), true);
        this.categoryModel.firePropertyChange("valid", false, this.categoryModel.isValid());
        this.categoryModel.firePropertyChange("reload", false, true);
    }

    public int getCategoryIndex(String category) {
        int i = 0;
        for (CategoryModel m : this) {
            if (category.equals(m.getCategory())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void destroy() {
        JAXXUtil.destroy((PropertyChangeSupport)this.pcs);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    protected ApplicationConfig getConfig() {
        return this.config;
    }

    protected CallBacksManager getCallBacksManager() {
        return this.callBacksManager;
    }
}

