/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.bean;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorUtils;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.decorator.MultiJXPathDecorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.AutoCompletePropertyChangeListener;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.nuiton.i18n.I18n;

public class BeanUIUtil {
    public static final String DEFAULT_POPUP_LABEL = I18n.n_((String)"bean.popup.label");
    public static final String DEFAULT_SELECTED_TOOLTIP = I18n.n_((String)"bean.sort.on");
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = I18n.n_((String)"bean.sort.off");

    public static ObjectToStringConverter newDecoratedObjectToStringConverter(final Decorator<?> decorator) {
        return new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object item) {
                return item instanceof String ? (String)item : (item == null ? "" : decorator.toString(item));
            }
        };
    }

    public static void decorate(JComboBox combo, ObjectToStringConverter convertor) {
        AutoCompleteDecorator.decorate((JComboBox)combo, (ObjectToStringConverter)convertor);
    }

    public static void undecorate(JComboBox combo, Document originalDocument) {
        combo.setEditable(false);
        Component c = combo.getEditor().getEditorComponent();
        JTextComponent editorComponent = (JTextComponent)c;
        editorComponent.setDocument(originalDocument);
        editorComponent.setText(null);
        for (PropertyChangeListener l : c.getPropertyChangeListeners("editor")) {
            if (!(l instanceof AutoCompletePropertyChangeListener)) continue;
            c.removePropertyChangeListener("editor", l);
        }
    }

    public static <O> MultiJXPathDecorator<O> createDecorator(JXPathDecorator<O> decorator) {
        String separatorReplacement;
        String separator;
        if (decorator == null) {
            throw new NullPointerException("can not have a null decorator as parameter");
        }
        if (decorator instanceof MultiJXPathDecorator) {
            separator = ((MultiJXPathDecorator)decorator).getSeparator();
            separatorReplacement = ((MultiJXPathDecorator)decorator).getSeparatorReplacement();
        } else {
            separator = "??" + new Date().getTime();
            separatorReplacement = " - ";
        }
        return DecoratorUtils.newMultiJXPathDecorator((Class)decorator.getInternalClass(), (String)decorator.getInitialExpression(), (String)separator, (String)separatorReplacement);
    }

    public static abstract class PopupHandler
    implements Runnable {
        public static final Log log = LogFactory.getLog(PopupHandler.class);

        public abstract JPopupMenu getPopup();

        public abstract JComponent getInvoker();

        @Override
        public void run() {
            this.updatePopup();
            Dimension dim = this.getPopup().getPreferredSize();
            JComponent invoker = this.getInvoker();
            this.getPopup().show(invoker, (int)(invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
        }

        public void togglePopup() {
            boolean newValue;
            boolean bl = newValue = !this.getPopup().isVisible();
            if (log.isTraceEnabled()) {
                log.trace((Object)newValue);
            }
            if (!newValue) {
                if (this.getPopup() != null) {
                    this.getPopup().setVisible(false);
                }
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        protected void updatePopup() {
            this.getPopup().pack();
        }

        protected void preparePopup(String selectedTip, String notSelectedTip, String i18nPrefix, String title, ButtonGroup indexes, JLabel popupLabel, AbstractButton sortUp, AbstractButton sortDown, MultiJXPathDecorator<?> decorator) {
            if (selectedTip == null) {
                selectedTip = DEFAULT_SELECTED_TOOLTIP;
            }
            if (notSelectedTip == null) {
                notSelectedTip = DEFAULT_NOT_SELECTED_TOOLTIP;
            }
            JPopupMenu popup = this.getPopup();
            int max = decorator.getNbContext();
            for (int i = 0; i < max; ++i) {
                String property = i18nPrefix + decorator.getProperty(i);
                String propertyI18n = I18n._((String)property);
                JRadioButtonMenuItem button = new JRadioButtonMenuItem(propertyI18n);
                button.putClientProperty("$buttonGroup", indexes);
                button.putClientProperty("$value", i);
                popup.add(button);
                if (selectedTip != null) {
                    button.putClientProperty("$selected.toolTipText", I18n._((String)selectedTip, (Object[])new Object[]{propertyI18n}));
                }
                if (notSelectedTip != null) {
                    button.putClientProperty("$not.selected.toolTipText", I18n._((String)notSelectedTip, (Object[])new Object[]{propertyI18n}));
                }
                button.setSelected(false);
                indexes.add(button);
            }
            if (title == null) {
                title = DEFAULT_POPUP_LABEL;
                Class internalClass = decorator.getInternalClass();
                String beanI18nKey = internalClass == null ? I18n.n_((String)"bean.unknown.type") : i18nPrefix + Introspector.decapitalize(internalClass.getSimpleName());
                String beanI18n = I18n._((String)beanI18nKey);
                title = I18n._((String)title, (Object[])new Object[]{beanI18n});
            } else {
                title = I18n._((String)title);
            }
            sortDown.putClientProperty("$selected.toolTipText", I18n._((String)"bean.sort.down.tip"));
            sortDown.putClientProperty("$not.selected.toolTipText", I18n._((String)"bean.sort.down.toSelect.tip"));
            sortUp.putClientProperty("$selected.toolTipText", I18n._((String)"bean.sort.up.tip"));
            sortUp.putClientProperty("$not.selected.toolTipText", I18n._((String)"bean.sort.up.toSelect.tip"));
            popupLabel.setText(title);
            this.getPopup().setLabel(title);
            this.getPopup().invalidate();
        }
    }
}

