/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor.bean;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.bean.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class BeanListHeader<O> extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN_TYPE = "beanType";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_I18N_PREFIX = "i18nPrefix";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_LABEL_TEXT = "labelText";
    public static final String PROPERTY_LIST = "list";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_TITLE_TEXT = "popupTitleText";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CHANGE_DECORATOR_VISIBLE = "changeDecorator.visible";
    public static final String BINDING_LABEL_TEXT = "label.text";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_GROUP_SELECTED_VALUE = "sortGroup.selectedValue";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHEc24nTEohaWiSTpkdsigAVpYKShjSJHIhig6IaIWa9E3uqyc52Z9bZCAlx4MIN8RfAnQsSN06IQy9ceoAD4l9AiANXxHu79q7XrL1LnMOmfT+++d43773Jt3+QvHLIi4+o59Uc19L8lNX23z4+fs94xDp6m6mOw20tHRL8zOVIrk3KZmhXmtxsNzC9Pkiv35entrSYNZK92SAlpc8FUz3GtCYvxDM6StWboXvTs11niBqSSkL9+q8/c1+an32TI8Szgd11KKWalhVVMt8gOW5q8gyc1Kd1Qa0u0HC41QW+y2i7L6hS79JT9ph8SgoNsmBTB8A0Wc9eso/h53u2Jpe0hO9LMZLqDI6sMZNDWs1g1KptwafBld5l1GSObfv5C5oUVU+eHTGFGl5BgjUkXduSUkBGFLeMcdusIx0KmGisRM6yw/rMUawpHT3mWkQS1BBs3I6sWuc202QlOtavbIScoAYTLeYBuctRVKBoFJbnlgkxo/z3LM26o3XOm1RTTSp+iKu5qKEakb/gYzBovvUEJbF/t1ytpfXAka49Kh+U7NvQcHMEr0ctUzBHk1f/183sBmkR0KpiAuaGmS24kha3UQ10PR+FrFlSN1OjKra0XbvFtWAJ3hK/fcc6dNgJ98Y8eT8PTkHpvKEgh2g8YJY7fgD2QAOvDaYgluEbMfR2mLGA6r0P2NVY5BE1uQzkxhP2NDuN5y1i3rY8s/D/b8R9Sxv7TQZDhW368jjr0BPPKfnMQ4Kvx73zAm5n0F1RNWBDfzHSScTyI0dpYx9vZYsin2djKAN7PL64sR8UD+GrsfDAjGE7YfRKBzqty8LR1OTa2BHdrmCxTIdcj/UkLMtatCyjbTbXJnnHFTgUV9v/3a9H4Ao269WxzYqAvveftdVffvj9+53hOq3C2c8lho68BrDmbEfaMDscj14JdinObP2A2pttGDq/2f2n4kYCsebADeTgvCvRyO9S1QOIfOG3H39a+/jpJZLbISUhqblDMX6PFHXPARWkMD37rXs+o6WzRfheRm7QsIKeS5CSVO7iPqkasDVA5Tc9EOFGggghE6P45O/V5nf3hkLMAbFrE8MjMfIPyQK3BLeY/7IMHo3El6RsK+aaMnockp6LOfxdGi6wlv89Tqq04io2sktgmO8GPKpUw/o1XM2gakz/0C8H//WRj76eAX15uNQ+oML1C2gng91KBUOzgZ/ORRHgWg3pwO6dwuOVDCjzvBOM2ASM17Jg6MFqnlBNOgaa+1NY3MnAomxEb90UMlmgFoc3PRMlNH8yI5N8P6XXstGYpu1mJoTPpxSSDeGLmTlMEzMbwlczcYCZkzZ9HNzHBB7vZK9kAo90BFhFwewfUm4NunQCnQcZwIon8JqEf+5eGCitz/YzUCkwC3lMm7ssMEsnsuOqdHWyYBV9rBR1sgCVdfyv3BmgCn2u+IDRhWVKu6+DTAhPppSSDeHnmRGezozwa4oO/wIBZDVmIBAAAA==";
    private static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.bean.BeanListHeader.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Class< O > beanType;
    protected javax.swing.JToggleButton changeDecorator;
    protected java.util.List< O > data;
    protected java.lang.Boolean editable;
    protected jaxx.runtime.swing.editor.bean.BeanListHeaderHandler< O > handler;
    protected java.lang.String i18nPrefix;
    protected java.lang.Integer index;
    protected jaxx.runtime.swing.JAXXButtonGroup indexes;
    protected javax.swing.JLabel label;
    protected java.lang.String labelText;
    protected javax.swing.JList list;
    protected java.lang.String notSelectedToolTipText;
    protected javax.swing.JPopupMenu popup;
    protected javax.swing.JLabel popupLabel;
    protected javax.swing.JLabel popupSortLabel;
    protected java.lang.String popupTitleText;
    protected java.lang.Boolean reverseSort;
    protected java.lang.String selectedToolTipText;
    protected java.lang.Boolean showDecorator;
    protected java.lang.Boolean showReset;
    protected javax.swing.JRadioButtonMenuItem sortDown;
    protected jaxx.runtime.swing.JAXXButtonGroup sortGroup;
    protected javax.swing.JRadioButtonMenuItem sortUp;
    protected BeanListHeader top = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JToolBar $JToolBar0;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(JXPathDecorator<O> decorator, java.util.List<O> data) {
        handler.init(decorator, data);
    }
    
    protected void hidePopup() {
        if (popup.isVisible()) {
            popup.setVisible(false);
        }
    }
    
    protected Object updateSort(boolean reverseSort) {
        if (reverseSort) {
           return sortDown;
        }
        return sortUp;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanListHeader() {
        $initialize();
    }

    public BeanListHeader(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getList().getSelectionModel().clearSelection();
    }

    public void doActionPerformed__on__changeDecorator(java.awt.event.ActionEvent event) {
        getHandler().togglePopup();
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        getChangeDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        getChangeDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(javax.swing.event.ChangeEvent event) {
        setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(javax.swing.event.ChangeEvent event) {
        setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Class< O > getBeanType() {
        return beanType;
    }

    public javax.swing.JToggleButton getChangeDecorator() {
        return changeDecorator;
    }

    public java.util.List< O > getData() {
        return data;
    }

    public java.lang.Boolean getEditable() {
        return editable;
    }

    public jaxx.runtime.swing.editor.bean.BeanListHeaderHandler< O > getHandler() {
        return handler;
    }

    public java.lang.String getI18nPrefix() {
        return i18nPrefix;
    }

    public java.lang.Integer getIndex() {
        return index;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public javax.swing.JLabel getLabel() {
        return label;
    }

    public java.lang.String getLabelText() {
        return labelText;
    }

    public javax.swing.JList getList() {
        return list;
    }

    public java.lang.String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public javax.swing.JLabel getPopupLabel() {
        return popupLabel;
    }

    public javax.swing.JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public java.lang.String getPopupTitleText() {
        return popupTitleText;
    }

    public java.lang.Boolean getReverseSort() {
        return reverseSort;
    }

    public java.lang.String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public java.lang.Boolean getShowDecorator() {
        return showDecorator;
    }

    public java.lang.Boolean getShowReset() {
        return showReset;
    }

    public javax.swing.JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public javax.swing.JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public java.lang.Boolean isEditable() {
        return editable !=null && editable;
    }

    public java.lang.Boolean isReverseSort() {
        return reverseSort !=null && reverseSort;
    }

    public java.lang.Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public java.lang.Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBeanType(java.lang.Class< O > newValue) {
        java.lang.Class< O > oldValue = this.beanType;
        this.beanType = newValue;
        firePropertyChange(PROPERTY_BEAN_TYPE, oldValue, newValue);
    }

    public void setData(java.util.List< O > newValue) {
        java.util.List< O > oldValue = this.data;
        this.data = newValue;
        firePropertyChange(PROPERTY_DATA, oldValue, newValue);
    }

    public void setEditable(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.editable;
        this.editable = newValue;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, newValue);
    }

    public void setI18nPrefix(java.lang.String newValue) {
        java.lang.String oldValue = this.i18nPrefix;
        this.i18nPrefix = newValue;
        firePropertyChange(PROPERTY_I18N_PREFIX, oldValue, newValue);
    }

    public void setIndex(java.lang.Integer newValue) {
        java.lang.Integer oldValue = this.index;
        this.index = newValue;
        firePropertyChange(PROPERTY_INDEX, oldValue, newValue);
    }

    public void setLabelText(java.lang.String newValue) {
        java.lang.String oldValue = this.labelText;
        this.labelText = newValue;
        firePropertyChange(PROPERTY_LABEL_TEXT, oldValue, newValue);
    }

    public void setList(javax.swing.JList newValue) {
        javax.swing.JList oldValue = this.list;
        this.list = newValue;
        firePropertyChange(PROPERTY_LIST, oldValue, newValue);
    }

    public void setNotSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = newValue;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setPopupTitleText(java.lang.String newValue) {
        java.lang.String oldValue = this.popupTitleText;
        this.popupTitleText = newValue;
        firePropertyChange(PROPERTY_POPUP_TITLE_TEXT, oldValue, newValue);
    }

    public void setReverseSort(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.reverseSort;
        this.reverseSort = newValue;
        firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, newValue);
    }

    public void setSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = newValue;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setShowDecorator(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showDecorator;
        this.showDecorator = newValue;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, newValue);
    }

    public void setShowReset(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showReset;
        this.showReset = newValue;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add($JSeparator0);
        popup.add(popupLabel);
    }

    protected void addChildrenToSortDown() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToTop() {
        if (!allComponentsCreated) {
            return;
        }
        add(list);
        add(label, BorderLayout.CENTER);
        add($JToolBar0, BorderLayout.EAST);
    }

    protected void createBeanType() {
        $objectMap.put("beanType", beanType = null);
    }

    protected void createChangeDecorator() {
        $objectMap.put("changeDecorator", changeDecorator = new javax.swing.JToggleButton());
        
        changeDecorator.setName("changeDecorator");
        changeDecorator.setFocusPainted(false);
        changeDecorator.setFocusable(false);
        changeDecorator.setToolTipText(_("beanlist.action.sort.tip"));
        changeDecorator.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeDecorator"));
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.runtime.swing.editor.bean.BeanListHeaderHandler< O >(this));
    }

    protected void createI18nPrefix() {
        $objectMap.put("i18nPrefix", i18nPrefix = "beanlist.common.");
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new jaxx.runtime.swing.JAXXButtonGroup());
        
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createLabel() {
        $objectMap.put("label", label = new javax.swing.JLabel());
        
        label.setName("label");
        label.setOpaque(false);
    }

    protected void createLabelText() {
        $objectMap.put("labelText", labelText = null);
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new javax.swing.JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new javax.swing.JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new javax.swing.JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(_("bean.sort.label"));
    }

    protected void createPopupTitleText() {
        $objectMap.put("popupTitleText", popupTitleText = null);
    }

    protected void createReverseSort() {
        $objectMap.put("reverseSort", reverseSort = false);
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new javax.swing.JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(_("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new jaxx.runtime.swing.JAXXButtonGroup());
        
        sortGroup.setUseToolTipText(true);
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new javax.swing.JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(_("bean.sort.up"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToTop();
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        // inline complete setup of $JToolBar0
        $JToolBar0.add($JButton0);
        $JToolBar0.add(changeDecorator);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        popup.setBorder(new TitledBorder(_("beanlist.popup.title")));
        popupSortLabel.setIcon(jaxx.runtime.SwingUtil.createActionIcon("bean-sort"));
        sortUp.setIcon(jaxx.runtime.SwingUtil.createActionIcon("bean-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(jaxx.runtime.SwingUtil.createActionIcon("bean-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        $JButton0.setIcon(jaxx.runtime.SwingUtil.createActionIcon("combobox-reset"));
        changeDecorator.setIcon(jaxx.runtime.SwingUtil.createActionIcon("combobox-sort"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("top", this);
        createShowReset();
        createShowDecorator();
        createReverseSort();
        createEditable();
        createBeanType();
        createLabelText();
        createIndex();
        createData();
        createIndexes();
        createSortGroup();
        createHandler();
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupTitleText();
        createI18nPrefix();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createPopupLabel();
        createList();
        createLabel();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new javax.swing.JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setFocusPainted(false);
        $JButton0.setFocusable(false);
        $JButton0.setToolTipText(_("beanlist.action.reset.tip"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createChangeDecorator();
        // inline creation of top
        setName("top");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_GROUP_SELECTED_VALUE, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortGroup.setSelectedValue(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_UP_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortUp.setSelected(!isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_DOWN_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortDown.setSelected(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT, true ,"labelText") {
        
            @Override
            public void processDataBinding() {
                label.setText(_(SwingUtil.getStringValue(getLabelText())));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CHANGE_DECORATOR_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                changeDecorator.setVisible(isShowDecorator());
            }
        });
    }

}