/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.swing.ComponentMover;
import org.nuiton.jaxx.runtime.swing.ComponentResizer;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.validator.swing.SwingListValidatorDataLocator;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableModel;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessageTableRenderer;
import org.nuiton.jaxx.validator.swing.SwingValidatorUtil;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.list.BeanListValidator;

public class SwingListValidatorMessageWidget
extends JToggleButton {
    private static final Log log = LogFactory.getLog(SwingListValidatorMessageWidget.class);
    private static final long serialVersionUID = 1L;
    public static final String CLOSE_DIALOG_ACTION = "closeDialog";
    protected final SwingListValidatorMessageTableModel messageTableModel = new SwingListValidatorMessageTableModel();
    protected final JDialog popup = new JDialog();
    protected final JTable messageTable = new JTable();
    protected Point popupPosition = null;

    public SwingListValidatorMessageWidget() {
        super(SwingUtil.createActionIcon((String)"alert-none"));
        this.setToolTipText(I18n.t((String)"validator.messageWidget.alert.none", (Object[])new Object[0]));
        this.messageTableModel.addTableModelListener(e -> {
            String icon;
            String label;
            int alerts = this.messageTableModel.getRowCount();
            switch (alerts) {
                case 0: {
                    label = I18n.n((String)"validator.messageWidget.alert.none", (Object[])new Object[0]);
                    break;
                }
                case 1: {
                    label = I18n.n((String)"validator.messageWidget.alert.one", (Object[])new Object[0]);
                    break;
                }
                default: {
                    label = I18n.n((String)"validator.messageWidget.alert.several", (Object[])new Object[0]);
                }
            }
            if (alerts == 0) {
                icon = "alert-none";
            } else {
                NuitonValidatorScope maxScope = NuitonValidatorScope.INFO;
                for (int i = 0; i < alerts; ++i) {
                    NuitonValidatorScope scope = this.messageTableModel.getRow(i).getScope();
                    int diff = scope.compareTo((Enum)maxScope);
                    if (diff >= 0) continue;
                    maxScope = scope;
                }
                switch (maxScope) {
                    case INFO: {
                        icon = "alert-info";
                        break;
                    }
                    case WARNING: {
                        icon = "alert-warning";
                        break;
                    }
                    default: {
                        icon = "alert-error";
                    }
                }
            }
            this.setToolTipText(I18n.t((String)label, (Object[])new Object[]{alerts}));
            this.setIcon(SwingUtil.createActionIcon((String)icon));
        });
        this.messageTable.setModel(this.messageTableModel);
        this.messageTable.setRowSelectionAllowed(true);
        this.messageTable.setAutoCreateRowSorter(true);
        this.messageTable.setAutoResizeMode(2);
        this.messageTable.setCellSelectionEnabled(false);
        this.messageTable.setSelectionMode(0);
        this.messageTable.setFillsViewportHeight(true);
        SwingValidatorUtil.installUI(this.messageTable, new SwingListValidatorMessageTableRenderer());
        JScrollPane scrollPanel = new JScrollPane(this.messageTable);
        scrollPanel.setColumnHeaderView(this.messageTable.getTableHeader());
        JXTitledPanel titledPanel = new JXTitledPanel(I18n.t((String)"validator.messageWidget.title", (Object[])new Object[0]), (Container)scrollPanel);
        this.popup.add((Component)titledPanel);
        this.popup.setTitle(I18n.t((String)"validator.messageWidget.title", (Object[])new Object[0]));
        this.popup.setSize(800, 300);
        this.popup.setAlwaysOnTop(true);
        this.popup.setUndecorated(true);
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(new Component[]{this.popup});
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(new Component[]{this.popup});
        this.popup.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingListValidatorMessageWidget.this.setSelected(false);
            }
        });
        this.popup.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Component component = e.getComponent();
                if (component.isShowing()) {
                    SwingListValidatorMessageWidget.this.popupPosition = component.getLocationOnScreen();
                }
            }
        });
        this.addActionListener(e -> {
            if (this.isSelected()) {
                this.popup.setVisible(true);
            } else {
                this.popup.dispose();
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (SwingListValidatorMessageWidget.this.popupPosition == null && SwingListValidatorMessageWidget.this.isShowing()) {
                    Point point = new Point(SwingListValidatorMessageWidget.this.getLocationOnScreen());
                    point.translate(-SwingListValidatorMessageWidget.this.popup.getWidth() + SwingListValidatorMessageWidget.this.getWidth(), -SwingListValidatorMessageWidget.this.popup.getHeight());
                    SwingListValidatorMessageWidget.this.popup.setLocation(point);
                }
            }
        });
        JRootPane rootPane = this.popup.getRootPane();
        KeyStroke shortcutClosePopup = KeyStroke.getKeyStroke(27, 0);
        rootPane.getInputMap(2).put(shortcutClosePopup, CLOSE_DIALOG_ACTION);
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingListValidatorMessageWidget.this.popup.dispose();
                SwingListValidatorMessageWidget.this.setSelected(false);
            }
        };
        ImageIcon actionIcon = SwingUtil.createActionIcon((String)"close-dialog");
        closeAction.putValue("SmallIcon", actionIcon);
        closeAction.putValue("SwingLargeIconKey", actionIcon);
        closeAction.putValue("ActionCommandKey", "close");
        closeAction.putValue("Name", "close");
        closeAction.putValue("ShortDescription", I18n.t((String)"validator.messageWidget.closeDialog.tip", (Object[])new Object[0]));
        rootPane.getActionMap().put(CLOSE_DIALOG_ACTION, closeAction);
        JButton closeButton = new JButton(closeAction);
        closeButton.setText(null);
        closeButton.setFocusPainted(false);
        closeButton.setRequestFocusEnabled(false);
        closeButton.setFocusable(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOpaque(false);
        jToolBar.add(closeAction);
        jToolBar.setBorderPainted(false);
        jToolBar.setFloatable(false);
        titledPanel.setRightDecoration((JComponent)jToolBar);
    }

    public void addTableModelListener(TableModelListener listener) {
        this.messageTableModel.addTableModelListener(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.messageTableModel.removeTableModelListener(listener);
    }

    public void setDefaultRenderer(TableCellRenderer renderer) {
        this.messageTable.setDefaultRenderer(Object.class, renderer);
    }

    public void registerValidator(BeanListValidator validator, JTable dataTable, SwingListValidatorDataLocator dataLocator) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Register validator: " + validator));
        }
        SwingValidatorUtil.registerListValidator(validator, this.messageTableModel, dataTable, this.messageTable, dataLocator);
        validator.doValidate();
    }

    public void clearValidators() {
        this.messageTableModel.clearValidators();
        this.messageTableModel.clear();
    }
}

