/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.validator.swing.SwingValidator;
import org.nuiton.jaxx.validator.swing.SwingValidatorMessage;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorEvent;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorListener;

public class SwingValidatorMessageTableModel
extends AbstractTableModel
implements SimpleBeanValidatorListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SwingValidatorMessageTableModel.class);
    public static final String[] columnNames = new String[]{"validator.scope", "validator.field", "validator.message"};
    public static final Class<?>[] columnClasses = new Class[]{NuitonValidatorScope.class, String.class, String.class};
    protected final transient List<SwingValidator<?>> validators = new ArrayList();
    protected final List<SwingValidatorMessage> data = new ArrayList<SwingValidatorMessage>();

    public void registerValidator(SwingValidator<?> validator) {
        if (this.validators.contains(validator)) {
            throw new IllegalArgumentException("the validator " + validator + " is already registred in " + this);
        }
        this.validators.add(validator);
        validator.addSimpleBeanValidatorListener(this);
    }

    public void addMessages(SwingValidator<?> validator, String fieldName, NuitonValidatorScope scope, String ... messages) {
        this.addMessages(validator, fieldName, scope, true, messages);
    }

    public void addMessages(JComponent editor, String fieldName, NuitonValidatorScope scope, String ... messages) {
        this.addMessages(editor, fieldName, scope, true, messages);
    }

    public void removeMessages(JComponent editor, NuitonValidatorScope scope) {
        if (editor == null) {
            return;
        }
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            SwingValidatorMessage error = this.data.get(i);
            if (!editor.equals(error.getEditor()) || scope != null && error.getScope() != scope) continue;
            this.data.remove(i);
            this.fireTableRowsDeleted(i, i);
        }
    }

    public void removeMessages(SwingValidator<?> validator, String fieldName, NuitonValidatorScope scope, String ... messages) {
        this.removeMessages(validator, fieldName, scope, true, messages);
    }

    public void removeMessages(JComponent editor, String fieldName, NuitonValidatorScope scope) {
        this.removeMessages(editor, fieldName, scope, true);
    }

    public void clear() {
        int i = this.data.size();
        if (i > 0) {
            this.data.clear();
            this.fireTableRowsDeleted(0, i - 1);
        }
    }

    public void clearValidators() {
        for (SwingValidator<?> v : this.validators) {
            v.removeSimpleBeanValidatorListener(this);
        }
        this.validators.clear();
    }

    public SwingValidatorMessage getRow(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        return this.data.get(rowIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)columnIndex);
        return columnClasses[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)column);
        return columnNames[column];
    }

    public void onFieldChanged(SimpleBeanValidatorEvent event) {
        boolean mustDel;
        String[] toDelete = event.getMessagesToDelete();
        String[] toAdd = event.getMessagesToAdd();
        String field = event.getField();
        NuitonValidatorScope scope = event.getScope();
        boolean mustAdd = toAdd != null && toAdd.length > 0;
        boolean bl = mustDel = toDelete != null && toDelete.length > 0;
        if (log.isTraceEnabled()) {
            log.trace((Object)"----------------------------------------------------------");
            log.trace((Object)(field + " - (" + this.getRowCount() + ") toAdd     " + mustAdd));
            log.trace((Object)(field + " - (" + this.getRowCount() + ") toDelete  " + mustDel));
        }
        SwingValidator validator = (SwingValidator)((Object)event.getSource());
        if (mustDel) {
            this.removeMessages(validator, field, scope, !mustAdd, toDelete);
        }
        if (mustAdd) {
            this.addMessages(validator, field, scope, true, toAdd);
        }
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)columnIndex);
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        SwingValidatorMessage row = this.data.get(rowIndex);
        if (columnIndex == 0) {
            return row.getScope();
        }
        if (columnIndex == 1) {
            return row.getField();
        }
        if (columnIndex == 2) {
            return row.getMessage();
        }
        return null;
    }

    protected void addMessages(SwingValidator<?> validator, String fieldName, NuitonValidatorScope scope, boolean sort, String ... messages) {
        JComponent editor = validator == null ? null : validator.getFieldRepresentation(fieldName);
        for (String error : messages) {
            SwingValidatorMessage row = new SwingValidatorMessage(validator, fieldName, error, scope, editor);
            this.data.add(row);
            if (sort) continue;
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    protected void addMessages(JComponent editor, String fieldName, NuitonValidatorScope scope, boolean sort, String ... messages) {
        for (String error : messages) {
            SwingValidatorMessage row = new SwingValidatorMessage(null, fieldName, error, scope, editor);
            this.data.add(row);
            if (sort) continue;
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    protected void removeMessages(SwingValidator<?> validator, String fieldName, NuitonValidatorScope scope, boolean notify, String ... messages) {
        ArrayList<String> messagesToDel = new ArrayList<String>(Arrays.asList(messages));
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            SwingValidatorMessage error = this.data.get(i);
            if (!((Object)validator).equals(error.getValidator()) || error.getScope() != scope || !error.getField().equals(fieldName) || !messagesToDel.contains(error.getMessage())) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }

    protected void removeMessages(JComponent editor, String fieldName, NuitonValidatorScope scope, boolean notify) {
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            SwingValidatorMessage error = this.data.get(i);
            if (!editor.equals(error.getEditor()) || scope != null && error.getScope() != scope || !error.getField().equals(fieldName)) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }
}

