/*
 * Decompiled with CFR 0.152.
 */
package jaxx.demo.config;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

public class DemoConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(DemoConfig.class);
    public static final String APPLICATION_PROPERTIES = "/jaxx-demo.properties";
    public static final String PROPERTY_FULLSCREEN = "fullscreen";
    public static final String PROPERTY_LOCALE = "locale";
    public static final String PROPERTY_FONT_SIZE = "fontSize";

    public DemoConfig() {
        this.setConfigFileName(Option.CONFIG_FILE.defaultValue);
        for (Option o : Option.values()) {
            this.setDefaultOption(o.key, o.defaultValue);
        }
        this.installSaveUserAction(new String[]{PROPERTY_FULLSCREEN, PROPERTY_FONT_SIZE, PROPERTY_LOCALE});
    }

    public boolean isFullScreen() {
        Boolean result = this.getOptionAsBoolean(Option.FULL_SCREEN.key);
        return result != null && result != false;
    }

    public Locale getLocale() {
        Locale result = (Locale)this.getOption(Locale.class, Option.LOCALE.key);
        return result;
    }

    public Float getFontSize() {
        Float result = (Float)this.getOption(Float.class, Option.FONT_SIZE.key);
        return result;
    }

    public void setFullscreen(boolean fullscreen) {
        Object oldValue = null;
        this.setOption(Option.FULL_SCREEN.key, fullscreen + "");
        this.firePropertyChange(PROPERTY_FULLSCREEN, oldValue, fullscreen);
    }

    public void setLocale(Locale newLocale) {
        this.setOption(Option.LOCALE.key, newLocale.toString());
        this.firePropertyChange(PROPERTY_LOCALE, null, newLocale);
    }

    public void setFontSize(Float newFontSize) {
        Float oldValue = this.getFontSize();
        if (log.isDebugEnabled()) {
            log.debug((Object)("changing font-size to " + newFontSize));
        }
        this.setOption(Option.FONT_SIZE.key, newFontSize.toString());
        this.firePropertyChange(PROPERTY_FONT_SIZE, oldValue, newFontSize);
    }

    public static enum Option implements ApplicationConfig.OptionDef
    {
        CONFIG_FILE("config.file", I18n._((String)"jaxxdemo.config.configFileName.description", (Object[])new Object[0]), "jaxxdemo", String.class, true, true),
        FULL_SCREEN("ui.fullscreen", I18n._((String)"jaxxdemo.config.ui.fullscreen", (Object[])new Object[0]), "false", Boolean.class, false, false),
        LOCALE("ui.locale", I18n._((String)"jaxxdemo.config.ui.locale", (Object[])new Object[0]), Locale.FRANCE.toString(), Locale.class, false, false),
        FONT_SIZE("ui.fontSize", I18n._((String)"jaxxdemo.config.ui.fontSize", (Object[])new Object[0]), "10f", Float.class, false, false);

        public final String key;
        public final String description;
        public String defaultValue;
        public final Class<?> type;
        public boolean _transient;
        public boolean _final;

        private Option(String key, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this._final = _final;
            this._transient = _transient;
        }

        public boolean isFinal() {
            return this._final;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setTransient(boolean _transient) {
            this._transient = _transient;
        }

        public void setFinal(boolean _final) {
            this._final = _final;
        }

        public boolean isTransient() {
            return this._transient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

